/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.Category;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.Widget;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.WidgetType;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.WidgetTypeJsonDataInsert;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.CategoryRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.WidgetRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.WidgetTypeJsonDataInsertRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.WidgetTypeRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.DashboardGroup;
import com.coraltele.telemetry.db.telemetry.main.entity.DeviceModel;
import com.coraltele.telemetry.db.telemetry.main.entity.MonitorService;
import com.coraltele.telemetry.db.telemetry.main.entity.Severity;
import com.coraltele.telemetry.db.telemetry.main.repository.DashboardGroupRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.DeviceModelRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.MonitorServiceRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.SeverityRepository;
import com.coraltele.telemetry.helper.JsonUtils;
import com.coraltele.telemetry.model.DeviceDetailModel;
import com.coraltele.telemetry.model.MonitorServiceJsonModel;
import com.coraltele.telemetry.service.coralnms.category.model.CategoryJsonInsertModel;
import com.coraltele.telemetry.service.coralnms.widget.model.WidgetJsonDataModel;
import com.coraltele.telemetry.service.coralnms.widget_type.model.WidgetTypeFileListModel;
import com.coraltele.telemetry.service.main.alertHistory.model.DashboardGroupModel;
import com.fasterxml.jackson.core.type.TypeReference;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Optional;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class BootstrapProcess {
    private static final Logger logger = LogManager.getLogger(BootstrapProcess.class);
    @Autowired
    private SeverityRepository severityRepository;
    @Autowired
    private WidgetTypeJsonDataInsertRepository widgetTypeJsonDataInsertRepository;
    @Autowired
    private WidgetTypeRepository widgetTypeRepository;
    @Autowired
    private DashboardGroupRepository dashboardGroupRepository;
    @Autowired
    private WidgetRepository widgetRepository;
    @Autowired
    @Qualifier(value="telemetryJdbcTemplate")
    private JdbcTemplate telemetryJdbcTemplate;
    @Autowired
    private CategoryRepository categoryRepository;
    @Autowired
    private MonitorServiceRepository monitorServiceRepository;
    @Autowired
    private DeviceModelRepository deviceModelRepository;

    @PostConstruct
    public void bootstrap() {
        this.createSeverity();
        this.createAndUpdateWidgetType();
        this.createAndUpdateDashboardGroup();
        this.createAndUpdateCategories();
        this.createAndUpdateWidgets();
        this.createOrUpdateService();
        this.createOrUpdateDeviceModel();
    }

    private void createSeverity() {
        try {
            List severities = this.severityRepository.findAll();
            if (severities.isEmpty()) {
                severities.add(new Severity("50107c2a-29e8-4104-9fcf-5ab7a55a2fce", Integer.valueOf(3), "major", "#e16689"));
                severities.add(new Severity("69495893-be13-410e-987e-6286ce3a39c6", Integer.valueOf(2), "minor", "#0ecaf0"));
                severities.add(new Severity("a9c40493-e146-4578-8c42-dd1721a058f1", Integer.valueOf(4), "critical", "#113bdc"));
                severities.add(new Severity("afd9df53-5680-467a-a485-e53ed8d27979", Integer.valueOf(1), "warning", "#d6d281"));
                severities.add(new Severity("fa9e4775-31f4-4395-b100-57f74c7b8f43", Integer.valueOf(0), "ok", "#7eea80"));
                this.severityRepository.saveAll((Iterable)severities);
                logger.info("5 default severities are saved successfully {}", (Object)severities);
            } else {
                logger.info("Number of Severities are exits {}", (Object)severities.size());
            }
        }
        catch (Exception e) {
            logger.error("error are found in saved severities {}", (Object)e.getMessage());
        }
    }

    private void createAndUpdateWidgetType() {
        try {
            List widgetTypeDataList = JsonUtils.readListFromJson((String)"default-data/widget_type.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            for (WidgetTypeFileListModel widgetType : widgetTypeDataList) {
                Optional widgetTypeDataOptional = this.widgetTypeJsonDataInsertRepository.findById(widgetType.getId());
                if (widgetTypeDataOptional.isPresent()) {
                    WidgetTypeJsonDataInsert existingWidgetType = (WidgetTypeJsonDataInsert)widgetTypeDataOptional.get();
                    boolean isUpdated = false;
                    if (!StringUtils.hasText((String)existingWidgetType.getCode()) || !existingWidgetType.getCode().equals(widgetType.getCode())) {
                        existingWidgetType.setCode(widgetType.getCode());
                        isUpdated = true;
                    }
                    if (!StringUtils.hasText((String)existingWidgetType.getDescription()) || !existingWidgetType.getDescription().equals(widgetType.getDescription())) {
                        existingWidgetType.setDescription(widgetType.getDescription());
                        isUpdated = true;
                    }
                    if (existingWidgetType.isExport() != widgetType.getExport().booleanValue()) {
                        existingWidgetType.setExport(widgetType.getExport().booleanValue());
                        isUpdated = true;
                    }
                    if (!isUpdated) continue;
                    this.widgetTypeJsonDataInsertRepository.save((Object)existingWidgetType);
                    continue;
                }
                WidgetTypeJsonDataInsert newWidgetType = new WidgetTypeJsonDataInsert();
                newWidgetType.setId(widgetType.getId());
                newWidgetType.setCode(widgetType.getCode());
                newWidgetType.setDescription(widgetType.getDescription());
                newWidgetType.setExport(widgetType.getExport().booleanValue());
                this.widgetTypeJsonDataInsertRepository.save((Object)newWidgetType);
            }
            this.syncWidgetTypeSequence();
        }
        catch (Exception e) {
            logger.error("Error occurred while saving widget types: {} {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void syncWidgetTypeSequence() {
        try {
            this.telemetryJdbcTemplate.execute("SELECT setval(pg_get_serial_sequence('coralnms.widget_type', 'id'), COALESCE((SELECT MAX(id) FROM coralnms.widget_type), 1), true)");
            logger.info("Synced widget_type_id_seq successfully.");
        }
        catch (Exception e) {
            logger.error("Failed to sync widget_type_id_seq: {} {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void createAndUpdateDashboardGroup() {
        try {
            List dashboardGroupDataList = JsonUtils.readListFromJson((String)"default-data/dashboard_group.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            for (DashboardGroupModel dashboardData : dashboardGroupDataList) {
                Optional dashboardGroupDataOptional = this.dashboardGroupRepository.findById(dashboardData.getId());
                if (dashboardGroupDataOptional.isPresent()) {
                    DashboardGroup existingDashboard = (DashboardGroup)dashboardGroupDataOptional.get();
                    boolean isUpdated = false;
                    if (!StringUtils.hasText((String)existingDashboard.getCode()) || !existingDashboard.getCode().equals(dashboardData.getCode())) {
                        existingDashboard.setCode(dashboardData.getCode());
                        isUpdated = true;
                    }
                    if (!StringUtils.hasText((String)existingDashboard.getName()) || !existingDashboard.getName().equals(dashboardData.getName())) {
                        existingDashboard.setName(dashboardData.getName());
                        isUpdated = true;
                    }
                    if (!StringUtils.hasText((String)existingDashboard.getIcon()) || !existingDashboard.getIcon().equals(dashboardData.getIcon())) {
                        existingDashboard.setIcon(dashboardData.getIcon());
                        isUpdated = true;
                    }
                    if (!isUpdated) continue;
                    this.dashboardGroupRepository.save((Object)existingDashboard);
                    continue;
                }
                DashboardGroup newGroup = new DashboardGroup();
                newGroup.setId(dashboardData.getId());
                newGroup.setCode(dashboardData.getCode());
                newGroup.setName(dashboardData.getName());
                newGroup.setIcon(dashboardData.getIcon());
                this.dashboardGroupRepository.save((Object)newGroup);
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while saving dashboard group: {} {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void createAndUpdateCategories() {
        try {
            List categoriesDataList = JsonUtils.readListFromJson((String)"default-data/m_category.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            for (CategoryJsonInsertModel categoryModel : categoriesDataList) {
                Optional existingOpt = this.categoryRepository.findByCode(categoryModel.getCode());
                if (existingOpt.isPresent()) {
                    Category existing = (Category)existingOpt.get();
                    boolean isUpdated = false;
                    if (!StringUtils.hasText((String)existing.getDescription())) {
                        existing.setDescription(categoryModel.getDescription());
                        isUpdated = true;
                    }
                    if (!StringUtils.hasText((String)existing.getManagementURL())) {
                        existing.setManagementURL(categoryModel.getManagementURL());
                        isUpdated = true;
                    }
                    if (!StringUtils.hasText((String)existing.getSvgIcon())) {
                        existing.setSvgIcon(categoryModel.getSvgIcon());
                        isUpdated = true;
                    }
                    if (existing.getHasManagementInterface() == null) {
                        existing.setHasManagementInterface(categoryModel.getHasManagementInterface());
                        isUpdated = true;
                    }
                    if (existing.getHasSelfDashboard() == null) {
                        existing.setHasSelfDashboard(categoryModel.getHasSelfDashboard());
                        isUpdated = true;
                    }
                    if (!StringUtils.hasText((String)existing.getImageName())) {
                        existing.setImageName(categoryModel.getImageName());
                        isUpdated = true;
                    }
                    if (existing.getHeight() == null) {
                        existing.setHeight(categoryModel.getHeight());
                        isUpdated = true;
                    }
                    if (existing.getWidth() == null) {
                        existing.setWidth(categoryModel.getWidth());
                        isUpdated = true;
                    }
                    if (existing.getExport() == null) {
                        existing.setExport(categoryModel.getExport());
                        isUpdated = true;
                    }
                    if (existing.getSendEmail() == null) {
                        existing.setSendEmail(categoryModel.getSendEmail());
                        isUpdated = true;
                    }
                    if (existing.getSendSms() == null) {
                        existing.setSendSms(categoryModel.getSendSms());
                        isUpdated = true;
                    }
                    if (!StringUtils.hasText((String)existing.getEmailId())) {
                        existing.setEmailId(categoryModel.getEmailId());
                        isUpdated = true;
                    }
                    if (!StringUtils.hasText((String)existing.getMobileNo())) {
                        existing.setMobileNo(categoryModel.getMobileNo());
                        isUpdated = true;
                    }
                    if (!isUpdated) continue;
                    this.categoryRepository.save((Object)existing);
                    logger.info("Updated category with code: {}", (Object)categoryModel.getCode());
                    continue;
                }
                Category newCategory = new Category();
                newCategory.setCode(categoryModel.getCode());
                newCategory.setDescription(categoryModel.getDescription());
                newCategory.setManagementURL(categoryModel.getManagementURL());
                newCategory.setHasManagementInterface(categoryModel.getHasManagementInterface());
                newCategory.setHasSelfDashboard(categoryModel.getHasSelfDashboard());
                newCategory.setImageName(categoryModel.getImageName());
                newCategory.setHeight(categoryModel.getHeight());
                newCategory.setWidth(categoryModel.getWidth());
                newCategory.setExport(categoryModel.getExport());
                newCategory.setSendEmail(categoryModel.getSendEmail());
                newCategory.setSendSms(categoryModel.getSendSms());
                newCategory.setEmailId(categoryModel.getEmailId());
                newCategory.setMobileNo(categoryModel.getMobileNo());
                newCategory.setSvgIcon(categoryModel.getSvgIcon());
                this.categoryRepository.save((Object)newCategory);
                logger.info("Inserted new category with code: {}", (Object)categoryModel.getCode());
            }
        }
        catch (Exception e) {
            logger.error("Error occurred while updating or creating categories: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void createAndUpdateWidgets() {
        try {
            List widgetDataList = JsonUtils.readListFromJson((String)"default-data/widget.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            for (WidgetJsonDataModel widgetData : widgetDataList) {
                Optional widgetOptional = this.widgetRepository.findByCode(widgetData.getCode());
                Widget widget = widgetOptional.orElse(new Widget());
                widget.setUuid(widgetData.getUuid());
                widget.setName(widgetData.getName());
                widget.setCode(widgetData.getCode());
                widget.setChartType(widgetData.getChartType());
                widget.setApiURL(widgetData.getApiURL());
                widget.setThresholdLower(widgetData.getThresholdLower());
                widget.setThresholdUpper(widgetData.getThresholdUpper());
                widget.setSensorAttribute(widgetData.getSensorAttribute());
                widget.setLocation(widgetData.getLocation());
                widget.setLegendField(widgetData.getLegendField());
                widget.setValueField(widgetData.getValueField());
                widget.setColumns(widgetData.getColumns());
                widget.setActions(widgetData.getActions());
                widget.setLegendFieldDataType(widgetData.getLegendFieldDataType());
                widget.setValueFieldDataType(widgetData.getValueFieldDataType());
                widget.setShowLegends(widgetData.getShowLegends());
                widget.setRefreshInterval(widgetData.getRefreshInterval());
                if (!StringUtils.hasText((String)widget.getImageName()) && StringUtils.hasText((String)widgetData.getImageName())) {
                    widget.setImageName(widgetData.getImageName());
                }
                widget.setWidth(widgetData.getWidth());
                widget.setHeight(widgetData.getHeight());
                widget.setMinValue(widgetData.getMinValue());
                widget.setMaxValue(widgetData.getMaxValue());
                widget.setMetricsName(widgetData.getMetricsName());
                widget.setMetricsDataDuration(widgetData.getMetricsDataDuration());
                widget.setMetricsDataDivision(widgetData.getMetricsDataDivision());
                widget.setMetricsInvertValue(widgetData.getMetricsInvertValue());
                widget.setMetricsInstanceName(widgetData.getMetricsInstanceName());
                widget.setCategory(widgetData.getCategory());
                widget.setIsDefaultDashboard(widgetData.getIsDefaultDashboard());
                if (widget.getEnabled() == null) {
                    widget.setEnabled(widgetData.getEnabled());
                }
                widget.setExport(Boolean.TRUE.equals(widgetData.getExport()));
                widget.setDashboardGroup(widgetData.getDashboardGroup());
                widget.setDescription(widgetData.getDescription());
                widget.setHasWebSocketUpdate(widgetData.getHasWebSocketUpdate());
                widget.setUrl(widgetData.getUrl());
                widget.setDashboardLayoutType(widgetData.getDashboardLayoutType());
                widget.setCreatedBy(widgetData.getCreatedBy());
                widget.setCreatedOn(LocalDateTime.now());
                if (widgetData.getWidgetType() != null) {
                    WidgetType widgetType = this.widgetTypeRepository.findById(widgetData.getWidgetType().getId()).orElse(null);
                    widget.setWidgetType(widgetType);
                }
                widget.setApi(null);
                widget.setSensor(null);
                this.widgetRepository.save((Object)widget);
            }
            logger.info("Widget creation/update completed. Total widgets processed: {}", (Object)widgetDataList.size());
        }
        catch (Exception e) {
            logger.error("Error occurred while updating or creating widgets: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void createOrUpdateService() {
        try {
            List serviceDataList = JsonUtils.readListFromJson((String)"default-data/service.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            for (MonitorServiceJsonModel serviceData : serviceDataList) {
                Optional dataToUpdate = this.monitorServiceRepository.findByCode(serviceData.getServiceId());
                if (dataToUpdate.isPresent()) {
                    if (!StringUtils.hasText((String)((MonitorService)dataToUpdate.get()).getServiceName()) || ((MonitorService)dataToUpdate.get()).getServiceName().equalsIgnoreCase(serviceData.getServiceName())) continue;
                    ((MonitorService)dataToUpdate.get()).setServiceName(serviceData.getServiceName());
                    this.monitorServiceRepository.save(dataToUpdate.get());
                    continue;
                }
                MonitorService dataToSave = new MonitorService();
                dataToSave.setCode(serviceData.getServiceId());
                dataToSave.setServiceName(serviceData.getServiceName());
                this.monitorServiceRepository.save((Object)dataToSave);
            }
            logger.info("Monitor Service creation/update completed.");
        }
        catch (Exception e) {
            logger.error("Error occurred while updating or creating service data: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void createOrUpdateDeviceModel() {
        try {
            List deviceDetails = JsonUtils.readListFromJson((String)"default-data/device_model.json", (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
            for (DeviceDetailModel deviceData : deviceDetails) {
                Optional existingDevice = this.deviceModelRepository.findByProductClass(deviceData.getProductClass());
                if (existingDevice.isPresent()) {
                    DeviceModel deviceEntity = (DeviceModel)existingDevice.get();
                    deviceEntity.setOui(deviceData.getOui());
                    deviceEntity.setManufacturer(deviceData.getManufacturer());
                    deviceEntity.setFirmwareVersion(deviceData.getFirmware_version());
                    deviceEntity.setConfigurationVersion(deviceData.getConfiguration_version());
                    this.deviceModelRepository.save((Object)deviceEntity);
                    logger.info("Updated device model: {}", (Object)deviceData.getProductClass());
                    continue;
                }
                DeviceModel newDevice = new DeviceModel();
                newDevice.setOui(deviceData.getOui());
                newDevice.setManufacturer(deviceData.getManufacturer());
                newDevice.setProductClass(deviceData.getProductClass());
                newDevice.setFirmwareVersion(deviceData.getFirmware_version());
                newDevice.setConfigurationVersion(deviceData.getConfiguration_version());
                newDevice.setFormCode(deviceData.getForm_code());
                this.deviceModelRepository.save((Object)newDevice);
                logger.info("Created new device model: {}", (Object)deviceData.getProductClass());
            }
            logger.info("Device model creation/update completed.");
        }
        catch (Exception e) {
            logger.error("Error occurred while updating or creating device model data: {}", (Object)e.getMessage(), (Object)e);
        }
    }
}

