/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.thread;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.MetricsData;
import com.coraltele.telemetry.model.MetricsDataModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MetricsCollectionThread
implements Runnable {
    private static final Logger logger = LogManager.getLogger(MetricsCollectionThread.class);
    public volatile boolean isRunning = true;
    private Thread thread;

    public MetricsCollectionThread() {
        logger.info("Metrics Collection Thread");
        this.thread = new Thread((Runnable)this);
        this.thread.start();
    }

    @Override
    public void run() {
        while (true) {
            logger.info("Attempting to start Metrics Listener at {} ", (Object)Constants.METRICS_LISTENER_PORT);
            try {
                DatagramSocket socket = new DatagramSocket(Constants.METRICS_LISTENER_PORT);
                Throwable throwable = null;
                try {
                    try {
                        byte[] buffer = new byte[1024];
                        while (true) {
                            DatagramPacket packet = new DatagramPacket(buffer, buffer.length);
                            socket.receive(packet);
                            byte[] receivedData = packet.getData();
                            int length = packet.getLength();
                            String jsonString = new String(receivedData, 0, length);
                            logger.info("Packet received :{}", (Object)jsonString);
                            ObjectMapper objectMapper = new ObjectMapper();
                            MetricsDataModel object = (MetricsDataModel)objectMapper.readValue(jsonString, MetricsDataModel.class);
                            logger.info("Message Received for : {}", (Object)object.getMessage_type());
                            Long value = MetricsData.readFromHashMap((String)object.getMessage_type()) + 1L;
                            MetricsData.writeToHashMap((String)object.getMessage_type(), (Long)value);
                        }
                    }
                    catch (Throwable throwable2) {
                        throwable = throwable2;
                        throw throwable2;
                    }
                }
                catch (Throwable throwable3) {
                    if (socket != null) {
                        if (throwable != null) {
                            try {
                                socket.close();
                            }
                            catch (Throwable throwable4) {
                                throwable.addSuppressed(throwable4);
                            }
                        } else {
                            socket.close();
                        }
                    }
                    throw throwable3;
                }
            }
            catch (Exception e) {
                logger.error("Error while parsing data ", (Throwable)e);
                continue;
            }
            break;
        }
    }
}

