/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.messaging.service;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.service.messaging.service.SubscribedMessage;
import com.fasterxml.jackson.databind.ObjectMapper;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.data.redis.connection.Message;
import org.springframework.data.redis.connection.MessageListener;
import org.springframework.stereotype.Service;

@Service
public class CoreEventSubscriber
implements MessageListener {
    private static final Logger logger = LogManager.getLogger(CoreEventSubscriber.class);

    public void onMessage(Message message, byte[] pattern) {
        String messageBody = message.toString();
        logger.info("Received message: {}", (Object)messageBody);
        ObjectMapper data = new ObjectMapper();
        try {
            SubscribedMessage subscribedMessage = (SubscribedMessage)data.readValue(messageBody, SubscribedMessage.class);
            Integer event = subscribedMessage.getEvent();
            if (event.equals(Constants.Message.NODE_ATTACH)) {
                logger.info("enB connected {}", (Object)messageBody);
                Constants.messagingService.updateNode(subscribedMessage);
            } else if (event.equals(Constants.Message.NODE_DETACH)) {
                logger.info("enB disconnected {}", (Object)messageBody);
                Constants.messagingService.updateNode(subscribedMessage);
            }
            if (event.equals(Constants.Message.NODE_ATTACH_5G)) {
                logger.info("gNB connected {}", (Object)messageBody);
                Constants.messagingService.updateNode5G(subscribedMessage);
            } else if (event.equals(Constants.Message.NODE_DETACH_5G)) {
                logger.info("gNB disconnected {}", (Object)messageBody);
                Constants.messagingService.updateNode5G(subscribedMessage);
            } else if (event.equals(Constants.Message.UE_ATTACH_UPDATE)) {
                logger.info("UE Connected {}", (Object)messageBody);
                Constants.messagingService.updateIMSI(subscribedMessage);
            } else if (event.equals(Constants.Message.UE_DETACH_UPDATE)) {
                logger.info("UE disconnected {}", (Object)messageBody);
                Constants.messagingService.updateIMSI(subscribedMessage);
            } else if (event.equals(Constants.Message.CORE_UPDATE)) {
                logger.info("Bandwidth Update {}", (Object)messageBody);
                Constants.messagingService.updateDataRate(subscribedMessage);
            } else if (event.equals(Constants.Message.UE_IP_UPDATE_5G)) {
                logger.info("UE IP Address Update {}", (Object)messageBody);
                Constants.messagingService.update5GUEIP(subscribedMessage);
            } else if (event.equals(Constants.Message.UE_IP_UPDATE_5G_Remove)) {
                logger.info("UE IP Address Remove {}", (Object)messageBody);
                Constants.messagingService.remove5GUEIP(subscribedMessage);
            } else {
                logger.info("Messaging un-processed  event : {}", (Object)messageBody);
            }
            if (Constants.centralNMSService != null && !subscribedMessage.isForwarded()) {
                if (subscribedMessage.getHostName() == null || subscribedMessage.getHostName().isEmpty()) {
                    subscribedMessage.setHostName(Constants.hostName);
                }
                if (event.equals(Constants.Message.UE_ATTACH) || event.equals(Constants.Message.UE_DETACH) || event.equals(Constants.Message.UE_ATTACH_5G) || event.equals(Constants.Message.UE_DETACH_5G)) {
                    logger.info("Attach / Detach message not forwarded");
                } else {
                    subscribedMessage.setForwarded(true);
                    Constants.centralNMSService.sendMessage(subscribedMessage);
                }
            }
        }
        catch (Exception e) {
            logger.info("Error while processing message : {}", (Object)messageBody, (Object)e);
        }
    }
}

