/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.scada_assets.controller;

import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.interface_model.IDeviceCount;
import com.coraltele.telemetry.service.coralnms.scada_assets.model.AssetLocationModel;
import com.coraltele.telemetry.service.coralnms.scada_assets.model.AssetTreeForLocation;
import com.coraltele.telemetry.service.coralnms.scada_assets.model.SCADAAssetModel;
import com.coraltele.telemetry.service.coralnms.scada_assets.service.SCADAAssetService;
import java.security.Principal;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/asset"})
@RestController
public class AssetsController {
    private static final Logger logger = LogManager.getLogger(AssetsController.class);
    @Autowired
    SCADAAssetService scadaAssetService;

    @GetMapping(value={"/list"})
    public ResponseEntity<RequestResponse> list() {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            List data = this.scadaAssetService.findAll();
            returnValue.setData((Object)data);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/tree"})
    public ResponseEntity<RequestResponse> getAssetTree(Principal principal) {
        RequestResponse returnValue = this.scadaAssetService.getAssetTree(principal.getName());
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        logger.error("Error while processing asset tree : {} {} {}", (Object)returnValue.getStatus(), (Object)returnValue.getMessage(), (Object)returnValue.getMessageDetail());
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/locationAssets/{locationId}"})
    public ResponseEntity<RequestResponse> getAssetTreeForLocation(Principal principal, @PathVariable(value="locationId") Integer locationId) {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            AssetTreeForLocation data = this.scadaAssetService.getAssetTreeLocation(principal.getName(), locationId);
            returnValue.setData((Object)data);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/summary/all"})
    public ResponseEntity<RequestResponse> getAssetSummary() {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            List data = this.scadaAssetService.getAssetSummary();
            returnValue.setData((Object)data);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/summary/not-working"})
    public ResponseEntity<RequestResponse> getAssetSummaryNotWorking() {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            List data = this.scadaAssetService.getAssetSummaryNotWorking();
            returnValue.setData((Object)data);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/count"})
    public ResponseEntity<RequestResponse> getAssetCount() {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            IDeviceCount data = this.scadaAssetService.getDeviceCount();
            returnValue.setData((Object)data);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateAssetLocation"})
    public ResponseEntity<RequestResponse> setAssetLocation(@RequestBody AssetLocationModel assetLocationModel) {
        RequestResponse returnValue = this.scadaAssetService.assignLocationToAsset(assetLocationModel.getAssetId(), assetLocationModel.getLocationId());
        if (returnValue.getStatus() == 0) {
            returnValue.setData((Object)returnValue);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/updateCoordinate"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody SCADAAssetModel data) {
        RequestResponse returnValue = this.scadaAssetService.updateCoordinates(data);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

