/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.db.telemetry.coralnms.repository;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.telemetry.model.interface_model.IAssetSummaryModel;
import com.coraltele.telemetry.model.interface_model.IBaseStationData;
import com.coraltele.telemetry.model.interface_model.IDeviceCount;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.springframework.data.jpa.repository.Modifying;
import org.springframework.data.jpa.repository.Query;
import org.springframework.data.repository.CrudRepository;
import org.springframework.data.repository.query.Param;
import org.springframework.stereotype.Repository;
import org.springframework.transaction.annotation.Transactional;

@Repository
public interface SCADAAssetRepository
extends CrudRepository<SCADAAsset, Long> {
    public List<SCADAAsset> findAll();

    public List<SCADAAsset> findBySwitchIPAndSwitchPortAndStackId(String var1, Integer var2, Integer var3);

    public List<SCADAAsset> findBySwitchIP(String var1);

    public Optional<SCADAAsset> findByNodeId(Integer var1);

    public Optional<SCADAAsset> findById(Long var1);

    public Optional<SCADAAsset> findByUuid(UUID var1);

    public Optional<SCADAAsset> findByCellId(String var1);

    public Optional<SCADAAsset> findByIpAddress(String var1);

    public Optional<SCADAAsset> findByServerGroupId(String var1);

    public List<SCADAAsset> findByNodeName(String var1);

    public List<SCADAAsset> findByLocationOrderBySeverityDescSeverityUpdatedOnAsc(String var1);

    public List<SCADAAsset> findBySwitchIPOrderBySeverityDescSeverityUpdatedOnAsc(String var1);

    public List<SCADAAsset> findByOrderBySeverityDescSeverityUpdatedOnAsc();

    public List<SCADAAsset> findByMacAddress(String var1);

    public List<SCADAAsset> findAllByCategory(String var1);

    public List<SCADAAsset> findByPendingForSyncIsNullOrPendingForSync(Integer var1);

    @Query(value="select coalesce (mc.description,  a.category) as category, COUNT(*) as count \nFROM coralnms.scada_assets a\nleft join coralnms.m_category mc on a.category = mc.code \nGROUP BY coalesce (mc.description,  a.category)\nORDER BY coalesce (mc.description,  a.category)", nativeQuery=true)
    public List<IAssetSummaryModel> assetSummary();

    @Query(value="SELECT category, COUNT(*) as count FROM coralnms.scada_assets where status = false GROUP BY category ORDER BY category", nativeQuery=true)
    public List<IAssetSummaryModel> assetSummaryNotWorking();

    @Query(value="SELECT COUNT(*) as deviceCount FROM coralnms.scada_assets", nativeQuery=true)
    public IDeviceCount deviceCount();

    @Modifying
    @Transactional
    @Query(value="UPDATE SCADAAsset e SET e.pendingForSync = :status WHERE e.id = :id")
    public void updatePendingForSyncById(Long var1, Integer var2);

    @Modifying
    @Transactional
    @Query(value="UPDATE SCADAAsset e SET e.lastKnownUptime = :uptime, e.lastKnownUptimeFetchEpoch = :fetchEpoch WHERE e.id = :id")
    public void updateUptimeById(Long var1, String var2, Long var3);

    @Query(value="SELECT s.id as id, s.cell_id as cellId, s.category as category, s.ip_address as ipAddress, s.ngap_status as ngapStatus, s.ngap_status_epoch as ngapStatusEpoch, s.node_name as nodeName, s.last_known_uptime as lastKnownUptime, s.last_known_uptime_fetch_epoch as lastKnownUptimeFetchEpoch, COALESCE(a.status, true) as status, COALESCE(a.alertgeneratedon, 0) as alertGeneratedOn, COALESCE(a.alertclosedon, 0) as alertClosedOn FROM coralnms.scada_assets s LEFT JOIN (SELECT * FROM alert WHERE servicecode = 'ICMP') a ON s.id = a.assetid WHERE s.category IN ('eNodeB', 'gNodeB') ORDER BY s.ip_address", nativeQuery=true)
    public List<IBaseStationData> getBaseStationData();

    @Query(value="SELECT s.cell_id as cellId, s.category as category, s.ip_address as ipAddress, s.ngap_status as ngapStatus, s.ngap_status_epoch as ngapStatusEpoch, s.node_name as nodeName, COALESCE(a.status, true) as status, COALESCE(a.alertgeneratedon, 0) as alertGeneratedOn, COALESCE(a.alertclosedon, 0) as alertClosedOn FROM coralnms.scada_assets s LEFT JOIN (SELECT * FROM alert WHERE servicecode = 'ICMP') a ON s.id = a.assetid WHERE s.category IN ('MEC-VM') ORDER BY s.ip_address", nativeQuery=true)
    public List<IBaseStationData> getMECStatus();

    @Query(value="SELECT * FROM coralnms.scada_assets WHERE LOWER(ip_address) = LOWER(:ip) AND LOWER(mac_address) = LOWER(:mac) LIMIT 1", nativeQuery=true)
    public Optional<SCADAAsset> findDuplicate(@Param(value="ip") String var1, @Param(value="mac") String var2);
}

