/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.controller;

import com.coraltele.telemetry.component.service.LinkViewService;
import com.coraltele.telemetry.helper.RequestResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/link-view"})
public class LinkViewController {
    private static final Logger logger = LogManager.getLogger(LinkViewController.class);
    @Autowired
    private LinkViewService linkViewService;

    @GetMapping(value={"/nodes/{viewMode}/{location}"})
    public ResponseEntity<RequestResponse> getNodesByViewMode(@PathVariable String viewMode, @PathVariable String location) {
        logger.info("GET /api/v2/link-view/nodes/{}/{} - viewMode: {}, location: {}", (Object)viewMode, (Object)location, (Object)viewMode, (Object)location);
        RequestResponse returnValue = this.linkViewService.getNodesByViewMode(viewMode, location);
        if (returnValue.getStatus() == 0) {
            logger.info("Nodes retrieved successfully for viewMode: {}, location: {}", (Object)viewMode, (Object)location);
            return ResponseEntity.ok((Object)returnValue);
        }
        logger.error("Failed to retrieve nodes for viewMode: {}, location: {}, error: {}", (Object)viewMode, (Object)location, (Object)returnValue.getMessage());
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @DeleteMapping(value={"/nodes/{viewMode}/{location}"})
    public ResponseEntity<RequestResponse> deleteNodePositions(@PathVariable String viewMode, @PathVariable String location) {
        logger.info("DELETE /api/v2/link-view/nodes/{}/{} - viewMode: {}, location: {}", (Object)viewMode, (Object)location, (Object)viewMode, (Object)location);
        RequestResponse returnValue = this.linkViewService.deleteNodePositionsByViewModeAndLocation(viewMode, location);
        if (returnValue.getStatus() == 0) {
            logger.info("Node positions deleted successfully for viewMode: {}, location: {}", (Object)viewMode, (Object)location);
            return ResponseEntity.ok((Object)returnValue);
        }
        logger.error("Failed to delete node positions for viewMode: {}, location: {}, error: {}", (Object)viewMode, (Object)location, (Object)returnValue.getMessage());
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

