/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.component.service.CallDataCollectionService;
import com.coraltele.telemetry.condition.EnableCallRecordDistribution;
import com.coraltele.telemetry.db.coralapps.entity.Agent;
import com.coraltele.telemetry.db.coralapps.repository.AgentRepository;
import com.coraltele.telemetry.db.users.main.entity.User;
import com.coraltele.telemetry.db.users.main.repository.UserRepository;
import com.coraltele.telemetry.thread.CallDataRecordDistributionThread;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnableCallRecordDistribution.class})
public class CallDataRecordDistributionProcess {
    private static final Logger logger = LogManager.getLogger(CallDataRecordDistributionProcess.class);
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private AgentRepository agentRepository;
    @Autowired
    private CallDataCollectionService callDataCollectionService;
    private static final Integer MAX_THREADS = 1;
    ExecutorService threadPool = Executors.newFixedThreadPool(1);

    @Scheduled(fixedRate=5000L)
    public void startService() {
        logger.info("Maximum Threads : {}, Active Thread {} ", (Object)MAX_THREADS, (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount());
        Integer threadsStarted = 0;
        while (((ThreadPoolExecutor)this.threadPool).getActiveCount() < MAX_THREADS) {
            Integer n = threadsStarted;
            Integer n2 = threadsStarted = Integer.valueOf(threadsStarted + 1);
            logger.info("Starting CDR Processing Thread");
            this.threadPool.execute((Runnable)new CallDataRecordDistributionThread(this.callDataCollectionService));
        }
        logger.info("{} Threads started", (Object)threadsStarted);
    }

    @PostConstruct
    public void UpdateAgent() {
        try {
            List agentName = this.agentRepository.findAll();
            for (Agent agent : agentName) {
                Optional userName = this.userRepository.findByUsername(agent.getName());
                if (!userName.isPresent()) continue;
                agent.setAgentFullName(((User)userName.get()).getDescription());
                this.agentRepository.save((Object)agent);
                logger.info("success");
            }
            logger.info("successfully update data in agent Table");
        }
        catch (Exception e) {
            logger.info("error are found in {}", (Object)e.getMessage());
        }
    }
}

