/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.messageApi.controller;

import com.coraltele.telemetry.db.telemetry.main.entity.Message;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.main.messageApi.model.MessageSearchModel;
import com.coraltele.telemetry.service.main.messageApi.service.ChatService;
import com.coraltele.telemetry.service.user.service.UserAuthenticationService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/app/v2/message"})
@RestController
public class ChatController {
    @Autowired
    private ChatService service;

    @GetMapping(value={"/List"})
    public ResponseEntity<RequestResponse> getAllMessages() {
        RequestResponse returnValue = this.service.getAll();
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/{messageId}"})
    public ResponseEntity<RequestResponse> getMessageById(@PathVariable(value="messageId") int id) {
        RequestResponse returnValue = this.service.getById(id);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/callSign"})
    public ResponseEntity<RequestResponse> getMessageByCallsign(@RequestParam String callSign) {
        RequestResponse returnValue = this.service.getByCallSign(callSign);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/messagesOnTime"})
    public ResponseEntity<RequestResponse> getByTime(@RequestParam String sender, @RequestParam String receiver) {
        RequestResponse returnValue = this.service.getMessageByTime(sender, receiver);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/messageWithUser"})
    public ResponseEntity<RequestResponse> messageAgainstUser(@RequestParam String username) {
        RequestResponse returnValue = this.service.messagesOfUser(username);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @DeleteMapping(value={"/{messageId}"})
    public ResponseEntity<RequestResponse> delete(@PathVariable(value="messageId") int id) {
        RequestResponse returnValue = this.service.delete(id);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/findByFilters"})
    public ResponseEntity<RequestResponse> getBydFilterData(@RequestBody MessageSearchModel searchModel) {
        RequestResponse returnValue = this.service.findByFilters(searchModel);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/unReadMessages"})
    public ResponseEntity<RequestResponse> unReadMessages(UserAuthenticationService authentication) {
        RequestResponse returnValue = this.service.getUnReadMessages(authentication);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/markAsRead"})
    public ResponseEntity<RequestResponse> markAsRead(UserAuthenticationService authentication) {
        RequestResponse returnValue = this.service.markAsRead(authentication);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/list/pageable"})
    public ResponseEntity<RequestResponse> getAllMessages(@RequestParam(defaultValue="0") Integer pageNumber, @RequestParam(defaultValue="10") Integer pageSize) {
        RequestResponse returnValue = this.service.getPageableList(pageNumber.intValue(), pageSize.intValue());
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @DeleteMapping(value={"/multipleMessages"})
    public ResponseEntity<RequestResponse> deleteMessages(@RequestBody List<Integer> ids) {
        RequestResponse returnValue = this.service.deleteMultipleMessages(ids);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/send"})
    public ResponseEntity<RequestResponse> saveData(@RequestBody Message message) {
        RequestResponse returnValue = this.service.saveMessage(message);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

