/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.widget.service;

import com.coraltele.telemetry.bootstrap.JwtUserDetailConfiguration;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.API;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.Sensor;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.UserDashboard;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.Widget;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.WidgetList;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.WidgetType;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.APIRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.LayoutSectionRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.LayoutSectionWidgetRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SensorRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.UserDashboardRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.WidgetListRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.WidgetRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.WidgetTypeRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.DashboardGroup;
import com.coraltele.telemetry.db.telemetry.main.repository.DashboardGroupRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.DashboardLayoutWidgetModel;
import com.coraltele.telemetry.model.UserDashboardLayout;
import com.coraltele.telemetry.service.coralnms.dashboard.model.Dashboard;
import com.coraltele.telemetry.service.coralnms.dashboard.model.DashboardLayout;
import com.coraltele.telemetry.service.coralnms.dashboard.model.LayoutSectionModel;
import com.coraltele.telemetry.service.coralnms.dashboard.model.UserDashboards;
import com.coraltele.telemetry.service.coralnms.dashboard.model.UserDashboardsGroupModel;
import com.coraltele.telemetry.service.coralnms.widget.model.WidgetFileListModel;
import com.coraltele.telemetry.service.coralnms.widget.model.WidgetListModel;
import com.coraltele.telemetry.service.coralnms.widget.model.WidgetModel;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermission;
import java.nio.file.attribute.PosixFilePermissions;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;
import org.springframework.web.multipart.MultipartFile;

@Service
public class WidgetService {
    private static final Logger logger = LogManager.getLogger(WidgetService.class);
    @Autowired
    WidgetListRepository widgetListRepository;
    @Autowired
    WidgetRepository widgetRepository;
    @Autowired
    LayoutSectionRepository layoutSectionRepository;
    @Autowired
    LayoutSectionWidgetRepository layoutSectionWidgetRepository;
    @Autowired
    UserDashboardRepository userDashboardRepository;
    @Autowired
    SCADAAssetRepository scadaAssetRepository;
    @Autowired
    SensorRepository sensorRepository;
    @Autowired
    WidgetTypeRepository widgetTypeRepository;
    @Autowired
    APIRepository apiRepository;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    DashboardGroupRepository dashboardGroupRepo;
    @Autowired
    JwtUserDetailConfiguration userDetailConfiguration;

    public UserDashboards getAssetDashboard(Long assetId) {
        UserDashboards returnValue = new UserDashboards();
        returnValue.setUserName("");
        returnValue.setIsAdmin(Boolean.valueOf(true));
        returnValue.setDashboards(new ArrayList());
        WidgetType widgetType = new WidgetType();
        widgetType.setId(Constants.DASHBOARD_ID);
        Optional asset = this.scadaAssetRepository.findById(assetId);
        if (asset.isPresent()) {
            Dashboard row;
            List widgets = this.widgetListRepository.findByWidgetTypeAndAssetIdAndIsDefaultDashboard(widgetType, assetId, Boolean.valueOf(true));
            for (WidgetList widget : widgets) {
                row = new Dashboard();
                row.setWidgetId(widget.getCode());
                row.setDashboardType(widget.getWidgetType().getCode());
                row.setDashboardName(widget.getName());
                returnValue.getDashboards().add(row);
            }
            widgets = this.widgetListRepository.findByWidgetTypeAndAssetIdAndIsDefaultDashboard(widgetType, assetId, Boolean.valueOf(false));
            for (WidgetList widget : widgets) {
                row = new Dashboard();
                row.setWidgetId(widget.getCode());
                row.setDashboardType(widget.getWidgetType().getCode());
                row.setDashboardName(widget.getName());
                returnValue.getDashboards().add(row);
            }
        }
        return returnValue;
    }

    public UserDashboardLayout getDashboardLayout(String userName, String widgetId) {
        UserDashboardLayout returnValue = new UserDashboardLayout();
        String layoutType = "";
        returnValue.setDefaultLayout(new DashboardLayout());
        Optional dashboardWidget = this.widgetListRepository.findByCode(widgetId);
        String widgetPrefix = "";
        if (dashboardWidget.isPresent()) {
            ObjectMapper defaultDashboard = new ObjectMapper();
            widgetPrefix = ((WidgetList)dashboardWidget.get()).getWidgetPrefix();
            String fileName = "/etc/coraltele/dashboards/" + ((WidgetList)dashboardWidget.get()).getWidgetCode() + ".json";
            if (StringUtils.hasLength((String)((WidgetList)dashboardWidget.get()).getDashboardLayoutType())) {
                layoutType = "template";
                fileName = "/etc/coraltele/dashboards/" + ((WidgetList)dashboardWidget.get()).getDashboardLayoutType() + ".json";
            }
            logger.info("Read dashboard layout from {}", (Object)fileName);
            try {
                returnValue.setDefaultLayout((DashboardLayout)defaultDashboard.readValue(new File(fileName), DashboardLayout.class));
            }
            catch (Exception e) {
                logger.error("Error while reading information from : {}", (Object)fileName, (Object)e);
                returnValue.setDefaultLayout(new DashboardLayout());
            }
            Optional uDB = this.userDashboardRepository.findByUserNameAndWidgetId(userName, ((WidgetList)dashboardWidget.get()).getCode());
            if (uDB.isPresent()) {
                ObjectMapper objectMapper = new ObjectMapper();
                try {
                    if (((UserDashboard)uDB.get()).getDashboard() != null && !((UserDashboard)uDB.get()).getDashboard().isEmpty()) {
                        Object db = objectMapper.readValue(((UserDashboard)uDB.get()).getDashboard(), Object.class);
                        returnValue.setCustomLayout(db);
                    }
                }
                catch (JsonProcessingException jsonProcessingException) {
                    // empty catch block
                }
            }
        }
        this.getWidgetInfo(layoutType, widgetPrefix, returnValue.getDefaultLayout().getHeader());
        this.getWidgetInfo(layoutType, widgetPrefix, returnValue.getDefaultLayout().getFooter());
        this.getWidgetInfo(layoutType, widgetPrefix, returnValue.getDefaultLayout().getLeftSidebar());
        this.getWidgetInfo(layoutType, widgetPrefix, returnValue.getDefaultLayout().getRightSidebar());
        this.getWidgetInfo(layoutType, widgetPrefix, returnValue.getDefaultLayout().getInnerHeader());
        this.getWidgetInfo(layoutType, widgetPrefix, returnValue.getDefaultLayout().getInnerFooter());
        this.getWidgetInfo(layoutType, widgetPrefix, returnValue.getDefaultLayout().getInnerLeftSidebar());
        this.getWidgetInfo(layoutType, widgetPrefix, returnValue.getDefaultLayout().getInnerRightSidebar());
        this.getWidgetInfo(layoutType, widgetPrefix, returnValue.getDefaultLayout().getCenter());
        return returnValue;
    }

    private void getWidgetInfo(String layoutType, String widgetPrefix, List<LayoutSectionModel> layouts) {
        for (LayoutSectionModel layoutSection2 : layouts) {
            for (DashboardLayoutWidgetModel widgetModel : layoutSection2.getWidgetIds()) {
                String widgetCode = widgetModel.getId().replace("$$", widgetPrefix + "_");
                Optional widget2 = this.widgetListRepository.findByBaseCode(widgetCode);
                if (!widget2.isPresent()) continue;
                widgetModel.setId(((WidgetList)widget2.get()).getCode());
                widgetModel.setName(((WidgetList)widget2.get()).getName());
                widgetModel.setWidgetType(((WidgetList)widget2.get()).getWidgetType().getCode());
            }
            if (layoutType.contains("template")) continue;
            layoutSection2.getWidgetIds().removeIf(widget -> widget.getWidgetType() == null);
        }
        if (!layoutType.contains("template")) {
            layouts.removeIf(layoutSection -> layoutSection.getWidgetIds() == null || layoutSection.getWidgetIds().isEmpty());
        }
    }

    private Object parseStringToJSON(String value) {
        if (value == null) {
            return null;
        }
        if ((value = value.trim()).startsWith("{") || value.startsWith("[")) {
            ObjectMapper objectMapper = new ObjectMapper();
            try {
                JsonNode jsonNode = objectMapper.readTree(value);
                return jsonNode;
            }
            catch (JsonProcessingException e) {
                return value;
            }
        }
        return value;
    }

    public WidgetModel getWidget(String id) {
        WidgetModel returnValue = null;
        Optional widget = this.widgetListRepository.findByCode(id);
        if (widget.isPresent()) {
            returnValue = new WidgetModel();
            returnValue.setPrimaryLabel(((WidgetList)widget.get()).getName());
            returnValue.setGetDataURL(((WidgetList)widget.get()).getApiURL());
            if (((WidgetList)widget.get()).getApi() != null) {
                if (returnValue.getGetDataURL() == null || returnValue.getGetDataURL().isEmpty()) {
                    returnValue.setGetDataURL(((WidgetList)widget.get()).getApi().getUrl());
                }
                returnValue.setApiCode(((WidgetList)widget.get()).getApi().getCode());
                returnValue.setHasWebSocketUpdate(((WidgetList)widget.get()).getApi().getHasWebSocketUpdate());
                returnValue.setRefreshInterval(((WidgetList)widget.get()).getApi().getRefreshInterval());
            } else {
                returnValue.setRefreshInterval(((WidgetList)widget.get()).getRefreshInterval());
            }
            if (((WidgetList)widget.get()).getSensor() != null) {
                returnValue.setGetDataURL(returnValue.getGetDataURL() + "/" + ((WidgetList)widget.get()).getSensor().getProvisioningId() + "/" + ((WidgetList)widget.get()).getSensorAttribute());
            }
            returnValue.setThresholdLower(((WidgetList)widget.get()).getThresholdLower());
            returnValue.setThresholdUpper(((WidgetList)widget.get()).getThresholdUpper());
            returnValue.setLocation(((WidgetList)widget.get()).getLocation());
            returnValue.setLegendField(((WidgetList)widget.get()).getLegendField());
            returnValue.setValueField(((WidgetList)widget.get()).getValueField());
            returnValue.setColumns(this.parseStringToJSON(((WidgetList)widget.get()).getColumns()));
            returnValue.setActions(this.parseStringToJSON(((WidgetList)widget.get()).getActions()));
            returnValue.setLegendFieldDataType(((WidgetList)widget.get()).getLegendFieldDataType());
            returnValue.setValueFieldDataType(((WidgetList)widget.get()).getValueFieldDataType());
            if (((WidgetList)widget.get()).getWidgetType() != null) {
                returnValue.setWidgetType(((WidgetList)widget.get()).getWidgetType().getCode());
            }
            returnValue.setShowLegends(((WidgetList)widget.get()).getShowLegends());
            returnValue.setImageName(((WidgetList)widget.get()).getImageName());
            returnValue.setHeight(((WidgetList)widget.get()).getHeight());
            returnValue.setWidth(((WidgetList)widget.get()).getWidth());
            returnValue.setMin(((WidgetList)widget.get()).getMinValue());
            returnValue.setMax(((WidgetList)widget.get()).getMaxValue());
            if (((WidgetList)widget.get()).getSensor() != null) {
                returnValue.setCategory(((WidgetList)widget.get()).getSensor().getAsset().getCategory());
            }
        }
        return returnValue;
    }

    public List<WidgetListModel> getWidgets(String userName) {
        boolean showSystemDashboards = this.userDetailConfiguration.hasRole(userName, "ROLE_NMS_USER") || this.userDetailConfiguration.hasRole(userName, "ROLE_ADMIN") || this.userDetailConfiguration.hasRole(userName, "ROLE_NMSADMIN") || this.userDetailConfiguration.hasRole(userName, "ROLE_NMS_VIEWER");
        ArrayList<WidgetListModel> returnValue = new ArrayList<WidgetListModel>();
        List widgets = this.widgetListRepository.findAll();
        for (WidgetList widget : widgets) {
            Boolean showDashboard = widget.getEnabled() != null && widget.getEnabled() != false && widget.getWidgetType() != null && widget.getWidgetType().getId() != 9;
            if (Boolean.TRUE.equals(showDashboard)) {
                showDashboard = Boolean.TRUE.equals(widget.getIsSystemWidget()) ? Boolean.valueOf(showSystemDashboards) : (widget.getCreatedBy().equals(userName) ? Boolean.valueOf(true) : Boolean.valueOf(false));
            }
            if (!Boolean.TRUE.equals(showDashboard)) continue;
            WidgetListModel row = new WidgetListModel(widget.getCode(), widget.getName(), widget.getMetricsName(), StringUtils.hasLength((String)widget.getNodeName()) ? widget.getNodeName() : "Standalone", widget.getWidgetName(), StringUtils.hasLength((String)widget.getCategoryName()) ? widget.getCategoryName() : "General");
            returnValue.add(row);
        }
        return returnValue;
    }

    public RequestResponse storeDataIntoFile() throws IOException {
        RequestResponse returnValue = new RequestResponse();
        List list = this.widgetRepository.findAll();
        ArrayList<WidgetFileListModel> addValue = new ArrayList<WidgetFileListModel>();
        ObjectMapper objectMapper = new ObjectMapper();
        String filePath = "/etc/coraltele/masters/widget.json";
        try {
            File file = new File(filePath);
            if (!file.exists()) {
                file.createNewFile();
                logger.info("New File Created Successfully");
            } else {
                logger.info("File Already Exists");
            }
            FileWriter fileWriter = new FileWriter(filePath);
            for (Widget widget : list) {
                if (!widget.isExport()) continue;
                WidgetFileListModel data = new WidgetFileListModel();
                data.setId(widget.getId());
                data.setApi(widget.getApi() != null ? widget.getApi().getId() : null);
                data.setApiURL(widget.getApiURL());
                data.setCategory(widget.getCategory());
                data.setChartType(widget.getChartType());
                data.setCode(widget.getCode());
                data.setHeight(widget.getHeight());
                data.setImageName(widget.getImageName());
                data.setIsDefaultDashboard(widget.getIsDefaultDashboard());
                data.setLegendField(widget.getLegendField());
                data.setLegendFieldDataType(widget.getLegendFieldDataType());
                data.setLocation(widget.getLocation());
                data.setMaxValue(widget.getMaxValue());
                data.setMetricsDataDivision(widget.getMetricsDataDivision());
                data.setMetricsDataDuration(widget.getMetricsDataDuration());
                data.setMetricsInstanceName(widget.getMetricsInstanceName());
                data.setMetricsInvertValue(widget.getMetricsInvertValue());
                data.setMetricsName(widget.getMetricsName());
                data.setMinValue(widget.getMinValue());
                data.setName(widget.getName());
                data.setRefreshInterval(widget.getRefreshInterval());
                data.setSensor(widget.getSensor() != null ? widget.getSensor().getId() : null);
                data.setSensorAttribute(widget.getSensorAttribute());
                data.setShowLegends(widget.getShowLegends());
                data.setThresholdLower(widget.getThresholdLower());
                data.setThresholdUpper(widget.getThresholdUpper());
                data.setValueField(widget.getValueField());
                data.setValueFieldDataType(widget.getValueFieldDataType());
                data.setWidgetType(widget.getWidgetType() != null ? widget.getWidgetType().getId() : null);
                data.setWidth(widget.getWidth());
                data.setExport(Boolean.valueOf(widget.isExport()));
                data.setEnabled(widget.getEnabled());
                addValue.add(data);
            }
            String dataReceived = objectMapper.writeValueAsString(addValue);
            fileWriter.write(dataReceived);
            fileWriter.close();
            returnValue.setStatus(0);
            returnValue.setMessage("Stored ");
            returnValue.setMessageDetail("Data Stored Successfully");
            logger.info("Data Have Been Stored Successfully ");
        }
        catch (FileNotFoundException e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setMessage("File Not Found");
            returnValue.setMessageDetail("File Not Present At The Server.");
            logger.error("Error while saving data logs ", (Throwable)e);
        }
        catch (IOException e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setMessage("Error while Storing Data Into File. ");
            returnValue.setMessageDetail("Unable To Store Data Into File");
            logger.error("Error while saving data logs::", (Throwable)e);
        }
        return returnValue;
    }

    private boolean doesWidgetExist(Integer id) {
        return this.widgetRepository.existsById((Object)id);
    }

    public RequestResponse retrieveDataFromFileAndStore() throws IOException {
        RequestResponse returnValue = new RequestResponse();
        String filePath = "/etc/coraltele/masters/widget.json";
        try {
            WidgetFileListModel[] data;
            File file = new File(filePath);
            if (!file.exists()) {
                returnValue.setIssue(Constants.NodeStatus.ERROR);
                returnValue.setMessage("File Not Found");
                returnValue.setMessageDetail("File Not Present at the Server");
                logger.error("File not found");
                return returnValue;
            }
            ObjectMapper objectMapper = new ObjectMapper();
            for (WidgetFileListModel widgetFileListModel : data = (WidgetFileListModel[])objectMapper.readValue(file, WidgetFileListModel[].class)) {
                Integer id = widgetFileListModel.getId();
                Widget widget = new Widget();
                widget.setId(id);
                widget.setApiURL(widgetFileListModel.getApiURL());
                widget.setCategory(widgetFileListModel.getCategory());
                widget.setChartType(widgetFileListModel.getChartType());
                widget.setCode(widgetFileListModel.getCode());
                widget.setHeight(widgetFileListModel.getHeight());
                widget.setImageName(widgetFileListModel.getImageName());
                widget.setIsDefaultDashboard(widgetFileListModel.getIsDefaultDashboard());
                widget.setLegendField(widgetFileListModel.getLegendField());
                widget.setLegendFieldDataType(widgetFileListModel.getLegendFieldDataType());
                widget.setLocation(widgetFileListModel.getLocation());
                widget.setMaxValue(widgetFileListModel.getMaxValue());
                widget.setMetricsDataDivision(widgetFileListModel.getMetricsDataDivision());
                widget.setMetricsDataDuration(widgetFileListModel.getMetricsDataDuration());
                widget.setMetricsInstanceName(widgetFileListModel.getMetricsInstanceName());
                widget.setMetricsInvertValue(widgetFileListModel.getMetricsInvertValue());
                widget.setMetricsName(widgetFileListModel.getMetricsName());
                widget.setMinValue(widgetFileListModel.getMinValue());
                widget.setName(widgetFileListModel.getName());
                widget.setRefreshInterval(widgetFileListModel.getRefreshInterval());
                widget.setSensorAttribute(widgetFileListModel.getSensorAttribute());
                widget.setShowLegends(widgetFileListModel.getShowLegends());
                widget.setThresholdLower(widgetFileListModel.getThresholdLower());
                widget.setThresholdUpper(widgetFileListModel.getThresholdUpper());
                widget.setValueField(widgetFileListModel.getValueField());
                widget.setValueFieldDataType(widgetFileListModel.getValueFieldDataType());
                widget.setWidth(widgetFileListModel.getWidth());
                widget.setEnabled(widgetFileListModel.getEnabled());
                if (widgetFileListModel.getExport() != null && !widgetFileListModel.getExport().equals("")) {
                    widget.setExport(widgetFileListModel.getExport().booleanValue());
                } else {
                    widget.setExport(true);
                }
                Integer widgetTypeId = widgetFileListModel.getWidgetType();
                if (widgetTypeId != null) {
                    Optional widgetType = this.widgetTypeRepository.findById(widgetTypeId);
                    if (widgetType.isPresent()) {
                        widget.setWidgetType((WidgetType)widgetType.get());
                    } else {
                        widget.setWidgetType(null);
                    }
                } else {
                    WidgetType obj = new WidgetType();
                    obj.setId(null);
                    widget.setWidgetType(obj);
                }
                Integer apiId = widgetFileListModel.getApi();
                if (apiId != null) {
                    Optional api = this.apiRepository.findById(apiId);
                    if (api.isPresent()) {
                        widget.setApi((API)api.get());
                    } else {
                        widget.setApi(null);
                    }
                } else {
                    API obj = new API();
                    obj.setId(null);
                    widget.setApi(obj);
                }
                Long sensorId = widgetFileListModel.getSensor();
                if (sensorId != null) {
                    Optional sensor = this.sensorRepository.findById(sensorId);
                    if (sensor.isPresent()) {
                        widget.setSensor((Sensor)sensor.get());
                    } else {
                        widget.setSensor(null);
                    }
                } else {
                    Sensor obj = new Sensor();
                    obj.setId(null);
                    widget.setSensor(obj);
                }
                if (this.doesWidgetExist(id)) {
                    String updateSql = "UPDATE coralnms.widget SET apiurl=?, category=?, chart_type=?, code=?, height=?, image_name=?, is_default_dashboard=?, legend_field=?, legend_field_data_type=?, location=?, max_value=?, metrics_data_division=?, metrics_data_duration=?, metrics_instance_name=?, metrics_invert_value=?, metrics_name=?, min_value=?, name=?, refresh_interval=?, sensor_attribute=?, show_legends=?, threshold_lower=?, threshold_upper=?, value_field=?, value_field_data_type=?, width=?, export=?, widget_type_id=?, api_id=?, sensor_id=? WHERE id=?";
                    this.jdbcTemplate.update(updateSql, new Object[]{widget.getApiURL(), widget.getCategory(), widget.getChartType(), widget.getCode(), widget.getHeight(), widget.getImageName(), widget.getIsDefaultDashboard(), widget.getLegendField(), widget.getLegendFieldDataType(), widget.getLocation(), widget.getMaxValue(), widget.getMetricsDataDivision(), widget.getMetricsDataDuration(), widget.getMetricsInstanceName(), widget.getMetricsInvertValue(), widget.getMetricsName(), widget.getMinValue(), widget.getName(), widget.getRefreshInterval(), widget.getSensorAttribute(), widget.getShowLegends(), widget.getThresholdLower(), widget.getThresholdUpper(), widget.getValueField(), widget.getValueFieldDataType(), widget.getWidth(), widget.isExport(), widget.getWidgetType().getId(), widget.getApi().getId(), widget.getSensor().getId(), widget.getId()});
                    continue;
                }
                String insertSql = "INSERT INTO coralnms.widget (apiurl, category, chart_type, code, height, image_name, is_default_dashboard, legend_field, legend_field_data_type, location, max_value, metrics_data_division, metrics_data_duration, metrics_instance_name, metrics_invert_value, metrics_name, min_value, name, refresh_interval, sensor_attribute, show_legends, threshold_lower, threshold_upper, value_field, value_field_data_type, width, export, widget_type_id, api_id, sensor_id,enabled, id) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?,?)";
                this.jdbcTemplate.update(insertSql, new Object[]{widget.getApiURL(), widget.getCategory(), widget.getChartType(), widget.getCode(), widget.getHeight(), widget.getImageName(), widget.getIsDefaultDashboard(), widget.getLegendField(), widget.getLegendFieldDataType(), widget.getLocation(), widget.getMaxValue(), widget.getMetricsDataDivision(), widget.getMetricsDataDuration(), widget.getMetricsInstanceName(), widget.getMetricsInvertValue(), widget.getMetricsName(), widget.getMinValue(), widget.getName(), widget.getRefreshInterval(), widget.getSensorAttribute(), widget.getShowLegends(), widget.getThresholdLower(), widget.getThresholdUpper(), widget.getValueField(), widget.getValueFieldDataType(), widget.getWidth(), widget.isExport(), widget.getWidgetType().getId(), widget.getApi().getId(), widget.getSensor().getId(), widget.getEnabled(), widget.getId()});
            }
            returnValue.setIssue(Constants.NodeStatus.OK);
            returnValue.setMessage("Data Retrieved and Stored");
            returnValue.setMessageDetail("Data Retrieved from File and Stored into Table Successfully");
            logger.info("Data Retrieved and Stored Successfully");
        }
        catch (FileNotFoundException e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setMessage("File Not Found");
            returnValue.setMessageDetail("File Not Present at the Server");
            logger.error("Error while retrieving data from file", (Throwable)e);
        }
        catch (IOException e) {
            returnValue.setIssue(Constants.NodeStatus.ERROR);
            returnValue.setMessage("Error while Retrieving Data from File");
            returnValue.setMessageDetail("Unable to Retrieve Data from File");
            logger.error("Error while retrieving data from file", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse widgetFileUpload(MultipartFile file, String id) {
        RequestResponse returnValue;
        block9: {
            logger.debug("upload file : {}", (Object)file);
            returnValue = new RequestResponse();
            String filename = "";
            String pathToUpload = "/var/www/html/images/widgets";
            Path uploadPath = Paths.get(pathToUpload, new String[0]);
            String message = "";
            try {
                Optional widget = this.widgetListRepository.findByCode(id);
                if (widget.isPresent()) {
                    String contentType;
                    logger.info("Uploading Image for Widget List ID : {}, Widget ID {}", (Object)id, (Object)((WidgetList)widget.get()).getWidgetId());
                    if (file.isEmpty()) break block9;
                    if (!Files.exists(uploadPath, new LinkOption[0])) {
                        try {
                            Files.createDirectories(uploadPath, new FileAttribute[0]);
                        }
                        catch (IOException e) {
                            returnValue.setIssue(Constants.NodeStatus.RECORDS_NOT_FOUND);
                            returnValue.setMessage("Not Found");
                            returnValue.setMessageDetail("Path Does Not Exist, Where File Has To Be Uploaded");
                            message = MessageFormat.format("Path Does Not Exist, Where File Has To Be Uploaded: {0}", pathToUpload);
                            logger.error(message);
                            return returnValue;
                        }
                    }
                    if ((contentType = file.getContentType()) != null && contentType.startsWith("image/")) {
                        String originalFilename = file.getOriginalFilename();
                        String fileExtension = originalFilename.substring(originalFilename.lastIndexOf("."));
                        filename = UUID.randomUUID().toString() + fileExtension;
                        Path filePath = uploadPath.resolve(filename);
                        Files.copy(file.getInputStream(), filePath, StandardCopyOption.REPLACE_EXISTING);
                        Set<PosixFilePermission> readOnlyPermissions = PosixFilePermissions.fromString("r--r--r--");
                        Files.setPosixFilePermissions(filePath, readOnlyPermissions);
                        Optional row = this.widgetRepository.findById(((WidgetList)widget.get()).getWidgetId());
                        if (row.isPresent()) {
                            ((Widget)row.get()).setImageName(filename);
                            this.widgetRepository.save(row.get());
                            returnValue.setIssue(Constants.NodeStatus.OK);
                            returnValue.setMessage("Uploaded");
                            returnValue.setMessageDetail("File Uploaded Successfully");
                            returnValue.setData((Object)filename);
                            logger.info(returnValue.getMessageDetail());
                            return returnValue;
                        }
                        returnValue.setIssue(Constants.NodeStatus.ERROR);
                        returnValue.setMessage("Unable To Process");
                        returnValue.setMessageDetail("Please Contact Administrator");
                        break block9;
                    }
                    returnValue.setIssue(Constants.NodeStatus.RECORDS_NOT_FOUND);
                    returnValue.setMessage("Select Image File Only");
                    returnValue.setMessageDetail("Format Issue");
                    logger.info(returnValue.getMessage());
                    return returnValue;
                }
                returnValue.setIssue(Constants.NodeStatus.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("widget not found");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            catch (NullPointerException e) {
                returnValue.setMessage("File Can Not Be Empty");
                returnValue.setMessageDetail("kindly upload the Image");
                logger.error(returnValue.getMessageDetail(), (Throwable)e);
            }
            catch (Exception e) {
                returnValue.setIssue(Constants.NodeStatus.ERROR);
                returnValue.setMessage("Unable To Process");
                returnValue.setMessageDetail("Please Contact Administrator");
                logger.error(returnValue.getMessageDetail(), (Throwable)e);
            }
        }
        return returnValue;
    }

    public UserDashboards getUserDashboards(String userName) {
        UserDashboards returnValue = new UserDashboards();
        boolean showSystemDashboards = this.userDetailConfiguration.hasRole(userName, "ROLE_NMS_USER") || this.userDetailConfiguration.hasRole(userName, "ROLE_ADMIN") || this.userDetailConfiguration.hasRole(userName, "ROLE_NMSADMIN") || this.userDetailConfiguration.hasRole(userName, "ROLE_NMS_VIEWER");
        returnValue.setUserName(userName);
        returnValue.setIsAdmin(Boolean.valueOf(true));
        returnValue.setDashboards(new ArrayList());
        WidgetType widgetType = new WidgetType();
        widgetType.setId(Constants.DASHBOARD_ID);
        List widgets = this.widgetListRepository.findByWidgetTypeOrderByChartTypeAscNameAsc(widgetType);
        for (WidgetList widget : widgets) {
            Boolean showDashboard = widget.getEnabled() != null && widget.getEnabled() != false;
            if (Boolean.TRUE.equals(showDashboard)) {
                showDashboard = Boolean.TRUE.equals(widget.getIsSystemWidget()) ? Boolean.valueOf(showSystemDashboards) : (widget.getCreatedBy().equals(userName) ? Boolean.valueOf(true) : Boolean.valueOf(false));
            }
            if (!Boolean.TRUE.equals(showDashboard)) continue;
            Dashboard row = new Dashboard();
            row.setWidgetId(widget.getCode());
            row.setDashboardType(widget.getWidgetType().getCode());
            row.setDashboardName(widget.getName());
            row.setChartType(widget.getChartType());
            returnValue.getDashboards().add(row);
        }
        return returnValue;
    }

    public List<UserDashboardsGroupModel> getUserDashboardsV2(String userName) {
        boolean showSystemDashboards = this.userDetailConfiguration.hasRole(userName, "ROLE_NMS_USER") || this.userDetailConfiguration.hasRole(userName, "ROLE_ADMIN") || this.userDetailConfiguration.hasRole(userName, "ROLE_NMSADMIN") || this.userDetailConfiguration.hasRole(userName, "ROLE_NMS_VIEWER");
        ArrayList<UserDashboardsGroupModel> returnValue = new ArrayList<UserDashboardsGroupModel>();
        List listGroup = this.dashboardGroupRepo.findAll();
        for (DashboardGroup result : listGroup) {
            UserDashboardsGroupModel dashboardGroup = new UserDashboardsGroupModel();
            dashboardGroup.setId(result.getId());
            dashboardGroup.setCode(result.getCode());
            dashboardGroup.setIcon(result.getIcon());
            dashboardGroup.setName(result.getName());
            UserDashboards dashboardsInGroup = new UserDashboards();
            dashboardsInGroup.setUserName(userName);
            dashboardsInGroup.setIsAdmin(Boolean.valueOf(true));
            dashboardsInGroup.setDashboards(new ArrayList());
            WidgetType widgetType = new WidgetType();
            widgetType.setId(Constants.DASHBOARD_ID);
            List widgets = this.widgetListRepository.findByWidgetTypeOrderByChartTypeAscNameAsc(widgetType);
            for (WidgetList widget : widgets) {
                if (widget.getDashboardGroup() == null) continue;
                Boolean showDashboard = widget.getEnabled() != null && widget.getEnabled() != false;
                if (Boolean.TRUE.equals(showDashboard)) {
                    showDashboard = Boolean.TRUE.equals(widget.getIsSystemWidget()) ? Boolean.valueOf(showSystemDashboards) : (widget.getCreatedBy().equals(userName) ? Boolean.valueOf(true) : Boolean.valueOf(false));
                }
                if (!Boolean.TRUE.equals(showDashboard) || !widget.getDashboardGroup().equals(result.getId())) continue;
                Dashboard row = new Dashboard();
                row.setWidgetId(widget.getCode());
                row.setDashboardType(widget.getWidgetType().getCode());
                row.setDashboardName(widget.getName());
                row.setChartType(widget.getChartType());
                dashboardsInGroup.getDashboards().add(row);
            }
            if (dashboardsInGroup.getDashboards().isEmpty()) continue;
            dashboardGroup.setDashboard(dashboardsInGroup);
            returnValue.add(dashboardGroup);
        }
        return returnValue;
    }
}

