/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.outage.service;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.Outage;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.OutageRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.Messaging;
import com.coraltele.telemetry.service.coralnms.scada_assets.model.SCADAAssetModel;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class OutageService {
    @Autowired
    OutageRepository outageRepository;

    public void switchPortUp(SCADAAssetModel asset) {
        List outages = this.outageRepository.findByNodeIdAndServiceNameAndStatus(asset.getNodeId(), "PORT", false);
        for (Outage outage : outages) {
            outage.setOutageClosedOn(Long.valueOf(System.currentTimeMillis()));
            outage.setSeverityForeGroundColor(Constants.foregroundColorSeverityOK);
            outage.setSeverityBackGroundColor(Constants.backgroundColorSeverityOK);
            this.outageRepository.save((Object)outage);
            Messaging.getMessagingTemplate().convertAndSend((Object)String.format("/app/v2/messaging/topic/%s", "events"), (Object)outage);
        }
    }

    public void switchPortDown(SCADAAssetModel asset) {
        Outage outage = new Outage();
        outage.setNodeId(asset.getNodeId());
        outage.setNodeName(asset.getNodeName());
        outage.setIpAddress(asset.getIpAddress());
        outage.setCategory(asset.getCategory());
        outage.setOid(asset.getOid());
        outage.setStatus(false);
        outage.setSwitchIP(asset.getSwitchIP());
        outage.setSwitchPort(asset.getSwitchPort());
        outage.setStackId(asset.getStackId());
        outage.setLocation(asset.getLocation());
        outage.setSeverity(Integer.valueOf(4));
        outage.setServiceName("PORT");
        outage.setSeverityForeGroundColor(Constants.foregroundColorSeverityCritical);
        outage.setSeverityBackGroundColor(Constants.backgroundColorSeverityCritical);
        outage.setOutageReportedOn(Long.valueOf(System.currentTimeMillis()));
        outage.setOutageClosedOn(null);
        this.outageRepository.save((Object)outage);
        Messaging.getMessagingTemplate().convertAndSend((Object)String.format("/app/v2/messaging/topic/%s", "events"), (Object)outage);
    }
}

