/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.helper;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;

/*
 * Exception performing whole class analysis ignored.
 */
public class CIDRIterator {
    private CIDRIterator() {
    }

    public static List<String> getAllIPAddresses(String subnetAddress, int prefixLength) {
        ArrayList<String> ipAddresses = new ArrayList<String>();
        try {
            InetAddress networkAddress = InetAddress.getByName(subnetAddress);
            byte[] networkBytes = networkAddress.getAddress();
            int numAddresses = (int)Math.pow(2.0, 32 - prefixLength);
            for (int i = 0; i < numAddresses; ++i) {
                byte[] ipAddressBytes = CIDRIterator.incrementIPAddress((byte[])networkBytes, (int)i);
                try {
                    InetAddress ipAddress = InetAddress.getByAddress(ipAddressBytes);
                    ipAddresses.add(ipAddress.getHostAddress());
                    continue;
                }
                catch (UnknownHostException e) {
                    e.printStackTrace();
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return ipAddresses;
    }

    public static byte[] incrementIPAddress(byte[] ipAddressBytes, int increment) {
        int address = CIDRIterator.byteArrayToInt((byte[])ipAddressBytes);
        return CIDRIterator.intToByteArray((int)(address += increment));
    }

    public static int byteArrayToInt(byte[] bytes) {
        int value = 0;
        for (int i = 0; i < bytes.length; ++i) {
            value = (value << 8) + (bytes[i] & 0xFF);
        }
        return value;
    }

    public static byte[] intToByteArray(int value) {
        return new byte[]{(byte)(value >> 24), (byte)(value >> 16), (byte)(value >> 8), (byte)value};
    }
}

