/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.helper.Constants;
import java.time.Instant;
import java.util.HashMap;
import java.util.Optional;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.snmp4j.CommunityTarget;
import org.snmp4j.PDU;
import org.snmp4j.Snmp;
import org.snmp4j.Target;
import org.snmp4j.TransportMapping;
import org.snmp4j.event.ResponseEvent;
import org.snmp4j.smi.Address;
import org.snmp4j.smi.GenericAddress;
import org.snmp4j.smi.Integer32;
import org.snmp4j.smi.Null;
import org.snmp4j.smi.OID;
import org.snmp4j.smi.OctetString;
import org.snmp4j.smi.Variable;
import org.snmp4j.smi.VariableBinding;
import org.snmp4j.transport.DefaultUdpTransportMapping;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
public class SwitchTopologyProcess {
    private static final Logger logger = LogManager.getLogger(SwitchTopologyProcess.class);
    private long lastBulkProcessing = 0L;
    private ExecutorService executorService;
    private String[] switchCategories = new String[]{"L2", "L3"};
    private String MAC_TABLE_OID = "1.3.6.1.2.1.17.7.1.2.2.1.2";
    private String MAC_TABLE_SNMP_VERSION = "v2";
    private String MAC_TABLE_COMMUNITY = "public";
    private Integer MAC_TABLE_SWITCH_UDP_PORT = 161;
    private int switchCount = 0;
    @Autowired
    SCADAAssetRepository scadaAssetRepository;

    @PostConstruct
    public void init() {
        for (String switchCategory : this.switchCategories) {
            this.switchCount += this.scadaAssetRepository.findAllByCategory(switchCategory).size();
        }
        if (this.switchCount > 0) {
            this.executorService = new ThreadPoolExecutor(1, 1, 10000L, TimeUnit.MILLISECONDS, new ArrayBlockingQueue<Runnable>(this.switchCount * 3));
        }
    }

    @Scheduled(fixedRate=5000L)
    public void startService() {
        long currentTime = Instant.now().getEpochSecond();
        if (this.switchCount > 0 && (this.lastBulkProcessing == 0L || (currentTime - this.lastBulkProcessing) / 60L >= Constants.SWITCH_TOPOLOGY_SCAN_INTERVAL)) {
            logger.info("Starting switch topology");
            for (String switchCategory : this.switchCategories) {
                logger.info("Starting switch topology for switch category {} ", (Object)switchCategory);
                this.scadaAssetRepository.findAllByCategory(switchCategory).forEach(networkSwitch -> {
                    logger.info("Starting switch topology for switch  {} {}", (Object)networkSwitch.getNodeName(), (Object)networkSwitch.getIpAddress());
                    this.executeTask(() -> this.getPortDetails(networkSwitch));
                });
            }
            this.lastBulkProcessing = currentTime;
        }
    }

    public void updateSwitchInfo(String ipAddress) {
        Optional asset = this.scadaAssetRepository.findByIpAddress(ipAddress);
        if (asset.isPresent()) {
            this.executeTask(() -> this.getPortDetails((SCADAAsset)asset.get()));
        }
    }

    public void executeTask(Runnable task) {
        try {
            this.executorService.submit(task);
        }
        catch (RejectedExecutionException e) {
            logger.error("Task rejected due to queue limit: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getPortDetails(SCADAAsset switchDetails) {
        Address targetAddress = GenericAddress.parse((String)("udp:" + switchDetails.getIpAddress() + "/" + this.MAC_TABLE_SWITCH_UDP_PORT));
        Snmp snmp = null;
        HashMap<Integer, HashMap> trunkPort = new HashMap<Integer, HashMap>();
        HashMap<String, Integer> macList = new HashMap<String, Integer>();
        try {
            DefaultUdpTransportMapping transport = new DefaultUdpTransportMapping();
            snmp = new Snmp((TransportMapping)transport);
            transport.listen();
            CommunityTarget target = new CommunityTarget();
            target.setCommunity(new OctetString(this.MAC_TABLE_COMMUNITY));
            target.setAddress(targetAddress);
            target.setRetries(2);
            target.setTimeout(1500L);
            target.setVersion(1);
            PDU pdu = new PDU();
            pdu.setType(-95);
            OID oid = new OID(this.MAC_TABLE_OID);
            pdu.add(new VariableBinding(oid));
            boolean finished = false;
            while (!finished) {
                ResponseEvent responseEvent = snmp.send(pdu, (Target)target);
                PDU response = responseEvent.getResponse();
                if (response == null) {
                    finished = true;
                    break;
                }
                VariableBinding vb = response.get(0);
                if (response.getErrorStatus() != 0) {
                    finished = true;
                    continue;
                }
                if (vb.getOid() == null) {
                    finished = true;
                    continue;
                }
                if (vb.getOid().size() < oid.size() || oid.leftMostCompare(oid.size(), vb.getOid()) != 0) {
                    finished = true;
                    continue;
                }
                if (Null.isExceptionSyntax((int)vb.getVariable().getSyntax())) {
                    finished = true;
                    continue;
                }
                if (vb.getOid().compareTo((Variable)oid) <= 0) {
                    finished = true;
                    continue;
                }
                String oidString = vb.getOid().toString().replace(this.MAC_TABLE_OID + ".", "");
                String[] oidParts = oidString.split("\\.");
                if (oidParts.length == 7) {
                    Integer h1 = Integer.parseInt(oidParts[1]);
                    Integer h2 = Integer.parseInt(oidParts[2]);
                    Integer h3 = Integer.parseInt(oidParts[3]);
                    Integer h4 = Integer.parseInt(oidParts[4]);
                    Integer h5 = Integer.parseInt(oidParts[5]);
                    Integer h6 = Integer.parseInt(oidParts[6]);
                    String macAddress = this.getMACHex(Integer.toHexString(h1)) + "-" + this.getMACHex(Integer.toHexString(h2)) + "-" + this.getMACHex(Integer.toHexString(h3)) + "-" + this.getMACHex(Integer.toHexString(h4)) + "-" + this.getMACHex(Integer.toHexString(h5)) + "-" + this.getMACHex(Integer.toHexString(h6));
                    Integer devicePort = Integer.parseInt(vb.getVariable().toString());
                    pdu.setRequestID(new Integer32(0));
                    pdu.set(0, vb);
                    logger.info("{} ==>  VLan : {} MAC Address : {}, Port : {}", (Object)switchDetails, (Object)oidParts[0], (Object)macAddress, (Object)vb.getVariable());
                    macList.put(macAddress, devicePort);
                    HashMap portVlans = null;
                    if (!trunkPort.containsKey(devicePort)) {
                        portVlans = new HashMap();
                        trunkPort.put(devicePort, portVlans);
                    } else {
                        portVlans = (HashMap)trunkPort.get(devicePort);
                    }
                    if (portVlans.containsKey(oidParts[0])) continue;
                    portVlans.put(oidParts[0], oidParts[0]);
                    continue;
                }
                logger.info("Invalid OID {}", (Object)oidString);
            }
            macList.forEach((key, value) -> {
                HashMap vlans = (HashMap)trunkPort.get(value);
                if (vlans.size() > 1) {
                    logger.info("MAC Address {} is on trunk port {} ", key, value);
                } else {
                    this.scadaAssetRepository.findByMacAddress(key).forEach(asset -> {
                        asset.setLocation(switchDetails.getLocation());
                        asset.setSwitchIP(switchDetails.getIpAddress());
                        asset.setSwitchPort(value);
                        this.scadaAssetRepository.save(asset);
                        logger.info("Assigned Switch details to {} : {} : {} => {} : {} :  {}", (Object)asset.getNodeName(), (Object)asset.getIpAddress(), (Object)asset.getMacAddress(), (Object)asset.getSwitchIP(), (Object)asset.getSwitchPort(), (Object)asset.getLocation());
                    });
                }
            });
        }
        catch (Exception e) {
            logger.error("Unable to process SNMP Walk for {} ", (Object)switchDetails);
        }
        finally {
            try {
                if (snmp != null) {
                    snmp.close();
                }
            }
            catch (Exception e) {
                logger.error("Unable to Grace fully close SNMP Walk for {} ", (Object)switchDetails);
            }
        }
    }

    private String getMACHex(String value) {
        while (value.length() < 2) {
            value = "0" + value;
        }
        return value.toLowerCase();
    }

    @PreDestroy
    public void destroy() {
        if (this.executorService != null) {
            this.executorService.shutdown();
        }
    }
}

