/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.helper;

import com.coraltele.telemetry.db.telephony.main.entity.ExtensionState;
import com.coraltele.telemetry.db.telephony.main.repository.ExtensionStateRepository;
import java.time.Instant;
import java.util.Map;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.freeswitch.esl.client.IEslEventListener;
import org.freeswitch.esl.client.transport.event.EslEvent;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;

@Component
public class FreeSwitchEventListener
implements IEslEventListener {
    private static final Logger logger = LogManager.getLogger(FreeSwitchEventListener.class);
    @Autowired
    private ExtensionStateRepository extensionStateRepository;

    public void eventReceived(EslEvent event) {
        try {
            String eventName = event.getEventName();
            Map headers = event.getEventHeaders();
            logger.debug("========================= FreeSWITCH Event Start ==========================");
            logger.debug("Event Name: {}", (Object)eventName);
            logger.debug("Caller-Caller-ID-Number: {}", headers.get("Caller-Caller-ID-Number"));
            logger.debug("Caller-Destination-Number: {}", headers.get("Caller-Destination-Number"));
            logger.debug("Channel-State: {}", headers.get("Channel-State"));
            logger.debug("Channel-Call-State: {}", headers.get("Channel-Call-State"));
            logger.debug("============================== Event End ==============================");
            if ("CHANNEL_STATE".equalsIgnoreCase(eventName)) {
                String callerNumber = (String)headers.get("Caller-Caller-ID-Number");
                Long eventEpoch = Instant.now().getEpochSecond();
                if (StringUtils.hasText((String)callerNumber)) {
                    Optional extensionDetails = this.extensionStateRepository.findByExtension(callerNumber);
                    if (extensionDetails.isPresent()) {
                        ExtensionState dataToSave = (ExtensionState)extensionDetails.get();
                        dataToSave.setEventUpdatedEpoch(eventEpoch);
                        this.extensionStateRepository.save((Object)dataToSave);
                    } else {
                        ExtensionState dataToSave = new ExtensionState();
                        dataToSave.setExtension(callerNumber);
                        dataToSave.setEventUpdatedEpoch(eventEpoch);
                        this.extensionStateRepository.save((Object)dataToSave);
                    }
                }
                logger.info("Extension Data update for : {}", (Object)callerNumber);
            }
        }
        catch (Exception e) {
            logger.error("Error while saving data : {} {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public void backgroundJobResultReceived(EslEvent event) {
        logger.info("Free Switch Background Job Results: {}", (Object)event.getEventHeaders());
        logger.info("Free Switch Background Job Results: {}", (Object)event.getMessageHeaders());
    }
}

