/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.db.telemetry.coralnms.entity;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAsset;
import com.fasterxml.jackson.annotation.JsonFormat;
import java.time.LocalDateTime;
import java.util.UUID;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.ManyToOne;
import javax.persistence.PrePersist;
import javax.persistence.PreUpdate;
import javax.persistence.Table;
import lombok.Generated;

@Entity
@Table(name="imsi", schema="coralnms")
public class IMSI {
    @Id
    @Column(name="imsi_number")
    private String imsiNumber;
    @Column(name="cell_id")
    private String cellId;
    private Boolean connected;
    private UUID uuid;
    @ManyToOne
    @JoinColumn(name="asset_id", nullable=false)
    private SCADAAsset asset;
    @Column(name="extension_number")
    private String extensionNumber;
    @Column(name="extension_name")
    private String extensionName;
    @Column(name="geox")
    private String geoX;
    @Column(name="geoy")
    private String geoY;
    @Column(name="data", columnDefinition="text")
    private String data;
    @Column(name="emergency_status")
    private String emergencyStatus;
    @Column(name="data_rate_epoch")
    private Long dataRateEpoch;
    @Column(name="ul_data_rate")
    private Double ulDataRate;
    @Column(name="dl_data_rate")
    private Double dlDataRate;
    @Column(name="ipAddress")
    private String ipAddress;
    @Column(name="ims_ipAddress")
    private String imsIpAddress;
    private String zone;
    private String department;
    private String name;
    private String bloodgroup;
    private String haddredd;
    private String oaddress;
    private String pecname;
    private String pecnumber;
    private String secname;
    private String secnumber;
    private String meddetails;
    private String userName;
    private String alias;
    private String direction;
    private String deviceType;
    @Column(name="createdon")
    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    private LocalDateTime createdOn;
    @Column(name="registration_type")
    private Integer registrationType;
    @Column(name="train_number")
    private String trainNumber;
    @Column(name="radio_link_epoch")
    private Long radioLinkEpoch;
    @Column(name="radio_link_status")
    private Boolean rLinkStatus;
    @Column(name="updated_on")
    private Long updatedOn;
    @Column(name="updated_by")
    private String updatedBy;
    @Column(name="device_id")
    private String deviceId;
    @Column(name="battery_percent")
    private Integer batteryPercentage;
    @Column(name="rsrp_sim1")
    private Integer rsRpSim1;
    @Column(name="rsrp_sim2")
    private Integer rsRpSim2;
    @Column(name="pending_for_sync")
    private Integer pendingForSync;
    private Long ulData;
    private Long dlData;
    @Column(name="last_connected_on")
    private Long lastConnectionOn;

    @PrePersist
    public void beforeSave() {
        if (this.uuid == null) {
            this.uuid = UUID.randomUUID();
        }
        this.ulData = 0L;
        this.dlData = 0L;
        this.pendingForSync = 1;
    }

    @PreUpdate
    public void beforeUpdate() {
        if (!this.connected.booleanValue()) {
            this.ulData = 0L;
            this.dlData = 0L;
            this.ulDataRate = 0.0;
            this.dlDataRate = 0.0;
        }
        this.pendingForSync = 1;
    }

    @Generated
    public String getImsiNumber() {
        return this.imsiNumber;
    }

    @Generated
    public String getCellId() {
        return this.cellId;
    }

    @Generated
    public Boolean getConnected() {
        return this.connected;
    }

    @Generated
    public UUID getUuid() {
        return this.uuid;
    }

    @Generated
    public SCADAAsset getAsset() {
        return this.asset;
    }

    @Generated
    public String getExtensionNumber() {
        return this.extensionNumber;
    }

    @Generated
    public String getExtensionName() {
        return this.extensionName;
    }

    @Generated
    public String getGeoX() {
        return this.geoX;
    }

    @Generated
    public String getGeoY() {
        return this.geoY;
    }

    @Generated
    public String getData() {
        return this.data;
    }

    @Generated
    public String getEmergencyStatus() {
        return this.emergencyStatus;
    }

    @Generated
    public Long getDataRateEpoch() {
        return this.dataRateEpoch;
    }

    @Generated
    public Double getUlDataRate() {
        return this.ulDataRate;
    }

    @Generated
    public Double getDlDataRate() {
        return this.dlDataRate;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public String getImsIpAddress() {
        return this.imsIpAddress;
    }

    @Generated
    public String getZone() {
        return this.zone;
    }

    @Generated
    public String getDepartment() {
        return this.department;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getBloodgroup() {
        return this.bloodgroup;
    }

    @Generated
    public String getHaddredd() {
        return this.haddredd;
    }

    @Generated
    public String getOaddress() {
        return this.oaddress;
    }

    @Generated
    public String getPecname() {
        return this.pecname;
    }

    @Generated
    public String getPecnumber() {
        return this.pecnumber;
    }

    @Generated
    public String getSecname() {
        return this.secname;
    }

    @Generated
    public String getSecnumber() {
        return this.secnumber;
    }

    @Generated
    public String getMeddetails() {
        return this.meddetails;
    }

    @Generated
    public String getUserName() {
        return this.userName;
    }

    @Generated
    public String getAlias() {
        return this.alias;
    }

    @Generated
    public String getDirection() {
        return this.direction;
    }

    @Generated
    public String getDeviceType() {
        return this.deviceType;
    }

    @Generated
    public LocalDateTime getCreatedOn() {
        return this.createdOn;
    }

    @Generated
    public Integer getRegistrationType() {
        return this.registrationType;
    }

    @Generated
    public String getTrainNumber() {
        return this.trainNumber;
    }

    @Generated
    public Long getRadioLinkEpoch() {
        return this.radioLinkEpoch;
    }

    @Generated
    public Boolean getRLinkStatus() {
        return this.rLinkStatus;
    }

    @Generated
    public Long getUpdatedOn() {
        return this.updatedOn;
    }

    @Generated
    public String getUpdatedBy() {
        return this.updatedBy;
    }

    @Generated
    public String getDeviceId() {
        return this.deviceId;
    }

    @Generated
    public Integer getBatteryPercentage() {
        return this.batteryPercentage;
    }

    @Generated
    public Integer getRsRpSim1() {
        return this.rsRpSim1;
    }

    @Generated
    public Integer getRsRpSim2() {
        return this.rsRpSim2;
    }

    @Generated
    public Integer getPendingForSync() {
        return this.pendingForSync;
    }

    @Generated
    public Long getUlData() {
        return this.ulData;
    }

    @Generated
    public Long getDlData() {
        return this.dlData;
    }

    @Generated
    public Long getLastConnectionOn() {
        return this.lastConnectionOn;
    }

    @Generated
    public void setImsiNumber(String imsiNumber) {
        this.imsiNumber = imsiNumber;
    }

    @Generated
    public void setCellId(String cellId) {
        this.cellId = cellId;
    }

    @Generated
    public void setConnected(Boolean connected) {
        this.connected = connected;
    }

    @Generated
    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    @Generated
    public void setAsset(SCADAAsset asset) {
        this.asset = asset;
    }

    @Generated
    public void setExtensionNumber(String extensionNumber) {
        this.extensionNumber = extensionNumber;
    }

    @Generated
    public void setExtensionName(String extensionName) {
        this.extensionName = extensionName;
    }

    @Generated
    public void setGeoX(String geoX) {
        this.geoX = geoX;
    }

    @Generated
    public void setGeoY(String geoY) {
        this.geoY = geoY;
    }

    @Generated
    public void setData(String data) {
        this.data = data;
    }

    @Generated
    public void setEmergencyStatus(String emergencyStatus) {
        this.emergencyStatus = emergencyStatus;
    }

    @Generated
    public void setDataRateEpoch(Long dataRateEpoch) {
        this.dataRateEpoch = dataRateEpoch;
    }

    @Generated
    public void setUlDataRate(Double ulDataRate) {
        this.ulDataRate = ulDataRate;
    }

    @Generated
    public void setDlDataRate(Double dlDataRate) {
        this.dlDataRate = dlDataRate;
    }

    @Generated
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Generated
    public void setImsIpAddress(String imsIpAddress) {
        this.imsIpAddress = imsIpAddress;
    }

    @Generated
    public void setZone(String zone) {
        this.zone = zone;
    }

    @Generated
    public void setDepartment(String department) {
        this.department = department;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setBloodgroup(String bloodgroup) {
        this.bloodgroup = bloodgroup;
    }

    @Generated
    public void setHaddredd(String haddredd) {
        this.haddredd = haddredd;
    }

    @Generated
    public void setOaddress(String oaddress) {
        this.oaddress = oaddress;
    }

    @Generated
    public void setPecname(String pecname) {
        this.pecname = pecname;
    }

    @Generated
    public void setPecnumber(String pecnumber) {
        this.pecnumber = pecnumber;
    }

    @Generated
    public void setSecname(String secname) {
        this.secname = secname;
    }

    @Generated
    public void setSecnumber(String secnumber) {
        this.secnumber = secnumber;
    }

    @Generated
    public void setMeddetails(String meddetails) {
        this.meddetails = meddetails;
    }

    @Generated
    public void setUserName(String userName) {
        this.userName = userName;
    }

    @Generated
    public void setAlias(String alias) {
        this.alias = alias;
    }

    @Generated
    public void setDirection(String direction) {
        this.direction = direction;
    }

    @Generated
    public void setDeviceType(String deviceType) {
        this.deviceType = deviceType;
    }

    @JsonFormat(pattern="yyyy-MM-dd HH:mm:ss")
    @Generated
    public void setCreatedOn(LocalDateTime createdOn) {
        this.createdOn = createdOn;
    }

    @Generated
    public void setRegistrationType(Integer registrationType) {
        this.registrationType = registrationType;
    }

    @Generated
    public void setTrainNumber(String trainNumber) {
        this.trainNumber = trainNumber;
    }

    @Generated
    public void setRadioLinkEpoch(Long radioLinkEpoch) {
        this.radioLinkEpoch = radioLinkEpoch;
    }

    @Generated
    public void setRLinkStatus(Boolean rLinkStatus) {
        this.rLinkStatus = rLinkStatus;
    }

    @Generated
    public void setUpdatedOn(Long updatedOn) {
        this.updatedOn = updatedOn;
    }

    @Generated
    public void setUpdatedBy(String updatedBy) {
        this.updatedBy = updatedBy;
    }

    @Generated
    public void setDeviceId(String deviceId) {
        this.deviceId = deviceId;
    }

    @Generated
    public void setBatteryPercentage(Integer batteryPercentage) {
        this.batteryPercentage = batteryPercentage;
    }

    @Generated
    public void setRsRpSim1(Integer rsRpSim1) {
        this.rsRpSim1 = rsRpSim1;
    }

    @Generated
    public void setRsRpSim2(Integer rsRpSim2) {
        this.rsRpSim2 = rsRpSim2;
    }

    @Generated
    public void setPendingForSync(Integer pendingForSync) {
        this.pendingForSync = pendingForSync;
    }

    @Generated
    public void setUlData(Long ulData) {
        this.ulData = ulData;
    }

    @Generated
    public void setDlData(Long dlData) {
        this.dlData = dlData;
    }

    @Generated
    public void setLastConnectionOn(Long lastConnectionOn) {
        this.lastConnectionOn = lastConnectionOn;
    }
}

