/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.db.coralapps.entity;

import com.coraltele.telemetry.db.coralapps.key.AgentRealTimeKey;
import java.time.LocalDateTime;
import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.Subselect;
import org.springframework.data.annotation.Immutable;

@Entity
@Subselect(value="select a.name as agent,t.queue,a.agent_full_name as full_name,a.defaultqueue,reverse(split_part(reverse(split_part(a.contact,'@',1)),'/',1)) as contact_number,\na.last_offered_call, m.cid_number as talking_to, a.last_bridge_end,a.last_status_change ,a.last_datetime ,mq.description as queue_name,\nt.state as tier_state,m.state as member_state,\na.status as agent_status,a.state as agent_state,m.session_uuid,\n        case when lower(a.status) like 'available%' or lower(a.status) like '%break%' or lower(a.status) like '%logged in%' then 1 else 0 end as logged_in,\n        case when lower(a.status) like '%break%' then 1 else 0 end as on_break,\n        case \n        when coalesce(a.status, '') = '' then 'Activating'\n        when lower(a.status) like 'available%' then\n                case \n                    when coalesce(a.state, '') = '' then 'Updating'\n                    when a.state = 'Waiting' then 'Idle'\n                    when a.state = 'Idle' then 'ACW'\n                    when a.state = 'In a queue call' then 'Talk'\n                    when a.state = 'Receiving' THEN 'Ring'\n                    else a.state\n                end\n        when lower(a.status) like '%break%' then 'Break'\n        when lower(a.status) like '%logged out%' then 'Log Out'\n        when lower(a.status) like '%logged in%' then 'NTC'\n        else a.status \n        end as live_state\n        from agents a\n        inner join tiers t on a.\"name\" = t.agent\n        inner join callcenter.m_queue mq on t.queue = mq.systemname\n        left join members m on a.\"name\" = m.serving_agent\n        where t.queue not like 'ACD_%'\n")
@Immutable
@Table(name="agent_real_time")
public class AgentRealTime {
    @EmbeddedId
    private AgentRealTimeKey agentRealTimeKey;
    @Column(name="full_name")
    private String fullName;
    @Column(name="contact_number")
    private String contactNumber;
    @Column(name="last_offered_call")
    private String lastOfferedCall;
    @Column(name="last_bridge_end")
    private String lastBridgeEnd;
    @Column(name="last_datetime")
    private LocalDateTime lastDateTime;
    @Column(name="tier_state")
    private String tierState;
    @Column(name="member_state")
    private String memberState;
    @Column(name="agent_status")
    private String agentStatus;
    @Column(name="agent_state")
    private String agentState;
    @Column(name="live_state")
    private String liveState;
    @Column(name="logged_in")
    private Integer loggedIn;
    @Column(name="on_break")
    private Integer onBreak;
    @Column(name="queue_name")
    private String queueName;
    @Column(name="talking_to")
    private String talkingTo;
    @Column(name="defaultqueue")
    private String defaultQueue;
    @Column(name="session_uuid")
    private String sessionUuid;

    @Generated
    public AgentRealTimeKey getAgentRealTimeKey() {
        return this.agentRealTimeKey;
    }

    @Generated
    public String getFullName() {
        return this.fullName;
    }

    @Generated
    public String getContactNumber() {
        return this.contactNumber;
    }

    @Generated
    public String getLastOfferedCall() {
        return this.lastOfferedCall;
    }

    @Generated
    public String getLastBridgeEnd() {
        return this.lastBridgeEnd;
    }

    @Generated
    public LocalDateTime getLastDateTime() {
        return this.lastDateTime;
    }

    @Generated
    public String getTierState() {
        return this.tierState;
    }

    @Generated
    public String getMemberState() {
        return this.memberState;
    }

    @Generated
    public String getAgentStatus() {
        return this.agentStatus;
    }

    @Generated
    public String getAgentState() {
        return this.agentState;
    }

    @Generated
    public String getLiveState() {
        return this.liveState;
    }

    @Generated
    public Integer getLoggedIn() {
        return this.loggedIn;
    }

    @Generated
    public Integer getOnBreak() {
        return this.onBreak;
    }

    @Generated
    public String getQueueName() {
        return this.queueName;
    }

    @Generated
    public String getTalkingTo() {
        return this.talkingTo;
    }

    @Generated
    public String getDefaultQueue() {
        return this.defaultQueue;
    }

    @Generated
    public String getSessionUuid() {
        return this.sessionUuid;
    }

    @Generated
    public void setAgentRealTimeKey(AgentRealTimeKey agentRealTimeKey) {
        this.agentRealTimeKey = agentRealTimeKey;
    }

    @Generated
    public void setFullName(String fullName) {
        this.fullName = fullName;
    }

    @Generated
    public void setContactNumber(String contactNumber) {
        this.contactNumber = contactNumber;
    }

    @Generated
    public void setLastOfferedCall(String lastOfferedCall) {
        this.lastOfferedCall = lastOfferedCall;
    }

    @Generated
    public void setLastBridgeEnd(String lastBridgeEnd) {
        this.lastBridgeEnd = lastBridgeEnd;
    }

    @Generated
    public void setLastDateTime(LocalDateTime lastDateTime) {
        this.lastDateTime = lastDateTime;
    }

    @Generated
    public void setTierState(String tierState) {
        this.tierState = tierState;
    }

    @Generated
    public void setMemberState(String memberState) {
        this.memberState = memberState;
    }

    @Generated
    public void setAgentStatus(String agentStatus) {
        this.agentStatus = agentStatus;
    }

    @Generated
    public void setAgentState(String agentState) {
        this.agentState = agentState;
    }

    @Generated
    public void setLiveState(String liveState) {
        this.liveState = liveState;
    }

    @Generated
    public void setLoggedIn(Integer loggedIn) {
        this.loggedIn = loggedIn;
    }

    @Generated
    public void setOnBreak(Integer onBreak) {
        this.onBreak = onBreak;
    }

    @Generated
    public void setQueueName(String queueName) {
        this.queueName = queueName;
    }

    @Generated
    public void setTalkingTo(String talkingTo) {
        this.talkingTo = talkingTo;
    }

    @Generated
    public void setDefaultQueue(String defaultQueue) {
        this.defaultQueue = defaultQueue;
    }

    @Generated
    public void setSessionUuid(String sessionUuid) {
        this.sessionUuid = sessionUuid;
    }

    @Generated
    public AgentRealTime() {
    }

    @Generated
    public AgentRealTime(AgentRealTimeKey agentRealTimeKey, String fullName, String contactNumber, String lastOfferedCall, String lastBridgeEnd, LocalDateTime lastDateTime, String tierState, String memberState, String agentStatus, String agentState, String liveState, Integer loggedIn, Integer onBreak, String queueName, String talkingTo, String defaultQueue, String sessionUuid) {
        this.agentRealTimeKey = agentRealTimeKey;
        this.fullName = fullName;
        this.contactNumber = contactNumber;
        this.lastOfferedCall = lastOfferedCall;
        this.lastBridgeEnd = lastBridgeEnd;
        this.lastDateTime = lastDateTime;
        this.tierState = tierState;
        this.memberState = memberState;
        this.agentStatus = agentStatus;
        this.agentState = agentState;
        this.liveState = liveState;
        this.loggedIn = loggedIn;
        this.onBreak = onBreak;
        this.queueName = queueName;
        this.talkingTo = talkingTo;
        this.defaultQueue = defaultQueue;
        this.sessionUuid = sessionUuid;
    }
}

