/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.service;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.Alert;
import com.coraltele.telemetry.db.telemetry.main.entity.NodePosition;
import com.coraltele.telemetry.db.telemetry.main.repository.AlertRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.NodePositionRepository;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.PreferenceModel;
import java.time.Instant;
import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class LinkViewService {
    private static final Logger logger = LogManager.getLogger(LinkViewService.class);
    private static final DateTimeFormatter ALARM_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    @Autowired
    private SCADAAssetRepository scadaAssetRepository;
    @Autowired
    private NodePositionRepository nodePositionRepository;
    @Autowired
    private AlertRepository alertRepository;

    public RequestResponse getNodesByViewMode(String viewMode, String location) {
        RequestResponse response = new RequestResponse();
        try {
            List filteredAssets;
            logger.info("Fetching nodes for viewMode: {}, location: {}", (Object)viewMode, (Object)location);
            List allAssets = this.scadaAssetRepository.findAll();
            if ("top-level".equals(viewMode)) {
                filteredAssets = allAssets.stream().filter(asset -> {
                    String category = asset.getCategory();
                    return StringUtils.hasText((String)category) && ("L2".equals(category) || "L3".equals(category));
                }).collect(Collectors.toList());
                logger.info("Found {} L2/L3 assets for top-level view", (Object)filteredAssets.size());
            } else {
                filteredAssets = allAssets.stream().filter(asset -> StringUtils.hasText((String)location) && location.equals(asset.getLocation())).collect(Collectors.toList());
                logger.info("Found {} assets for location: {}", (Object)filteredAssets.size(), (Object)location);
            }
            HashMap<Long, Object> assetMap = new HashMap<Long, Object>();
            for (Object asset2 : filteredAssets) {
                if (asset2.getId() == null) continue;
                assetMap.put(asset2.getId(), asset2);
            }
            ArrayList<PreferenceModel.LinkViewNode> nodes = new ArrayList<PreferenceModel.LinkViewNode>();
            for (SCADAAsset asset3 : filteredAssets) {
                NodePosition nodePosition;
                Optional nodePositionOpt;
                String nodePositionId;
                PreferenceModel.LinkViewNode node = new PreferenceModel.LinkViewNode();
                node.setId(asset3.getUuid() != null ? asset3.getUuid().toString() : null);
                node.setType(asset3.getCategory());
                node.setLabel(asset3.getNodeName());
                node.setLocation(asset3.getLocation());
                node.setSeverity(Integer.valueOf(0));
                node.setCategory(asset3.getCategory());
                node.setAssetId(asset3.getId());
                node.setIpAddress(asset3.getIpAddress());
                node.setChildrenSeverity(Integer.valueOf(0));
                ArrayList<PreferenceModel.AlarmData> alarms = new ArrayList<PreferenceModel.AlarmData>();
                boolean hasICMPAlarm = false;
                if (asset3.getId() != null) {
                    List assetAlerts = this.alertRepository.findByAssetId(asset3.getId()).stream().filter(alert -> !alert.isStatus()).collect(Collectors.toList());
                    for (Alert alert2 : assetAlerts) {
                        PreferenceModel.AlarmData alarmData = new PreferenceModel.AlarmData();
                        StringBuilder alarmText = new StringBuilder();
                        if (alert2.getAlertGeneratedOn() != null) {
                            ZonedDateTime alarmTime = Instant.ofEpochSecond(alert2.getAlertGeneratedOn()).atZone(ZoneId.systemDefault());
                            alarmText.append(alarmTime.format(ALARM_TIME_FORMATTER));
                        }
                        if (asset3.getNodeName() != null) {
                            if (alarmText.length() > 0) {
                                alarmText.append(" - ");
                            }
                            alarmText.append(asset3.getNodeName());
                        }
                        if (alert2.getAlias() != null) {
                            if (alarmText.length() > 0) {
                                alarmText.append(" - ");
                            }
                            alarmText.append(alert2.getAlias());
                        }
                        alarmData.setText(alarmText.toString());
                        alarmData.setSeverity(Integer.valueOf(alert2.getSeverity() != null ? alert2.getSeverity() : 0));
                        alarmData.setCategory(alert2.getCategoryCode());
                        alarms.add(alarmData);
                        if (alarmData.getSeverity() > node.getSeverity()) {
                            node.setSeverity(alarmData.getSeverity());
                        }
                        if (!"ICMP".equalsIgnoreCase(alert2.getServiceCode())) continue;
                        hasICMPAlarm = true;
                    }
                }
                node.setAlarms(alarms);
                node.setStatus(Boolean.valueOf(!hasICMPAlarm));
                if ("top-level".equals(viewMode) && asset3.getUuid() != null) {
                    nodePositionId = "top-level.top-level." + asset3.getUuid().toString();
                    nodePositionOpt = this.nodePositionRepository.findById((Object)nodePositionId);
                    if (nodePositionOpt.isPresent()) {
                        nodePosition = (NodePosition)nodePositionOpt.get();
                        node.setPositionX(nodePosition.getPositionX());
                        node.setPositionY(nodePosition.getPositionY());
                        logger.debug("Found position for node {}: x={}, y={}", (Object)asset3.getUuid(), (Object)nodePosition.getPositionX(), (Object)nodePosition.getPositionY());
                    } else {
                        node.setPositionX(null);
                        node.setPositionY(null);
                    }
                } else {
                    nodePositionId = viewMode + "." + location + "." + asset3.getUuid();
                    nodePositionOpt = this.nodePositionRepository.findById((Object)nodePositionId);
                    if (nodePositionOpt.isPresent()) {
                        nodePosition = (NodePosition)nodePositionOpt.get();
                        node.setPositionX(nodePosition.getPositionX());
                        node.setPositionY(nodePosition.getPositionY());
                        logger.debug("Found position for node {}: x={}, y={}", (Object)asset3.getUuid(), (Object)nodePosition.getPositionX(), (Object)nodePosition.getPositionY());
                    } else {
                        node.setPositionX(null);
                        node.setPositionY(null);
                    }
                }
                boolean hasChildren = false;
                if (asset3.getIpAddress() != null) {
                    hasChildren = allAssets.stream().filter(childAsset -> {
                        String category = childAsset.getCategory();
                        return !StringUtils.hasText((String)category) || !"L2".equals(category) && !"L3".equals(category);
                    }).anyMatch(childAsset -> asset3.getIpAddress().equals(childAsset.getSwitchIP()));
                }
                node.setHasChildren(Boolean.valueOf(hasChildren));
                if (StringUtils.hasText((String)asset3.getSwitchIP())) {
                    filteredAssets.stream().filter(parentAsset -> asset3.getSwitchIP().equals(parentAsset.getIpAddress())).findFirst().ifPresent(parentAsset -> {
                        String parentCategory = parentAsset.getCategory();
                        if (parentAsset.getUuid() != null && StringUtils.hasText((String)parentCategory) && ("L3".equals(parentCategory) || "L2".equals(parentCategory))) {
                            node.setParent(parentAsset.getUuid().toString());
                        }
                    });
                }
                nodes.add(node);
            }
            logger.info("Converted {} assets to LinkViewNode objects with alarms", (Object)nodes.size());
            if ("top-level".equals(viewMode)) {
                this.accumulateAlarmsToParents(nodes, allAssets);
                logger.info("Accumulated alarms to parent nodes");
            }
            List organizedNodes = this.organizeNodesByParentChild(nodes);
            logger.info("Organized nodes hierarchically");
            response.setStatus(0);
            response.setMessage("Nodes retrieved successfully");
            response.setData((Object)organizedNodes);
        }
        catch (Exception e) {
            logger.error("Error fetching nodes for viewMode: {}", (Object)viewMode, (Object)e);
            response.setStatus(1);
            response.setMessage("Failed to retrieve nodes");
            response.setMessageDetail(e.getMessage());
        }
        return response;
    }

    private void accumulateAlarmsToParents(List<PreferenceModel.LinkViewNode> nodes, List<SCADAAsset> allAssets) {
        for (PreferenceModel.LinkViewNode node : nodes) {
            if (!"L2".equals(node.getCategory()) && !"L3".equals(node.getCategory()) || node.getIpAddress() == null) continue;
            List childAssets = allAssets.stream().filter(asset -> node.getIpAddress().equals(asset.getSwitchIP())).collect(Collectors.toList());
            for (SCADAAsset childAsset : childAssets) {
                if (childAsset.getId() == null || "L2".equals(childAsset.getCategory()) || "L3".equals(childAsset.getCategory())) continue;
                List childAlerts = this.alertRepository.findByAssetId(childAsset.getId()).stream().filter(alert -> !alert.isStatus()).collect(Collectors.toList());
                for (Alert alert2 : childAlerts) {
                    PreferenceModel.AlarmData alarmData = new PreferenceModel.AlarmData();
                    StringBuilder alarmText = new StringBuilder();
                    if (alert2.getAlertGeneratedOn() != null) {
                        ZonedDateTime alarmTime = Instant.ofEpochSecond(alert2.getAlertGeneratedOn()).atZone(ZoneId.systemDefault());
                        alarmText.append(alarmTime.format(ALARM_TIME_FORMATTER));
                    }
                    if (childAsset.getNodeName() != null) {
                        if (alarmText.length() > 0) {
                            alarmText.append(" - ");
                        }
                        alarmText.append(childAsset.getNodeName());
                    }
                    if (alert2.getAlias() != null) {
                        if (alarmText.length() > 0) {
                            alarmText.append(" - ");
                        }
                        alarmText.append(alert2.getAlias());
                    }
                    alarmData.setText(alarmText.toString());
                    alarmData.setSeverity(Integer.valueOf(alert2.getSeverity() != null ? alert2.getSeverity() : 0));
                    alarmData.setCategory(alert2.getCategoryCode());
                    if (node.getAlarms().contains(alarmData)) continue;
                    node.getAlarms().add(alarmData);
                    if (alarmData.getSeverity() <= node.getChildrenSeverity()) continue;
                    node.setChildrenSeverity(alarmData.getSeverity());
                }
            }
        }
    }

    public RequestResponse deleteNodePositionsByViewModeAndLocation(String viewMode, String location) {
        RequestResponse response = new RequestResponse();
        if ("all".equals(location)) {
            location = viewMode;
        }
        try {
            logger.info("Deleting node positions for viewMode: {}, location: {}", (Object)viewMode, (Object)location);
            List allPositions = (List)this.nodePositionRepository.findAll();
            ArrayList<NodePosition> positionsToDelete = new ArrayList<NodePosition>();
            String prefix = viewMode + "." + location + ".";
            for (NodePosition position : allPositions) {
                if (position.getId() == null || !position.getId().startsWith(prefix)) continue;
                positionsToDelete.add(position);
            }
            if (!positionsToDelete.isEmpty()) {
                this.nodePositionRepository.deleteAll(positionsToDelete);
                logger.info("Deleted {} node positions for viewMode: {}, location: {}", (Object)positionsToDelete.size(), (Object)viewMode, (Object)location);
                response.setStatus(0);
                response.setMessage("Node positions deleted successfully");
                response.setData((Object)positionsToDelete.size());
            } else {
                logger.info("No node positions found for viewMode: {}, location: {}", (Object)viewMode, (Object)location);
                response.setStatus(0);
                response.setMessage("No node positions found to delete");
                response.setData((Object)0);
            }
        }
        catch (Exception e) {
            logger.error("Error deleting node positions for viewMode: {}, location: {}", (Object)viewMode, (Object)location, (Object)e);
            response.setStatus(1);
            response.setMessage("Failed to delete node positions");
            response.setMessageDetail(e.getMessage());
        }
        return response;
    }

    private List<PreferenceModel.LinkViewNode> organizeNodesByParentChild(List<PreferenceModel.LinkViewNode> nodes) {
        ArrayList<PreferenceModel.LinkViewNode> organizedList = new ArrayList<PreferenceModel.LinkViewNode>();
        HashMap<String, List> childrenByParent = new HashMap<String, List>();
        ArrayList<PreferenceModel.LinkViewNode> rootNodes = new ArrayList<PreferenceModel.LinkViewNode>();
        for (PreferenceModel.LinkViewNode node : nodes) {
            if (node.getParent() == null || node.getParent().isEmpty()) {
                rootNodes.add(node);
                continue;
            }
            childrenByParent.computeIfAbsent(node.getParent(), k -> new ArrayList()).add(node);
        }
        for (PreferenceModel.LinkViewNode rootNode : rootNodes) {
            this.addNodeWithChildren(rootNode, organizedList, childrenByParent);
        }
        return organizedList;
    }

    private void addNodeWithChildren(PreferenceModel.LinkViewNode node, List<PreferenceModel.LinkViewNode> organizedList, Map<String, List<PreferenceModel.LinkViewNode>> childrenByParent) {
        organizedList.add(node);
        List<PreferenceModel.LinkViewNode> children = childrenByParent.get(node.getId());
        if (children != null) {
            for (PreferenceModel.LinkViewNode child : children) {
                this.addNodeWithChildren(child, organizedList, childrenByParent);
            }
        }
    }
}

