/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.audit;

import com.coraltele.telemetry.background.NotificationManagerProcess;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.IMSI;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.IMSIRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.AuditLog;
import com.coraltele.telemetry.db.telemetry.main.repository.AlertRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.AuditLogRepository;
import com.coraltele.telemetry.helper.Constants;
import java.time.Instant;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class AuditLogService {
    private static final Logger logger = LogManager.getLogger(AuditLogService.class);
    @Autowired
    AuditLogRepository auditLogRepository;
    @Autowired
    SCADAAssetRepository scadaAssetRepository;
    @Autowired
    IMSIRepository imsiRepository;
    @Autowired
    AlertRepository alertRepository;
    @Autowired
    NotificationManagerProcess notificationManagerProcess;

    public void logAudit(AuditLog auditLog) {
        if (Boolean.TRUE.equals(Constants.CLUSTER_AUDIT_LOG_ENABLED)) {
            Authentication authentication = SecurityContextHolder.getContext().getAuthentication();
            if (authentication != null) {
                auditLog.setChangedBy(authentication.getName());
            } else {
                auditLog.setChangedBy("N/A");
            }
            auditLog.setEpoch(Long.valueOf(Instant.now().getEpochSecond()));
            this.auditLogRepository.save((Object)auditLog);
        }
    }

    public void logSync(Object content) {
        if (StringUtils.hasText((String)Constants.CENTRAL_NMS_DOMAIN)) {
            if (content instanceof SCADAAsset) {
                this.notificationManagerProcess.syncAssetStatus((SCADAAsset)content);
            } else if (content instanceof IMSI) {
                this.notificationManagerProcess.syncIMSIStatus((IMSI)content);
            } else {
                logger.info("Parent Sync not implemented for this object type: {}", content.getClass());
            }
        }
    }
}

