/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.data.controller;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.coralnms.data.service.TelemetryDataService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/data"})
@RestController
public class TelemetryDataController {
    @Autowired
    private TelemetryDataService telemetryDataService;

    @GetMapping(value={"/node/list"})
    public ResponseEntity<RequestResponse> getAllTelephonyDeployments() {
        RequestResponse returnValue = new RequestResponse();
        if (returnValue.getStatus() == 0) {
            List deployments = this.telemetryDataService.getAllNodes();
            returnValue.setData((Object)deployments);
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/calls"})
    public ResponseEntity<RequestResponse> getCalls() {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.telemetryDataService.getCalls());
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/imsRLUCalls/{widgetCode}"})
    public ResponseEntity<RequestResponse> getIMSRLUCalls(@PathVariable(value="widgetCode") String widgetCode) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.telemetryDataService.getIMSRLUCalls(widgetCode));
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/imsRLUExternalCalls/{widgetCode}"})
    public ResponseEntity<RequestResponse> getIMSRLUExternalCalls(@PathVariable(value="widgetCode") String widgetCode) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.telemetryDataService.getIMSRLUExternalCalls(widgetCode));
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/imsRegistrations/{widgetCode}"})
    public ResponseEntity<RequestResponse> getIMSRegistrations(@PathVariable(value="widgetCode") String widgetCode) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.telemetryDataService.getIMSRegistrations(widgetCode));
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/dataRate"})
    public ResponseEntity<RequestResponse> dataRate() {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.telemetryDataService.getIMSIData());
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/ng-ap-status"})
    public ResponseEntity<RequestResponse> baseStationStatus() {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.telemetryDataService.getBaseStationData());
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/pdu-session"})
    public ResponseEntity<RequestResponse> pduSessionDetails() {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.telemetryDataService.getPduSessionDetails());
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/nf-status"})
    public ResponseEntity<RequestResponse> nFStatusDetails() {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.telemetryDataService.getNFStatusDetails());
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/mec-status"})
    public ResponseEntity<RequestResponse> mecStatusDetails() {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.telemetryDataService.getMecStatusDetails());
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/ulDataRate"})
    public ResponseEntity<RequestResponse> ulDataRate() {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.telemetryDataService.getULDataRate());
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/dlDataRate"})
    public ResponseEntity<RequestResponse> dlDataRate() {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.telemetryDataService.getDLDataRate());
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/counter/{widgetCode}"})
    public ResponseEntity<RequestResponse> getCounter(@PathVariable(value="widgetCode") String widgetCode) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.telemetryDataService.getCounter(widgetCode));
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/systemInfo/loadAverage/{widgetCode}"})
    public ResponseEntity<RequestResponse> getSystemInfoLoadAverage(@PathVariable(value="widgetCode") String widgetCode) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.telemetryDataService.getSystemInfoLoadAverage(widgetCode));
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/systemInfo/virtualMemory/{widgetCode}"})
    public ResponseEntity<RequestResponse> getSystemInfoVirtualMemory(@PathVariable(value="widgetCode") String widgetCode) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.telemetryDataService.getSystemInfoVirtualMemory(widgetCode));
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/systemInfo/realMemory/{widgetCode}"})
    public ResponseEntity<RequestResponse> getSystemInfoRealMemory(@PathVariable(value="widgetCode") String widgetCode) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.telemetryDataService.getSystemInfoRealMemory(widgetCode));
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/systemInfo/diskStorage/{widgetCode}"})
    public ResponseEntity<RequestResponse> getSystemInfoDiskStorage(@PathVariable(value="widgetCode") String widgetCode) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.telemetryDataService.getSystemInfoDiskStorage(widgetCode));
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/systemInfo/additionalInfo/{widgetCode}"})
    public ResponseEntity<RequestResponse> getSystemInfoAdditionalInfo(@PathVariable(value="widgetCode") String widgetCode) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.telemetryDataService.getSystemInfoAdditionalInfo(widgetCode));
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/commandAlerts"})
    public ResponseEntity<RequestResponse> getCommandAlerts() {
        RequestResponse returnValue = this.telemetryDataService.getCommandAlerts();
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/telephonyTree"})
    public ResponseEntity<RequestResponse> getTelephonyTree() {
        RequestResponse returnValue = this.telemetryDataService.getTelephonyTree();
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/multiSeries/sample"})
    public ResponseEntity<RequestResponse> getMultiSeries() {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.telemetryDataService.getMultiSeriesData());
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

