/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.messaging.controller;

import com.coraltele.telemetry.helper.Messaging;
import com.coraltele.telemetry.service.main.polygon.routeCoordinate.model.RouteCoordinateModel;
import com.coraltele.telemetry.service.main.polygon.routeCoordinate.service.RouteCoordinateService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.messaging.handler.annotation.MessageMapping;
import org.springframework.stereotype.Controller;

@Controller
public class WebsocketIncomingMessageController {
    private static final Logger logger = LogManager.getLogger(WebsocketIncomingMessageController.class);
    private final ExecutorService executor = Executors.newFixedThreadPool(4);
    @Autowired
    RouteCoordinateService routeCoordinateService;

    @MessageMapping(value={"/routeCoordinate/create"})
    public void receiveCoordinates(RouteCoordinateModel data) {
        this.executor.submit(() -> {
            logger.info("Received coordinates: {} from user: {}", (Object)data, (Object)data.getUserName());
            this.routeCoordinateService.createMultiData(data, "WS");
            if (this.routeCoordinateService.getMonitoredUser().equals(data.getUserName())) {
                String topic = "/app/v2/messaging/topic/routeCoordinate/live";
                Messaging.getMessagingTemplate().convertAndSend((Object)topic, (Object)data);
                logger.info("\ud83d\udce1 Forwarded to topic: {}", (Object)topic);
            }
        });
    }
}

