/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.sensor_data.service;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.Sensor;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.SensorData;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SensorDataRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SensorRepository;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.coralnms.sensor_data.model.SensorAttributeModel;
import com.coraltele.telemetry.service.coralnms.sensor_data.model.SensorDataModel;
import com.coraltele.telemetry.service.coralnms.sensor_data.model.TelemetryModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SensorDataService {
    @Autowired
    private SensorDataRepository dataRepo;
    @Autowired
    private SensorRepository sensorRepository;

    public RequestResponse getList(String provisioningId, String attributeName) {
        ArrayList<SensorDataModel> addValue = new ArrayList<SensorDataModel>();
        RequestResponse returnValue = new RequestResponse();
        Optional sensor = this.sensorRepository.findByProvisioningId(provisioningId);
        if (sensor.isPresent()) {
            List list = this.dataRepo.getSensorData(((Sensor)sensor.get()).getId(), attributeName, Integer.valueOf(30));
            for (SensorData sensorData : list) {
                SensorDataModel data = new SensorDataModel();
                data.setAttributeName(sensorData.getAttributeName());
                data.setAttributeValue(sensorData.getAttributeValue());
                data.setEventEpoch(sensorData.getEventEpoch());
                data.setReceivedEpoch(sensorData.getReceivedEpoch());
                addValue.add(data);
            }
            returnValue.setStatus(0);
            returnValue.setMessage("OK");
            returnValue.setData(addValue);
            return returnValue;
        }
        returnValue.setStatus(-1);
        returnValue.setMessage("Unable to return value");
        returnValue.setMessageDetail("Records not found");
        return returnValue;
    }

    public void saveTelemetryData(TelemetryModel data) {
        Optional sensor = this.sensorRepository.findByProvisioningId(data.getSensorKey());
        if (sensor.isPresent()) {
            for (SensorAttributeModel sensorAttribute : data.getAttributes()) {
                SensorData sensorData = new SensorData();
                sensorData.setSensor((Sensor)sensor.get());
                sensorData.setAttributeName(sensorAttribute.getAttributeName());
                sensorData.setAttributeValue(sensorAttribute.getAttributeValue());
                sensorData.setEventEpoch(data.getEventEpoch());
                sensorData.setReceivedEpoch(Long.valueOf(System.currentTimeMillis()));
                this.dataRepo.save((Object)sensorData);
            }
        }
    }
}

