/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.service;

import com.coraltele.telemetry.db.coralapps.entity.Agent;
import com.coraltele.telemetry.db.coralapps.entity.Member;
import com.coraltele.telemetry.db.coralapps.repository.AgentRepository;
import com.coraltele.telemetry.db.coralapps.repository.MemberRepository;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.MemberModel;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MemberService {
    private static final Logger logger = LogManager.getLogger(MemberService.class);
    @Autowired
    private MemberRepository memberRepository;
    @Autowired
    private AgentRepository agentRepository;

    public RequestResponse getMemberData() {
        RequestResponse returnValue = new RequestResponse();
        try {
            ArrayList<MemberModel> data = new ArrayList<MemberModel>();
            List memberList = this.memberRepository.findAll();
            if (!memberList.isEmpty()) {
                for (Member memberData : memberList) {
                    MemberModel member = new MemberModel();
                    Optional agentData = this.agentRepository.findByName(memberData.getServingAgent());
                    if (agentData.isPresent()) {
                        member.setAgentName(((Agent)agentData.get()).getAgentFullName());
                    } else {
                        member.setAgentName(memberData.getServingAgent());
                    }
                    member.setAgentId(memberData.getServingAgent());
                    member.setCidName(memberData.getCidName());
                    member.setCidNumber(memberData.getCidNumber());
                    member.setInstanceId(memberData.getInstanceId());
                    member.setJoinedEpoch(memberData.getJoinedEpoch());
                    member.setQueue(memberData.getQueue());
                    member.setSessionUuid(memberData.getSessionUuid());
                    member.setState(memberData.getState());
                    member.setSystem(memberData.getSystem());
                    member.setUuid(memberData.getUuid());
                    data.add(member);
                }
                returnValue.setStatus(0);
                returnValue.setMessage("OK");
                returnValue.setMessageDetail("Member Data List is ");
                returnValue.setData(data);
            } else {
                returnValue.setStatus(0);
                returnValue.setMessage("OK");
                returnValue.setMessageDetail("Member Data is Empty.");
            }
        }
        catch (Exception e) {
            logger.info("error is {}", (Object)e.getMessage());
            returnValue.setStatus(-1);
            returnValue.setMessage("NOT OK");
            returnValue.setMessageDetail("Something Went Wrong");
        }
        return returnValue;
    }
}

