/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.service;

import com.coraltele.telemetry.component.service.EAMSServiceInterface;
import com.coraltele.telemetry.db.telemetry.main.entity.EAMSEntity;
import com.coraltele.telemetry.db.telemetry.main.repository.EAMSRepository;
import com.coraltele.telemetry.helper.RequestResponse;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class EAMSService
implements EAMSServiceInterface {
    private static final Logger logger = LogManager.getLogger(EAMSService.class);
    private final EAMSRepository eamsRepository;

    public EAMSService(EAMSRepository eamsRepository) {
        this.eamsRepository = eamsRepository;
    }

    @Transactional(transactionManager="telemetryTransactionManager")
    public RequestResponse setSystemInfo(String macAddress, String systemInfoJson) {
        RequestResponse response = new RequestResponse();
        try {
            EAMSEntity entity;
            Optional existingOpt = this.eamsRepository.findByMacAddress(macAddress);
            if (existingOpt.isPresent()) {
                entity = (EAMSEntity)existingOpt.get();
                entity.setSystemInfoJson(systemInfoJson);
                logger.info("Updating system info for macAddress={}", (Object)macAddress);
            } else {
                entity = new EAMSEntity();
                entity.setMacAddress(macAddress);
                entity.setSystemInfoJson(systemInfoJson);
                logger.info("Creating system info for macAddress={}", (Object)macAddress);
            }
            this.eamsRepository.save((Object)entity);
            response.setStatus(0);
            response.setMessage("SUCCESS");
            response.setMessageDetail("System info created or updated successfully.");
            return response;
        }
        catch (Exception e) {
            logger.error("Exception in setSystemInfo for macAddress={}", (Object)macAddress, (Object)e);
            response.setStatus(-1);
            response.setMessage("Error saving system info.");
            response.setMessageDetail(e.getMessage());
            return response;
        }
    }

    public RequestResponse getAllSystemInfo() {
        RequestResponse response = new RequestResponse();
        try {
            List entities = this.eamsRepository.findAll();
            logger.info("System info retrieved successfully. Total records={}", (Object)entities.size());
            response.setStatus(0);
            response.setData((Object)entities);
            response.setMessage("SUCCESS");
            response.setMessageDetail("System info retrieved successfully.");
            return response;
        }
        catch (Exception e) {
            logger.error("Exception in getAllSystemInfo", (Throwable)e);
            response.setStatus(-1);
            response.setMessage("Error retrieving system info.");
            response.setMessageDetail(e.getMessage());
            return response;
        }
    }

    public RequestResponse getSystemInfo(String macAddress) {
        RequestResponse response = new RequestResponse();
        try {
            Optional entity = this.eamsRepository.findByMacAddress(macAddress);
            if (entity.isPresent()) {
                logger.info("System info retrieved for macAddress={}", (Object)macAddress);
                response.setStatus(0);
                response.setData(entity.get());
                response.setMessage("SUCCESS");
                response.setMessageDetail("System info retrieved successfully.");
                return response;
            }
            logger.warn("No system info found for macAddress={}", (Object)macAddress);
            response.setStatus(-1);
            response.setMessage("System info not found for the given MAC address.");
            return response;
        }
        catch (Exception e) {
            logger.error("Exception in getSystemInfo for macAddress={}", (Object)macAddress, (Object)e);
            response.setStatus(-1);
            response.setMessage("Error retrieving system info.");
            response.setMessageDetail(e.getMessage());
            return response;
        }
    }

    @Transactional(transactionManager="telemetryTransactionManager")
    public RequestResponse setDeviceInfo(String macAddress, String deviceInfoJson) {
        RequestResponse response = new RequestResponse();
        try {
            Optional existingOpt = this.eamsRepository.findByMacAddress(macAddress);
            if (existingOpt.isPresent()) {
                EAMSEntity entity = (EAMSEntity)existingOpt.get();
                entity.setHardwareComponentJson(deviceInfoJson);
                this.eamsRepository.save((Object)entity);
                logger.info("Updating device info for macAddress={}", (Object)macAddress);
                response.setStatus(0);
                response.setMessage("SUCCESS");
                response.setMessageDetail("Device info updated successfully.");
                return response;
            }
            logger.warn("No existing record found for macAddress={}", (Object)macAddress);
            response.setStatus(-1);
            response.setMessage("No existing record found for the given MAC address.");
            return response;
        }
        catch (Exception e) {
            logger.error("Exception in setDeviceInfo for macAddress={}", (Object)macAddress, (Object)e);
            response.setStatus(-1);
            response.setMessage("Error updating device info.");
            response.setMessageDetail(e.getMessage());
            return response;
        }
    }

    @Transactional(transactionManager="telemetryTransactionManager")
    public RequestResponse deleteDeviceInfo(String macAddress) {
        RequestResponse response = new RequestResponse();
        try {
            Optional existingOpt = this.eamsRepository.findByMacAddress(macAddress);
            if (!existingOpt.isPresent()) {
                logger.warn("No existing record found for macAddress={}", (Object)macAddress);
                response.setStatus(-1);
                response.setMessage("No existing record found for the given MAC address.");
                return response;
            }
            int deletedCount = this.eamsRepository.deleteByMacAddress(macAddress);
            if (deletedCount > 0) {
                logger.info("Deleted device info for macAddress={}", (Object)macAddress);
                response.setStatus(0);
                response.setMessage("SUCCESS");
                response.setMessageDetail("Device info deleted successfully.");
            } else {
                logger.warn("Delete executed but no rows affected for macAddress={}", (Object)macAddress);
                response.setStatus(-1);
                response.setMessage("Delete failed. No rows affected.");
            }
            return response;
        }
        catch (Exception e) {
            logger.error("Exception in deleteDeviceInfo for macAddress={}", (Object)macAddress, (Object)e);
            response.setStatus(-1);
            response.setMessage("Error deleting device info.");
            response.setMessageDetail(e.getMessage());
            return response;
        }
    }
}

