/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.controller;

import com.coraltele.telemetry.component.service.EAMSService;
import com.coraltele.telemetry.helper.RequestResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/eams"})
public class EAMSController {
    private static final Logger logger = LogManager.getLogger(EAMSController.class);
    private final EAMSService eamsService;
    private final ObjectMapper objectMapper;

    public EAMSController(EAMSService eamsService, ObjectMapper objectMapper) {
        this.eamsService = eamsService;
        this.objectMapper = objectMapper;
    }

    @GetMapping(value={"/system-info/{macAddress}"})
    public ResponseEntity<RequestResponse> getSystemInfo(@PathVariable(value="macAddress") String macAddress) {
        RequestResponse response = new RequestResponse();
        logger.info("GET /system-info called with macAddress={}", (Object)macAddress);
        try {
            if (macAddress == null || macAddress.trim().isEmpty()) {
                logger.warn("GET /system-info failed: macAddress is empty");
                response.setStatus(-1);
                response.setMessage("MAC Address is required.");
                return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)response);
            }
            response = this.eamsService.getSystemInfo(macAddress);
            if (response.getStatus() == 0) {
                logger.info("System info fetched successfully for macAddress={}", (Object)macAddress);
                response.setMessage("SUCCESS");
                response.setMessageDetail("System info fetched successfully.");
                return ResponseEntity.ok((Object)response);
            }
            logger.warn("System info not found for macAddress={}", (Object)macAddress);
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)response);
        }
        catch (Exception e) {
            logger.error("Exception while fetching system info for macAddress={}", (Object)macAddress, (Object)e);
            response.setStatus(-1);
            response.setMessage("Failed to fetch system info.");
            response.setMessageDetail(e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)response);
        }
    }

    @GetMapping(value={"/system-info"})
    public ResponseEntity<RequestResponse> getAllSystemInfo() {
        RequestResponse response = new RequestResponse();
        logger.info("GET /system-info called {}");
        try {
            response = this.eamsService.getAllSystemInfo();
            if (response.getStatus() == 0) {
                logger.info("All system info fetched successfully {}");
                response.setMessage("SUCCESS");
                response.setMessageDetail("All system info fetched successfully.");
                return ResponseEntity.ok((Object)response);
            }
            logger.warn("All system info not found {}");
            return ResponseEntity.status((HttpStatus)HttpStatus.NOT_FOUND).body((Object)response);
        }
        catch (Exception e) {
            logger.error("Exception while fetching all system info {}", (Throwable)e);
            response.setStatus(-1);
            response.setMessage("Failed to fetch all system info.");
            response.setMessageDetail(e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)response);
        }
    }

    @PostMapping(value={"/device-info/{macAddress}"})
    public ResponseEntity<RequestResponse> setDeviceInfo(@PathVariable(value="macAddress") String macAddress, @RequestBody Map<String, String> deviceInfo) {
        RequestResponse response = new RequestResponse();
        logger.info("POST /device-info called with macAddress={}", (Object)macAddress);
        try {
            if (macAddress == null || macAddress.trim().isEmpty()) {
                logger.warn("POST /device-info failed: macAddress is empty");
                response.setStatus(-1);
                response.setMessage("MAC Address is required.");
                return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)response);
            }
            String deviceInfoJson = this.objectMapper.writeValueAsString(deviceInfo);
            response = this.eamsService.setDeviceInfo(macAddress, deviceInfoJson);
            if (response.getStatus() == 0) {
                logger.info("Device info saved successfully for macAddress={}", (Object)macAddress);
                response.setMessage("SUCCESS");
                response.setMessageDetail("Device info created or updated successfully.");
                return ResponseEntity.ok((Object)response);
            }
            logger.warn("Failed to save device info for macAddress={}", (Object)macAddress);
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)response);
        }
        catch (Exception e) {
            logger.error("Exception while saving device info for macAddress={}", (Object)macAddress, (Object)e);
            response.setStatus(-1);
            response.setMessage("Failed to create or update device info.");
            response.setMessageDetail(e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)response);
        }
    }

    @DeleteMapping(value={"/system-info/{macAddress}"})
    public ResponseEntity<RequestResponse> deleteDeviceInfo(@PathVariable(value="macAddress") String macAddress) {
        RequestResponse response = new RequestResponse();
        logger.info("DELETE /device-info called with macAddress={}", (Object)macAddress);
        try {
            if (macAddress == null || macAddress.trim().isEmpty()) {
                logger.warn("DELETE /device-info failed: macAddress is empty");
                response.setStatus(-1);
                response.setMessage("MAC Address is required.");
                return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)response);
            }
            response = this.eamsService.deleteDeviceInfo(macAddress);
            if (response.getStatus() == 0) {
                logger.info("Device info deleted successfully for macAddress={}", (Object)macAddress);
                response.setMessage("SUCCESS");
                response.setMessageDetail("Device info deleted successfully.");
                return ResponseEntity.ok((Object)response);
            }
            logger.warn("Failed to delete device info for macAddress={}", (Object)macAddress);
            return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)response);
        }
        catch (Exception e) {
            logger.error("Exception while deleting device info for macAddress={}", (Object)macAddress, (Object)e);
            response.setStatus(-1);
            response.setMessage("Failed to delete device info.");
            response.setMessageDetail(e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)response);
        }
    }
}

