/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.controller;

import com.coraltele.telemetry.component.service.EAMSService;
import com.coraltele.telemetry.helper.RequestResponse;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/app/v2/eams"})
public class EAMSClientController {
    private static final Logger logger = LogManager.getLogger(EAMSClientController.class);
    private final EAMSService eamsService;
    private final ObjectMapper objectMapper;

    public EAMSClientController(EAMSService eamsService, ObjectMapper objectMapper) {
        this.eamsService = eamsService;
        this.objectMapper = objectMapper;
    }

    @PostMapping(value={"/system-info/{macAddress}"})
    public ResponseEntity<RequestResponse> setSystemInfo(@PathVariable(value="macAddress") String macAddress, @RequestBody Map<String, Object> systemInfo) {
        RequestResponse response = new RequestResponse();
        logger.info("POST /system-info called with macAddress={}", (Object)macAddress);
        try {
            if (macAddress == null || macAddress.trim().isEmpty()) {
                logger.warn("POST /system-info failed: macAddress is empty");
                response.setStatus(-1);
                response.setMessage("MAC Address is required.");
                return ResponseEntity.status((HttpStatus)HttpStatus.BAD_REQUEST).body((Object)response);
            }
            String systemInfoJson = this.objectMapper.writeValueAsString(systemInfo);
            response = this.eamsService.setSystemInfo(macAddress, systemInfoJson);
            HttpStatus status = response.getStatus() == 0 ? HttpStatus.OK : HttpStatus.BAD_REQUEST;
            return ResponseEntity.status((HttpStatus)status).body((Object)response);
        }
        catch (Exception e) {
            logger.error("Exception while saving system info for macAddress={}", (Object)macAddress, (Object)e);
            response.setStatus(-1);
            response.setMessage("Failed to create or update system info.");
            response.setMessageDetail(e.getMessage());
            return ResponseEntity.status((HttpStatus)HttpStatus.INTERNAL_SERVER_ERROR).body((Object)response);
        }
    }
}

