/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.db.telemetry.coralnms.entity.IMSI;
import com.coraltele.telemetry.db.telemetry.coralnms.entity.SCADAAsset;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.IMSIRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.SCADAAssetRepository;
import com.coraltele.telemetry.db.telemetry.main.entity.Alert;
import com.coraltele.telemetry.db.telemetry.main.entity.CategoryService;
import com.coraltele.telemetry.db.telemetry.main.entity.Severity;
import com.coraltele.telemetry.db.telemetry.main.repository.AlertRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.CategoryServiceRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.SeverityRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.EscalationHelper;
import com.coraltele.telemetry.model.AlertWithAssetDataModel;
import com.coraltele.telemetry.model.EnqueueTask;
import com.coraltele.telemetry.model.EscalationModel;
import com.coraltele.telemetry.model.ImsiWithAssetDataModel;
import com.coraltele.telemetry.model.discovery.ServiceStatus;
import com.coraltele.telemetry.service.main.service.TaskService;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.stream.Collectors;
import javax.annotation.PostConstruct;
import javax.mail.internet.MimeMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.mail.javamail.JavaMailSenderImpl;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.util.StringUtils;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class NotificationManagerProcess {
    private static final Integer MAX_THREADS = 1;
    private static final Integer MAX_TASKS = 10;
    private ConcurrentLinkedQueue<EnqueueTask> taskQueue = new ConcurrentLinkedQueue();
    private final Lock lock = new ReentrantLock();
    private final Condition newTaskAvailable = this.lock.newCondition();
    private volatile boolean running = true;
    ExecutorService threadPool = Executors.newFixedThreadPool(MAX_THREADS);
    ExecutorService taskPool = Executors.newFixedThreadPool(MAX_TASKS);
    private static final Logger logger = LogManager.getLogger(NotificationManagerProcess.class);
    private String emailTemplate = "";
    private String smsTemplate = "";
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    SeverityRepository severityRepository;
    @Autowired
    TaskService taskService;
    @Autowired
    SCADAAssetRepository scadaAssetRepository;
    @Autowired
    IMSIRepository imsiRepository;
    @Autowired
    AlertRepository alertRepository;
    @Autowired
    CategoryServiceRepository categoryServiceRepository;
    String scadaSyncUrl = String.format("%s://%s/telemetry/api/v2/sync/scada", Constants.CENTRAL_NMS_PROTOCOL, Constants.CENTRAL_NMS_DOMAIN);
    String imsiSyncUrl = String.format("%s://%s/telemetry/api/v2/sync/imsi", Constants.CENTRAL_NMS_PROTOCOL, Constants.CENTRAL_NMS_DOMAIN);
    ConcurrentHashMap<String, EscalationHelper> escalationMatrix = new ConcurrentHashMap();

    @PostConstruct
    public void init() {
        logger.info("Notification Manager Process started");
        this.loadTemplates();
        logger.info("Templates Loaded");
        this.startHealthCheck();
        this.loadEscalationData();
    }

    @Scheduled(fixedRate=5000L)
    public void startHealthCheck() {
        logger.info("Schedule event triggered");
        logger.info("Maximum Threads : {}, Active Thread {} ", (Object)MAX_THREADS, (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount());
        Integer threadsStarted = 0;
        while (((ThreadPoolExecutor)this.threadPool).getActiveCount() < MAX_THREADS) {
            Integer n = threadsStarted;
            Integer n2 = threadsStarted = Integer.valueOf(threadsStarted + 1);
            logger.info("Starting Notification Manager Process.");
            this.threadPool.execute(() -> this.executeQueuedTasks());
        }
        logger.info("{} Threads started", (Object)threadsStarted);
    }

    @Scheduled(fixedRate=10000L)
    public void checkPendingSync() {
        logger.info("Checking for pending sync");
        if (Constants.CENTRAL_NMS_DOMAIN.isEmpty()) {
            return;
        }
        logger.info("Listing pending assets for sync");
        try {
            this.scadaAssetRepository.findByPendingForSyncIsNullOrPendingForSync(Integer.valueOf(1)).forEach(asset -> {
                logger.info("Initiating sync for asset uuid: {}", (Object)asset.getUuid());
                this.syncAssetStatus(asset);
            });
        }
        catch (Exception e) {
            logger.error("Error checking pending sync for Assets", (Throwable)e);
        }
        logger.info("Listing pending imsi for sync");
        try {
            this.imsiRepository.findByPendingForSyncIsNullOrPendingForSync(Integer.valueOf(1)).forEach(arg_0 -> this.syncIMSIStatus(arg_0));
        }
        catch (Exception e) {
            logger.error("Error checking pending sync for IMSI", (Throwable)e);
        }
        logger.info("Pending Sync Check Completed");
    }

    @Scheduled(fixedRate=300000L)
    public void checkAlertEscalation() {
        this.enqueueTask(new EnqueueTask("Alert Escalation", () -> {
            logger.info("Checking for alert escalation");
            this.escalateAlerts();
        }));
    }

    private void escalateAlerts() {
        List activeAlerts = this.alertRepository.findByStatus(false);
        Long currentTime = Instant.now().getEpochSecond();
        logger.info("Checking for active alerts for escalation");
        for (Alert alert : activeAlerts) {
            String escalationKey = alert.getServiceCode() + "-" + alert.getCategoryCode();
            EscalationHelper escalationHelper = (EscalationHelper)this.escalationMatrix.getOrDefault(escalationKey, this.escalationMatrix.get("DEFAULT"));
            if (escalationHelper != null) {
                EscalationModel escalationLevel = escalationHelper.getEscalation(currentTime, alert);
                if (escalationLevel == null) continue;
                this.alertRepository.updateEscalationLevel(alert.getId(), escalationLevel.getEscalationLevel(), currentTime);
                String assetName = "";
                Optional assetDetails = this.scadaAssetRepository.findById(alert.getAssetId());
                assetName = assetDetails.isPresent() ? (StringUtils.hasText((String)((SCADAAsset)assetDetails.get()).getNodeName()) ? ((SCADAAsset)assetDetails.get()).getNodeName() : ((SCADAAsset)assetDetails.get()).getIpAddress()) : alert.getIpAddress();
                this.sendEscalation(alert, escalationLevel, assetName);
                continue;
            }
            logger.warn("No escalation data found for key: {} alert : {}", (Object)escalationKey, (Object)alert.getUuid());
        }
    }

    private void sendEscalation(Alert alert, EscalationModel escalationLevel, String assetName) {
        try {
            logger.info("Alert UUID : {} Escalation Level  : {} ", (Object)alert.getUuid(), (Object)escalationLevel.getEscalationLevel());
            if (escalationLevel.getEscalationEmail() != null) {
                String alertStatus = alert.isStatus() ? "UP" : "Down";
                String severityName = "Escalation-" + escalationLevel.getEscalationLevel();
                String alertGeneratedOn = Instant.ofEpochSecond(alert.getAlertGeneratedOn()).atZone(ZoneId.systemDefault()).toLocalDateTime().toString();
                if (escalationLevel.getEscalationSMS() != null && !escalationLevel.getEscalationSMS().isEmpty()) {
                    logger.info("Sending SMS Alert : {} ", (Object)escalationLevel.getEscalationSMS());
                    this.enqueueTask(new EnqueueTask(alert.getAssetId().toString(), () -> this.sendSMS(assetName, alertStatus, alertGeneratedOn, alert.getServiceCode(), alert.getCategoryCode(), alert.getIpAddress(), severityName, escalationLevel.getEscalationSMS())));
                }
                if (escalationLevel.getEscalationEmail() != null && !escalationLevel.getEscalationEmail().isEmpty()) {
                    logger.info("Sending Email Alert : {} ", (Object)escalationLevel.getEscalationEmail());
                    this.enqueueTask(new EnqueueTask(alert.getAssetId().toString(), () -> this.sendEmail(assetName, alertStatus, alertGeneratedOn, alert.getServiceCode(), alert.getCategoryCode(), alert.getIpAddress(), severityName, escalationLevel.getEscalationEmail(), escalationLevel.getEscalationEmailCC())));
                }
            }
        }
        catch (Exception e) {
            logger.error("Error sending escalation alert UUID {} : Escalation Level : {}", (Object)alert.getUuid(), (Object)escalationLevel.getEscalationLevel(), (Object)e);
        }
    }

    private boolean sendScadaWithAlertDataToMasterServer(AlertWithAssetDataModel dataToSend) {
        try {
            HttpHeaders headers = new HttpHeaders();
            if (Constants.CENTRAL_NMS_API_KEY.isEmpty()) {
                headers.set("Authorization", "Cluster " + Constants.CLUSTER_KEY);
            } else {
                headers.set("Authorization", "Opaque " + Constants.CENTRAL_NMS_API_KEY);
            }
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            HttpEntity requestEntity = new HttpEntity((Object)dataToSend, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(this.scadaSyncUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                return true;
            }
            logger.warn("Failed to send data. HTTP Status: {} | Response: {}", (Object)response.getStatusCode(), response.getBody());
            return false;
        }
        catch (RestClientException ex) {
            logger.error("HTTP request failed while sending data to master server: {}", (Object)ex.getMessage());
            return false;
        }
    }

    private boolean sendImsiWithScadaToMasterServer(ImsiWithAssetDataModel dataToSend) {
        try {
            HttpHeaders headers = new HttpHeaders();
            if (Constants.CENTRAL_NMS_API_KEY.isEmpty()) {
                headers.set("Authorization", "Cluster " + Constants.CLUSTER_KEY);
            } else {
                headers.set("Authorization", "Opaque " + Constants.CENTRAL_NMS_API_KEY);
            }
            headers.setContentType(MediaType.APPLICATION_JSON);
            headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
            HttpEntity requestEntity = new HttpEntity((Object)dataToSend, (MultiValueMap)headers);
            ResponseEntity response = this.restTemplate.exchange(this.imsiSyncUrl, HttpMethod.POST, requestEntity, String.class, new Object[0]);
            if (response.getStatusCode().is2xxSuccessful()) {
                return true;
            }
            logger.warn("Failed to send data. HTTP Status: {} | Response: {}", (Object)response.getStatusCode(), response.getBody());
            return false;
        }
        catch (RestClientException ex) {
            logger.error("HTTP request failed while sending data to master server: {}", (Object)ex.getMessage());
            return false;
        }
    }

    private void executeQueuedTasks() {
        this.lock.lock();
        while (this.running) {
            logger.info("Waiting for task");
            this.lock.lock();
            try {
                while (this.taskQueue.isEmpty()) {
                    this.newTaskAvailable.await();
                }
                Boolean hasTask = true;
                while (Boolean.TRUE.equals(hasTask)) {
                    EnqueueTask task = (EnqueueTask)this.taskQueue.poll();
                    hasTask = task != null;
                    if (!Boolean.TRUE.equals(hasTask)) continue;
                    logger.info("Task found, executing");
                    this.taskPool.submit(() -> this.executeTask(task));
                }
            }
            catch (InterruptedException e) {
                logger.error("Conference Service Thread Interrupted", (Throwable)e);
                this.lock.unlock();
                Thread.currentThread().interrupt();
                break;
            }
            finally {
                this.lock.unlock();
            }
        }
    }

    public void alertUpdate(Long assetId, String assetName, String status, String alertGeneratedOn, String serviceCode, String category, String ipAddress, String severityName) {
        logger.info("Alert Update: {} {} {} {} {} {} {}", (Object)assetId, (Object)assetName, (Object)status, (Object)alertGeneratedOn, (Object)serviceCode, (Object)category, (Object)ipAddress);
        if (StringUtils.hasText((String)Constants.EMAIL_SERVER_NAME)) {
            logger.info("Queue Email Alert : {} {} {} {} {} {} {}", (Object)assetId, (Object)assetName, (Object)status, (Object)alertGeneratedOn, (Object)serviceCode, (Object)category, (Object)ipAddress);
            this.enqueueTask(new EnqueueTask(assetId.toString(), () -> this.sendEmail(assetName, status, alertGeneratedOn, serviceCode, category, ipAddress, severityName, Constants.EMAIL_SERVER_DEFAULT_TO, Constants.EMAIL_SERVER_DEFAULT_CC)));
        } else {
            logger.info("Email Server not configured, skipping email alert");
        }
        if (StringUtils.hasText((String)Constants.SMS_SERVER_URL)) {
            logger.info("Queue SMS Alert : {} {} {} {} {} {}", (Object)assetId, (Object)status, (Object)alertGeneratedOn, (Object)serviceCode, (Object)category, (Object)ipAddress);
            this.enqueueTask(new EnqueueTask(assetId.toString(), () -> this.sendSMS(assetName, status, alertGeneratedOn, serviceCode, category, ipAddress, severityName, Constants.SMS_SERVER_DEFAULT_TO)));
        } else {
            logger.info("SMS Server not configured, skipping email alert");
        }
        if (Boolean.TRUE.equals(Constants.TASK_ALERT)) {
            logger.info("TASK CREATED : {} {} {} {} {} {}", (Object)assetId, (Object)status, (Object)alertGeneratedOn, (Object)serviceCode, (Object)category, (Object)ipAddress);
            this.enqueueTask(new EnqueueTask(assetId.toString(), () -> {
                logger.info("Executing Task Creation : {} {} {} {} {} {}", (Object)assetId, (Object)status, (Object)alertGeneratedOn, (Object)serviceCode, (Object)category, (Object)ipAddress);
                this.taskService.createTask(assetId, status, serviceCode, category, ipAddress, severityName);
            }));
        } else {
            logger.info("Task set-up not configured, skipping task alert");
        }
    }

    public void syncAssetStatus(SCADAAsset asset) {
        logger.info("Sync Asset Status: {} {} {}", (Object)asset.getId(), (Object)asset.getIpAddress(), (Object)asset.getNodeName());
        this.enqueueTask(new EnqueueTask(asset.getId().toString(), () -> {
            List alerts = this.alertRepository.findByAssetId(asset.getId());
            asset.setLocation(Constants.CENTRAL_NMS_THIS_LOCATION);
            AlertWithAssetDataModel dataToSend = new AlertWithAssetDataModel();
            dataToSend.setScadaAsset(asset);
            dataToSend.setAlertData(alerts);
            if (this.sendScadaWithAlertDataToMasterServer(dataToSend)) {
                logger.info("Successfully synced Asset: {} | IP: {}", (Object)asset.getId(), (Object)asset.getIpAddress());
                this.scadaAssetRepository.updatePendingForSyncById(asset.getId(), Integer.valueOf(0));
            } else {
                logger.info("Unable to sync Asset: {} | IP: {}", (Object)asset.getId(), (Object)asset.getIpAddress());
                this.scadaAssetRepository.updatePendingForSyncById(asset.getId(), Integer.valueOf(1));
            }
        }));
    }

    public void syncIMSIStatus(IMSI imsi) {
        logger.info("Sync IMSI Status: {} ", (Object)imsi.getImsiNumber());
        this.enqueueTask(new EnqueueTask(imsi.getImsiNumber(), () -> {
            Optional assetDetails = this.scadaAssetRepository.findById(imsi.getAsset().getId());
            if (assetDetails.isPresent()) {
                ImsiWithAssetDataModel dataToSend = new ImsiWithAssetDataModel();
                dataToSend.setImsiData(imsi);
                dataToSend.setScadaAsset((SCADAAsset)assetDetails.get());
                if (this.sendImsiWithScadaToMasterServer(dataToSend)) {
                    logger.info("IMSI synced successfully: {}", (Object)imsi.getImsiNumber());
                    this.imsiRepository.updatePendingForSyncById(imsi.getImsiNumber(), Integer.valueOf(0));
                } else {
                    logger.warn("Failed to sync IMSI: {}", (Object)imsi.getImsiNumber());
                    this.imsiRepository.updatePendingForSyncById(imsi.getImsiNumber(), Integer.valueOf(1));
                }
            } else {
                logger.warn("No SCADA Asset found for IMSI: {} | Skipping sync", (Object)imsi.getImsiNumber());
                this.imsiRepository.updatePendingForSyncById(imsi.getImsiNumber(), Integer.valueOf(1));
            }
        }));
    }

    private void sendEmail(String assetName, String status, String alertGeneratedOn, String serviceCode, String category, String ipAddress, String severityName, List<String> emailTo, List<String> emailCC) {
        logger.info("Sending email alert: {} {} {} {} {} {}", (Object)status, (Object)alertGeneratedOn, (Object)serviceCode, (Object)category, (Object)ipAddress, (Object)severityName);
        String smtpHost = Constants.EMAIL_SERVER_NAME;
        int smtpPort = Constants.EMAIL_SERVER_PORT;
        String smtpUser = Constants.EMAIL_SERVER_USERNAME;
        String smtpPass = Constants.EMAIL_SERVER_PASSWORD;
        JavaMailSenderImpl mailSender = new JavaMailSenderImpl();
        mailSender.setHost(smtpHost);
        mailSender.setPort(smtpPort);
        mailSender.setUsername(smtpUser);
        mailSender.setPassword(smtpPass);
        mailSender.setProtocol("smtps");
        mailSender.setDefaultEncoding("UTF-8");
        mailSender.getJavaMailProperties().put("mail.info", "true");
        Properties props = mailSender.getJavaMailProperties();
        props.put("mail.smtp.auth", "true");
        props.put("mail.smtp.ssl.enable", "true");
        HashMap<String, String> values = new HashMap<String, String>();
        values.put("assetName", assetName);
        values.put("status", status);
        values.put("statusText", status.equalsIgnoreCase("UP") ? "Service is UP" : "Service is DOWN");
        values.put("circleColor", status.equalsIgnoreCase("UP") ? "#28a745" : "#dc3545");
        values.put("alertGeneratedOn", alertGeneratedOn);
        values.put("serviceCode", serviceCode);
        values.put("category", category);
        values.put("ipAddress", ipAddress);
        values.put("severityName", severityName);
        String htmlBody = this.generateContent(this.emailTemplate, values);
        String subject = String.format("NMS Alert: [%s] - Status Change Notification", serviceCode);
        try {
            MimeMessage message = mailSender.createMimeMessage();
            MimeMessageHelper helper = new MimeMessageHelper(message, true, "UTF-8");
            helper.setFrom(smtpUser);
            helper.setTo(emailTo.toArray(new String[0]));
            if (emailCC != null && !emailCC.isEmpty()) {
                helper.setCc(emailCC.toArray(new String[0]));
            }
            helper.setSubject(subject);
            helper.setText(htmlBody, true);
            logger.info("About to send email to {}", (Object)Constants.EMAIL_SERVER_DEFAULT_TO);
            mailSender.send(message);
            logger.info("Email sent successfully to {}", (Object)Constants.EMAIL_SERVER_DEFAULT_TO);
        }
        catch (Exception e) {
            logger.error("Error sending email", (Throwable)e);
        }
    }

    private void sendSMS(String assetName, String status, String alertGeneratedOn, String serviceCode, String category, String ipAddress, String severityName, List<String> smsTo) {
        try {
            HashMap<String, String> values = new HashMap<String, String>();
            values.put("assetName", assetName);
            values.put("status", status);
            values.put("statusText", status.equalsIgnoreCase("UP") ? "Service is UP" : "Service is DOWN");
            values.put("circleColor", status.equalsIgnoreCase("UP") ? "#28a745" : "#dc3545");
            values.put("alertGeneratedOn", alertGeneratedOn);
            values.put("serviceCode", serviceCode);
            values.put("category", category);
            values.put("ipAddress", ipAddress);
            values.put("severityName", severityName);
            String smsBody = this.generateContent(this.smsTemplate, values);
            String encodedMessage = "";
            encodedMessage = Constants.SEND_SMS_BY_CASQ == false ? URLEncoder.encode(smsBody, "UTF-8").replace("+", "%20").replace("%3A", ":").replace("%40", "@").replace("%2C", ",") : URLEncoder.encode(smsBody, "UTF-8");
            HashMap<String, String> urlValues = new HashMap<String, String>();
            urlValues.put("userName", Constants.SMS_SERVER_USERNAME);
            urlValues.put("password", Constants.SMS_SERVER_PASSWORD);
            urlValues.put("smsSender", Constants.SMS_SENDER);
            urlValues.put("smsBody", encodedMessage);
            urlValues.put("smsTemplateId", Constants.SMS_TEMPLATE_ID);
            String urlStr = this.generateContent(Constants.SMS_SERVER_URL, urlValues);
            for (String number : smsTo) {
                if (number == null || number.isEmpty()) continue;
                String urlWithNumber = urlStr.replace("{{sendTo}}", number);
                logger.info("Sending SMS alert {} : {}", (Object)number, (Object)encodedMessage);
                logger.info("Sending SMS alert URL : {}", (Object)urlWithNumber);
                if (!Constants.SEND_SMS_BY_SERVICE.booleanValue()) {
                    String inputLine;
                    URL url = new URL(urlWithNumber);
                    HttpURLConnection conn = (HttpURLConnection)url.openConnection();
                    conn.setRequestMethod("GET");
                    conn.setRequestProperty("User-Agent", "Mozilla/5.0");
                    conn.setRequestProperty("Accept-Language", "en-US,en;q=0.9");
                    conn.setRequestProperty("Connection", "keep-alive");
                    conn.setConnectTimeout(5000);
                    conn.setReadTimeout(5000);
                    int responseCode = conn.getResponseCode();
                    logger.info("Response Code: {}", (Object)responseCode);
                    BufferedReader in = new BufferedReader(new InputStreamReader(conn.getInputStream()));
                    StringBuilder response = new StringBuilder();
                    while ((inputLine = in.readLine()) != null) {
                        response.append(inputLine);
                    }
                    in.close();
                    logger.info("SMS Server Response Body: {}", (Object)response);
                    continue;
                }
                RestTemplate restTemplate = new RestTemplate();
                HttpHeaders headers = new HttpHeaders();
                headers.set("Authorization", "Cluster " + Constants.CLUSTER_KEY);
                headers.set("X-ORIG-IP", "127.0.0.1");
                headers.setAccept(Collections.singletonList(MediaType.APPLICATION_JSON));
                HttpEntity entity = new HttpEntity((MultiValueMap)headers);
                ResponseEntity response = restTemplate.exchange(urlWithNumber, HttpMethod.GET, entity, String.class, new Object[0]);
                logger.info("SMS Controller Response: {}", response.getBody());
            }
        }
        catch (Exception e) {
            logger.error("Error sending SMS : {} {}", (Object)e.getMessage(), (Object)e);
        }
    }

    private void enqueueTask(EnqueueTask task) {
        this.lock.lock();
        try {
            this.taskQueue.add(task);
            this.newTaskAvailable.signal();
        }
        finally {
            this.lock.unlock();
        }
    }

    private void executeTask(EnqueueTask task) {
        ThreadContext.put((String)"correlationId", (String)task.correlationId);
        try {
            task.runnable.run();
        }
        catch (Exception e) {
            logger.error("Error executing task", (Throwable)e);
        }
        finally {
            ThreadContext.remove((String)"correlationId");
        }
    }

    private void loadTemplates() {
        BufferedReader reader;
        InputStream stream;
        try {
            String emailTemplateFileName = "/etc/coraltele/template/nms-email.template";
            File emailTemplateFile = new File(emailTemplateFileName);
            if (emailTemplateFile.exists()) {
                stream = new FileInputStream(emailTemplateFile);
                reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                this.emailTemplate = reader.lines().collect(Collectors.joining("\n"));
                reader.close();
            } else {
                stream = NotificationManagerProcess.class.getClassLoader().getResourceAsStream("nms-email.template");
                reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                this.emailTemplate = reader.lines().collect(Collectors.joining("\n"));
                reader.close();
            }
        }
        catch (Exception e) {
            logger.error("Error loading email template", (Throwable)e);
        }
        try {
            String smsTemplateFileName = "/etc/coraltele/template/nms-sms.template";
            File smsTemplateFile = new File(smsTemplateFileName);
            if (smsTemplateFile.exists()) {
                stream = new FileInputStream(smsTemplateFile);
                reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                this.smsTemplate = reader.lines().collect(Collectors.joining("\n"));
                reader.close();
            } else {
                stream = NotificationManagerProcess.class.getClassLoader().getResourceAsStream("nms-sms.template");
                reader = new BufferedReader(new InputStreamReader(stream, StandardCharsets.UTF_8));
                this.smsTemplate = reader.lines().collect(Collectors.joining("\n"));
                reader.close();
            }
        }
        catch (Exception e) {
            logger.error("Error loading SMS template", (Throwable)e);
        }
    }

    private String generateContent(String template, Map<String, String> values) {
        String returnValue = new String(template);
        for (Map.Entry<String, String> entry : values.entrySet()) {
            returnValue = returnValue.replace("{{" + entry.getKey() + "}}", entry.getValue());
        }
        return returnValue;
    }

    private boolean checkAllData(CategoryService cs) {
        boolean level3Sms;
        boolean level2Sms;
        boolean level1Sms;
        if (cs.getEscalationLevel1Duration() == null) {
            logger.warn("Duration missing for serviceCode: {} and categoryCode: {}. Skipping escalation setup.", (Object)cs.getServiceCode(), (Object)cs.getCategoryCode());
            return false;
        }
        if (cs.getEscalationLevel2Duration() == null) {
            cs.setEscalationLevel2Duration(cs.getEscalationLevel1Duration());
            this.categoryServiceRepository.save((Object)cs);
        }
        if (cs.getEscalationLevel3Duration() == null) {
            cs.setEscalationLevel3Duration(cs.getEscalationLevel1Duration());
            this.categoryServiceRepository.save((Object)cs);
        }
        boolean hasEscalationTarget = false;
        boolean level1Email = cs.getEscalationLevel1MailId() != null && !cs.getEscalationLevel1MailId().trim().isEmpty();
        boolean bl = level1Sms = cs.getEscalationLevel1SmsId() != null && !cs.getEscalationLevel1SmsId().trim().isEmpty();
        if (!level1Email) {
            cs.setEscalationLevel1MailId("");
        } else {
            hasEscalationTarget = true;
        }
        if (!level1Sms) {
            cs.setEscalationLevel1SmsId("");
        } else {
            hasEscalationTarget = true;
        }
        boolean level2Email = cs.getEscalationLevel2MailId() != null && !cs.getEscalationLevel2MailId().trim().isEmpty();
        boolean bl2 = level2Sms = cs.getEscalationLevel2SmsId() != null && !cs.getEscalationLevel2SmsId().trim().isEmpty();
        if (!level2Email) {
            cs.setEscalationLevel2MailId("");
        } else {
            hasEscalationTarget = true;
        }
        if (!level2Sms) {
            cs.setEscalationLevel2SmsId("");
        } else {
            hasEscalationTarget = true;
        }
        boolean level3Email = cs.getEscalationLevel3MailId() != null && !cs.getEscalationLevel3MailId().trim().isEmpty();
        boolean bl3 = level3Sms = cs.getEscalationLevel3SmsId() != null && !cs.getEscalationLevel3SmsId().trim().isEmpty();
        if (!level3Email) {
            cs.setEscalationLevel3MailId("");
        } else {
            hasEscalationTarget = true;
        }
        if (!level3Sms) {
            cs.setEscalationLevel3SmsId("");
        } else {
            hasEscalationTarget = true;
        }
        if (!hasEscalationTarget) {
            logger.warn("No escalation Email or SMS defined at any level for serviceCode: {} and categoryCode: {}. Skipping.", (Object)cs.getServiceCode(), (Object)cs.getCategoryCode());
            return false;
        }
        return true;
    }

    private void loadEscalationData() {
        logger.info("Loading Escalation Data");
        EscalationModel defaultEscalation1 = new EscalationModel(Integer.valueOf(1), Constants.ESCALATION_1);
        EscalationModel defaultEscalation2 = new EscalationModel(Integer.valueOf(2), Constants.ESCALATION_2);
        EscalationModel defaultEscalation3 = new EscalationModel(Integer.valueOf(3), Constants.ESCALATION_3);
        EscalationHelper defaultEscalationHelper = new EscalationHelper(defaultEscalation1, defaultEscalation2, defaultEscalation3);
        this.escalationMatrix.put("DEFAULT", defaultEscalationHelper);
        try {
            List categoryService = this.categoryServiceRepository.findAll();
            for (CategoryService cs : categoryService) {
                if (!this.checkAllData(cs)) continue;
                EscalationModel escalationLevel1 = new EscalationModel(Integer.valueOf(1), cs.getEscalationLevel1Duration(), cs.getEscalationLevel1MailId(), "", cs.getEscalationLevel1SmsId());
                EscalationModel escalationLevel2 = new EscalationModel(Integer.valueOf(2), cs.getEscalationLevel2Duration(), cs.getEscalationLevel2MailId(), "", cs.getEscalationLevel2SmsId());
                EscalationModel escalationLevel3 = new EscalationModel(Integer.valueOf(3), cs.getEscalationLevel3Duration(), cs.getEscalationLevel3MailId(), "", cs.getEscalationLevel3SmsId());
                EscalationHelper escalationHelper = new EscalationHelper(escalationLevel1, escalationLevel2, escalationLevel3);
                this.escalationMatrix.put(cs.getServiceCode() + "-" + cs.getCategoryCode(), escalationHelper);
            }
        }
        catch (Exception e) {
            logger.error("Error loading escalation data", (Throwable)e);
        }
    }

    public void alertUpdate(SCADAAsset currentAsset, ServiceStatus serviceStatus) {
        Optional severity;
        String severityName = "Unknown";
        if (serviceStatus.getSeverity() != null && (severity = this.severityRepository.findBySeverityLevel(serviceStatus.getSeverity())).isPresent()) {
            severityName = ((Severity)severity.get()).getSeverityName();
        }
        String assetName = currentAsset != null ? (StringUtils.hasText((String)currentAsset.getNodeName()) ? currentAsset.getNodeName() : serviceStatus.getIpAddress()) : serviceStatus.getIpAddress();
        this.alertUpdate(serviceStatus.getAssetId(), assetName, Boolean.TRUE.equals(serviceStatus.getStatus()) ? "UP" : "Down", LocalDateTime.now().toString(), serviceStatus.getService(), serviceStatus.getCategory(), serviceStatus.getIpAddress(), severityName);
    }
}

