/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.thread;

import com.coraltele.telemetry.db.telemetry.main.entity.Counter;
import com.coraltele.telemetry.db.telemetry.main.repository.CounterRepository;
import com.coraltele.telemetry.helper.Constants;
import java.io.File;
import java.io.FileInputStream;
import java.time.Instant;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class CounterCollectorThread
implements Runnable {
    private static final Logger logger = LogManager.getLogger(CounterCollectorThread.class);
    CounterRepository counterRepository;
    public volatile boolean isRunning = true;

    public CounterCollectorThread(CounterRepository counterRepository) {
        this.counterRepository = counterRepository;
    }

    @Override
    public void run() {
        logger.info("Starting Ping Check Thread");
        while (this.isRunning) {
            try {
                logger.info("Looping to read counters");
                this.getNewFiles();
                this.readXMLFile("cu.xml");
                this.readXMLFile("du.xml");
                Thread.sleep(Constants.COUNTER_READ_INTERVAL);
            }
            catch (Exception e) {
                this.isRunning = false;
                logger.error("While reading counters", (Throwable)e);
                Thread.currentThread().interrupt();
            }
        }
    }

    public void getNewFiles() {
        String scriptPath = "/usr/bin/copy_xml";
        logger.info("Get New Files");
        ProcessBuilder processBuilder = new ProcessBuilder(scriptPath);
        try {
            Process process = processBuilder.start();
            int exitCode = process.waitFor();
            logger.info("Get New Files. Exit Code {}", (Object)exitCode);
        }
        catch (Exception e) {
            logger.error("While executing script", (Throwable)e);
        }
    }

    public void readXMLFile(String fileToRead) {
        String fileName = Constants.COUNTER_FILE_DIRECTORY + "/" + fileToRead;
        try {
            File file = new File(fileName);
            logger.info("Starting to read file {}", (Object)fileName);
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            FileInputStream inputStream = new FileInputStream(file);
            InputSource inputSource = new InputSource(inputStream);
            Document document = builder.parse(inputSource);
            NodeList parentNode = document.getDocumentElement().getChildNodes();
            for (int i = 0; i < parentNode.getLength(); ++i) {
                Node rowNode = parentNode.item(i);
                logger.info("Processing node : {}", (Object)rowNode.getNodeName());
                if (!rowNode.getNodeName().equals("measData")) continue;
                NodeList measurementData = rowNode.getChildNodes();
                for (int j = 0; j < measurementData.getLength(); ++j) {
                    Node measurementNode = measurementData.item(j);
                    if (!measurementNode.getNodeName().equals("measInfo")) continue;
                    NodeList measurementInfo = measurementNode.getChildNodes();
                    HashMap<String, String> counterNameList = new HashMap<String, String>();
                    Long measurementEpoch = 0L;
                    for (int k = 0; k < measurementInfo.getLength(); ++k) {
                        Node measurementName = measurementInfo.item(k);
                        logger.info("Processing node : {}", (Object)measurementName.getNodeName());
                        if (measurementName.getNodeName().equals("granPeriod")) {
                            String measurementDate = measurementName.getAttributes().getNamedItem("endTime").getNodeValue();
                            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm:ssZ");
                            OffsetDateTime offsetDateTime = OffsetDateTime.parse(measurementDate, formatter);
                            Instant instant = offsetDateTime.toInstant();
                            measurementEpoch = instant.getEpochSecond();
                            continue;
                        }
                        if (measurementName.getNodeName().equals("measType") && measurementEpoch > 0L) {
                            String counterKey = measurementName.getAttributes().getNamedItem("p").getNodeValue();
                            String counterName = measurementName.getTextContent();
                            counterNameList.put(counterKey, counterName);
                            continue;
                        }
                        if (!measurementName.getNodeName().equals("measValue") || measurementEpoch <= 0L) continue;
                        NodeList measurementValue = measurementName.getChildNodes();
                        for (int l = 0; l < measurementValue.getLength(); ++l) {
                            Node value = measurementValue.item(l);
                            if (!value.getNodeName().equals("measType")) continue;
                            String valueKey = value.getAttributes().getNamedItem("p").getNodeValue();
                            String valueData = value.getTextContent();
                            String valueCounterName = (String)counterNameList.get(valueKey);
                            logger.info("Measurement Values {} {} {}", (Object)valueKey, (Object)valueData, (Object)valueCounterName);
                            Counter dataToSave = new Counter();
                            dataToSave.setAttributeName(valueCounterName);
                            dataToSave.setAttributeValue(valueData);
                            dataToSave.setEventEpoch(measurementEpoch);
                            dataToSave.setReceivedEpoch(measurementEpoch);
                            this.counterRepository.save((Object)dataToSave);
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error("Error while reading XML {}", (Object)fileName, (Object)e);
        }
    }
}

