/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.timeseries.controller;

import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.timeseries.model.TimeSeriesLabelModel;
import com.coraltele.telemetry.service.timeseries.service.MetricsService;
import java.security.Principal;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/metrics"})
@RestController
public class MetricsDataController {
    private static final Logger logger = LogManager.getLogger(MetricsDataController.class);
    @Autowired
    MetricsService metricsService;

    @GetMapping(value={"/data/{id}"})
    public ResponseEntity<RequestResponse> getData(@PathVariable(value="id") String id) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.metricsService.getData(id));
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/multiSeries/{id}"})
    public ResponseEntity<RequestResponse> getData2(@PathVariable(value="id") String id, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.metricsService.getData2(principal, id));
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/data/{id}"})
    public ResponseEntity<RequestResponse> updateData(@PathVariable(value="id") String id, @RequestBody TimeSeriesLabelModel[] data, Principal principal) {
        logger.info("Data Received for sensor {} : {}", (Object)id, (Object)data);
        RequestResponse returnValue = this.metricsService.updateSensorData(principal, id, data);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

