/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.coralnms.scada_assets.controller;

import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.coralnms.scada_assets.model.SCADAAssetModel;
import com.coraltele.telemetry.service.coralnms.scada_assets.model.ServerGroupModel;
import com.coraltele.telemetry.service.coralnms.scada_assets.service.SCADAAssetService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/api/v2/SCADAAsset"})
public class SCADAAssetController {
    @Autowired
    private SCADAAssetService service;

    @PostMapping(value={"/register"})
    public ResponseEntity<RequestResponse> add(@RequestBody SCADAAssetModel data) {
        RequestResponse returnValue = this.service.create(data);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/{id}"})
    public ResponseEntity<RequestResponse> getById(@PathVariable(value="id") Long id) {
        RequestResponse returnValue = this.service.getById(id);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAll() {
        RequestResponse returnValue = this.service.getAll();
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PutMapping(value={"/{id}"})
    public ResponseEntity<RequestResponse> update(@RequestBody SCADAAssetModel data, @PathVariable(value="id") Long id) {
        RequestResponse returnValue = this.service.update(data, id);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PutMapping(value={"/updateControl"})
    public ResponseEntity<RequestResponse> updateByServerGroupId(@RequestBody ServerGroupModel data) {
        RequestResponse returnValue = this.service.updateByServerGroupId(data);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/uuid/{id}"})
    public ResponseEntity<RequestResponse> getByUuid(@PathVariable(value="id") String id) {
        RequestResponse returnValue = this.service.getByUuid(id);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/uploadCSVStatus"})
    public ResponseEntity<RequestResponse> uploadCSVStatus(@RequestParam(value="file") MultipartFile file) {
        RequestResponse returnValue = this.service.uploadCSVStatus(file);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

