/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.component.controller;

import com.coraltele.telemetry.component.service.ChannelActiveCallService;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/data"})
public class ChannelActiveCallController {
    @Autowired
    private ChannelActiveCallService channelActiveCallService;

    @GetMapping(value={"/active-calls/{widgetCode}"})
    public ResponseEntity<RequestResponse> getActiveCalls(@PathVariable(value="widgetCode") String widgetCode) {
        RequestResponse returnValue = new RequestResponse();
        returnValue.setData((Object)this.channelActiveCallService.fetchChannelActiveCallData(widgetCode));
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/active-calls-bandwidth/{widgetCode}"})
    public ResponseEntity<RequestResponse> getBandWidthDetails(@PathVariable(value="widgetCode") String widgetCode) {
        RequestResponse returnValue = this.channelActiveCallService.fetchChannelActiveBandWidthDetails(widgetCode);
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

