/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.helper;

import com.coraltele.telemetry.db.telemetry.coralnms.repository.CategoryRepository;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.IMSIRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.AlertRepository;
import com.coraltele.telemetry.helper.Bootstrap;
import com.coraltele.telemetry.service.coralnms.category.service.CategoryService;
import com.coraltele.telemetry.service.coralnms.widget.service.WidgetService;
import com.coraltele.telemetry.service.coralnms.widget_type.service.WidgetTypeService;
import java.io.IOException;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.stereotype.Service;

@Service
public class BootstrapController {
    private static final Logger logger = LogManager.getLogger(BootstrapController.class);
    @Autowired
    CategoryService categoryService;
    @Autowired
    WidgetService widgetService;
    @Autowired
    WidgetTypeService widgetTypeService;
    @Autowired
    private JdbcTemplate jdbcTemplate;
    @Autowired
    CategoryRepository categoryRepository;
    @Autowired
    AlertRepository alertRepository;
    @Autowired
    IMSIRepository imsiRepository;
    @Autowired
    private ApplicationContext context;

    @PostConstruct
    public void startWidgetTypeService() {
        logger.info("starting widgetType service");
        try {
            this.widgetTypeService.retrieveDataFromFileAndStoreInTable();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    @PostConstruct
    public void startCategoryService() {
        Bootstrap.createSwitchSchemas((ApplicationContext)this.context, (String)"views");
        logger.info("starting category service");
        try {
            this.categoryService.retrieveDataFromFileAndStoreInTable();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    @PostConstruct
    public void startWidgetService() {
        logger.info("starting widget service");
        try {
            this.widgetService.retrieveDataFromFileAndStore();
        }
        catch (IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    @PostConstruct
    public void initializeSequence() {
        Integer maxId = this.categoryRepository.findMaxId();
        if (maxId != null) {
            String sequenceName = "coralnms.m_category_id_seq";
            String updateSequenceSql = "SELECT setval('" + sequenceName + "', " + maxId + ", true)";
            this.jdbcTemplate.execute(updateSequenceSql);
        } else if (maxId == null) {
            String sequenceName = "coralnms.m_category_id_seq";
            String createSequenceSql = "ALTER SEQUENCE " + sequenceName + " RESTART WITH 1";
            this.jdbcTemplate.execute(createSequenceSql);
        }
    }

    @PostConstruct
    public void updateUUID() {
        try {
            logger.info("Updating UUID for alerts");
            this.alertRepository.updateUUID();
        }
        catch (Exception e) {
            logger.error("Error updating Alert UUID: ", (Throwable)e);
        }
        try {
            logger.info("Updating UUID for IMSI");
            this.imsiRepository.updateUUID();
        }
        catch (Exception e) {
            logger.error("Error updating IMSI UUID: ", (Throwable)e);
        }
    }
}

