/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.bootstrap;

import com.coraltele.telemetry.bootstrap.JwtUserDetailConfiguration;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.HTTPHelper;
import com.coraltele.telemetry.helper.JwtUtil;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.UserInfo;
import com.coraltele.telemetry.service.user.service.UserService;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.jsonwebtoken.ExpiredJwtException;
import java.io.IOException;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.BadCredentialsException;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UsernameNotFoundException;
import org.springframework.stereotype.Component;
import org.springframework.util.StringUtils;
import org.springframework.web.filter.OncePerRequestFilter;

@Component
public class JwtAuthenticationFilter
extends OncePerRequestFilter {
    private static final Logger logger = LogManager.getLogger(JwtAuthenticationFilter.class);
    @Autowired
    private JwtUserDetailConfiguration jwtUserDetailConfiguration;
    @Autowired
    private JwtUtil jwtUtil;
    @Autowired
    UserService userService;

    protected void doFilterInternal(HttpServletRequest request, HttpServletResponse response, FilterChain filterChain) throws ServletException, IOException {
        block10: {
            RequestResponse returnValue = new RequestResponse();
            try {
                String authorizationHeader = request.getHeader("Authorization");
                if (!StringUtils.hasText((String)authorizationHeader)) break block10;
                String[] authHeaderValues = authorizationHeader.split(" ");
                if (authHeaderValues.length == 2 && authHeaderValues[0].equals("Bearer")) {
                    String jwtToken = authHeaderValues[1];
                    UserInfo userDetails = this.jwtUserDetailConfiguration.loadUserFromJWT(jwtToken, request.getRequestURL().toString());
                    if (userDetails != null && this.jwtUtil.validateToken(jwtToken, userDetails.getUuidSecurity())) {
                        UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                        SecurityContextHolder.getContext().setAuthentication((Authentication)usernamePasswordAuthenticationToken);
                        logger.info("User authenticated successfully with JWT token");
                        break block10;
                    }
                    logger.warn("Invalid JWT Token provided in the Authorization header");
                    returnValue.setIssue(Constants.NodeStatus.ERROR);
                    returnValue.setMessage("Invalid JWT Token provided in the Authorization header");
                    response.setStatus(401);
                    response.getWriter().write(new ObjectMapper().writeValueAsString((Object)returnValue));
                    return;
                }
                if (authHeaderValues.length == 2 && authHeaderValues[0].equals("Opaque")) {
                    String userInputKey = authHeaderValues[1];
                    String userIpAddress = HTTPHelper.getRequestIp((HttpServletRequest)request);
                    String userName = this.userService.retrieveUser(userIpAddress, userInputKey);
                    if (userName != null && !userName.isEmpty()) {
                        UserInfo userDetails = this.jwtUserDetailConfiguration.loadUserByUsername(userName);
                        UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                        SecurityContextHolder.getContext().setAuthentication((Authentication)usernamePasswordAuthenticationToken);
                        logger.info("User authenticated successfully with API key from IP address(Opaque): {}", (Object)userIpAddress);
                        break block10;
                    }
                    logger.warn("Invalid API key provided in the Authorization header from IP address(Opaque): {}", (Object)userIpAddress);
                    returnValue.setIssue(Constants.NodeStatus.ERROR);
                    returnValue.setMessage("Invalid API key provided in the Authorization header from IP address:" + userIpAddress);
                    response.setStatus(401);
                    response.getWriter().write(new ObjectMapper().writeValueAsString((Object)returnValue));
                    return;
                }
                if (authHeaderValues.length == 2 && authHeaderValues[0].equals("Cluster")) {
                    String userName;
                    String userInputKey = authHeaderValues[1];
                    String userIpAddress = HTTPHelper.getRequestIp((HttpServletRequest)request);
                    String string = userName = StringUtils.hasLength((String)Constants.CLUSTER_KEY) && userInputKey.equals(Constants.CLUSTER_KEY) && Constants.NODE_IP_LIST.containsKey(userIpAddress) ? "admin" : null;
                    if (userName != null && !userName.isEmpty()) {
                        UserInfo userDetails = this.jwtUserDetailConfiguration.loadUserByUsername(userName);
                        UsernamePasswordAuthenticationToken usernamePasswordAuthenticationToken = new UsernamePasswordAuthenticationToken((Object)userDetails, null, userDetails.getAuthorities());
                        SecurityContextHolder.getContext().setAuthentication((Authentication)usernamePasswordAuthenticationToken);
                        logger.info("User authenticated successfully with API key for Cluster from IP address(Cluster): {}", (Object)userIpAddress);
                        break block10;
                    }
                    logger.warn("Invalid API key provided in the Authorization header from IP address(Cluster): {}", (Object)userIpAddress);
                    returnValue.setMessage("Invalid API key provided in the Authorization header from IP address:" + userIpAddress);
                    response.setStatus(401);
                    response.getWriter().write(new ObjectMapper().writeValueAsString((Object)returnValue));
                    return;
                }
                logger.warn("Invalid Authorization header value");
                returnValue.setIssue(Constants.NodeStatus.ERROR);
                returnValue.setMessage("Invalid Authorization header value");
                response.setStatus(401);
                response.getWriter().write(new ObjectMapper().writeValueAsString((Object)returnValue));
                return;
            }
            catch (ExpiredJwtException ex) {
                request.setAttribute("exception", (Object)ex);
            }
            catch (BadCredentialsException | UsernameNotFoundException ex) {
                logger.warn("Invalid credentials provided in the Authorization header", ex);
                returnValue.setIssue(Constants.NodeStatus.ERROR);
                returnValue.setMessage("Invalid Token provided in the Authorization header");
                response.setStatus(401);
                response.getWriter().write(new ObjectMapper().writeValueAsString((Object)returnValue));
                return;
            }
            catch (Exception ex) {
                logger.error("Error occurred while authenticating the user", (Throwable)ex);
            }
        }
        filterChain.doFilter((ServletRequest)request, (ServletResponse)response);
    }
}

