/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.condition.EnableSendMail;
import com.coraltele.telemetry.db.telemetry.coralnms.repository.CategoryRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.AlertHistoryRepository;
import com.coraltele.telemetry.db.telemetry.main.repository.SeverityRepository;
import com.coraltele.telemetry.helper.SendEmail;
import com.coraltele.telemetry.thread.SendEmailThread;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnableSendMail.class})
public class SendEmailProcess {
    @Autowired
    private SendEmail sendEmailService;
    @Autowired
    private CategoryRepository categoryRepository;
    @Autowired
    private AlertHistoryRepository alertHistoryRepository;
    @Autowired
    private SeverityRepository severityReposiotRepository;
    private static final Logger logger = LogManager.getLogger(SendEmailProcess.class);
    private static final Integer MAX_THREADS = 1;
    ExecutorService threadPool = Executors.newFixedThreadPool(1);

    @Scheduled(fixedRate=5000L)
    public void startHealthCheck() throws InterruptedException {
        logger.info("Maximum Threads : {}, Active Thread {} ", (Object)MAX_THREADS, (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount());
        Integer threadsStarted = 0;
        while (((ThreadPoolExecutor)this.threadPool).getActiveCount() < MAX_THREADS) {
            Integer n = threadsStarted;
            Integer n2 = threadsStarted = Integer.valueOf(threadsStarted + 1);
            logger.info("Starting Send Email Process.");
            this.threadPool.execute((Runnable)new SendEmailThread(this.sendEmailService, this.categoryRepository, this.alertHistoryRepository, this.severityReposiotRepository));
        }
        logger.info("{} Threads started", (Object)threadsStarted);
    }
}

