/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.polygon.area.controller;

import com.coraltele.telemetry.db.users.main.repository.UserRepository;
import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.model.InputIdModel;
import com.coraltele.telemetry.model.SearchRequest;
import com.coraltele.telemetry.service.main.polygon.area.model.AreaModel;
import com.coraltele.telemetry.service.main.polygon.area.service.AreaService;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/area"})
@RestController
public class AreaController {
    @Autowired
    AreaService areaService;
    @Autowired
    UserRepository userRepository;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody AreaModel data, Principal principal) {
        RequestResponse returnValue = this.areaService.createData(data, principal);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody AreaModel data, Principal principal) {
        RequestResponse returnValue = this.areaService.updateById(data, principal);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id, Principal principal) {
        RequestResponse returnValue = this.areaService.deleteById(id, principal);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @GetMapping(value={"/listAll"})
    public ResponseEntity<RequestResponse> getAll() {
        RequestResponse returnValue = this.areaService.getAll();
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllArea(@RequestBody SearchRequest searchRequestData) {
        RequestResponse returnValue = this.areaService.getAllArea(searchRequestData);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/areaOfUser"})
    public ResponseEntity<RequestResponse> getArea(String username, Principal principal, boolean isUser) {
        RequestResponse returnValue = this.areaService.getAreaOfUser("", principal, false);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/user/{username}"})
    public ResponseEntity<RequestResponse> getAreaByUser(@PathVariable(value="username") String username, Principal principal, boolean isUser) {
        RequestResponse returnValue = this.areaService.getAreaOfUser(username, principal, true);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/listOfUser/{areaId}"})
    public ResponseEntity<RequestResponse> getAllUsersByRoute(@PathVariable(value="areaId") Integer areaId) {
        return this.getAllUsers(areaId, null);
    }

    @PostMapping(value={"/listOfUserByShapeId/{shapeId}"})
    public ResponseEntity<RequestResponse> getAllUsersByShape(@PathVariable(value="shapeId") String shapeId) {
        return this.getAllUsers(null, shapeId);
    }

    private ResponseEntity<RequestResponse> getAllUsers(Integer areaId, String shapeId) {
        RequestResponse returnValue = this.areaService.getCoordinate(areaId, shapeId);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete/shapeId"})
    public ResponseEntity<RequestResponse> deleteByType(@RequestBody InputIdModel id, Principal principal) {
        RequestResponse returnValue = this.areaService.deleteByType(id, principal);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

