/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.service.main.alternateIp.controller;

import com.coraltele.telemetry.helper.Constants;
import com.coraltele.telemetry.helper.RequestResponse;
import com.coraltele.telemetry.service.main.alternateIp.model.AlternateIpModel;
import com.coraltele.telemetry.service.main.alternateIp.service.AlternateIpService;
import java.security.Principal;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/app/v2/AlternateIp"})
@RestController
public class AlternateIpController {
    @Autowired
    private AlternateIpService alternateIpService;

    @PostMapping(value={"/catalogue"})
    public ResponseEntity<RequestResponse> getAll() {
        RequestResponse returnValue = this.alternateIpService.getAll();
        if (returnValue.getStatus() == 0) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody AlternateIpModel data, Principal principle) {
        RequestResponse returnValue = this.alternateIpService.createData(data, principle.getName());
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody AlternateIpModel data, Principal principal) {
        RequestResponse returnValue = this.alternateIpService.updateById(data, principal.getName());
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete/{id}"})
    public ResponseEntity<RequestResponse> delete(@PathVariable(value="id") String id) {
        RequestResponse returnValue = this.alternateIpService.deleteById(id);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/read/{id}"})
    public ResponseEntity<RequestResponse> readById(@PathVariable(value="id") String id) {
        RequestResponse returnValue = this.alternateIpService.getById(id);
        if (returnValue.getIssue().equals((Object)Constants.NodeStatus.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

