/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.telemetry.background;

import com.coraltele.telemetry.condition.EnableCounterResonous;
import com.coraltele.telemetry.db.telemetry.main.repository.CounterRepository;
import com.coraltele.telemetry.thread.CounterCollectorThread;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Conditional;
import org.springframework.scheduling.annotation.Scheduled;
import org.springframework.stereotype.Service;

@Service
@Conditional(value={EnableCounterResonous.class})
public class CounterCollectorProcess {
    private static final Logger logger = LogManager.getLogger(CounterCollectorProcess.class);
    private static final Integer MAX_THREADS = 1;
    @Autowired
    CounterRepository counterRepository;
    ExecutorService threadPool = Executors.newFixedThreadPool(1);

    @Scheduled(fixedRate=5000L)
    public void startCounterCollection() {
        logger.info("Maximum Counter collection Threads : {}, Active Thread {} ", (Object)MAX_THREADS, (Object)((ThreadPoolExecutor)this.threadPool).getActiveCount());
        Integer threadsStarted = 0;
        while (((ThreadPoolExecutor)this.threadPool).getActiveCount() < MAX_THREADS) {
            Integer n = threadsStarted;
            Integer n2 = threadsStarted = Integer.valueOf(threadsStarted + 1);
            logger.info("Starting Counter collection Thread");
            this.threadPool.execute((Runnable)new CounterCollectorThread(this.counterRepository));
        }
        logger.info("{} Counter collection Threads started", (Object)threadsStarted);
    }
}

