/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.userRouteShift.userShift.service;

import com.coraltele.db.telemetry.main.entity.Route;
import com.coraltele.db.telemetry.main.entity.UserCoordinate;
import com.coraltele.db.telemetry.main.entity.UserZone;
import com.coraltele.db.telemetry.main.repository.RouteRepository;
import com.coraltele.db.telemetry.main.repository.UserCoordinateRepository;
import com.coraltele.db.telemetry.main.repository.UserZoneRepository;
import com.coraltele.db.users.main.entity.ShiftTime;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.entity.UserShift;
import com.coraltele.db.users.main.repository.ShiftTimeRepository;
import com.coraltele.db.users.main.repository.UserGroupMasterRepository;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.db.users.main.repository.UserShiftRepository;
import com.coraltele.db.users.main.specification.UserShiftSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.EventNotifyModel;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.telemetry.coralnms.imsi.service.IMSIService;
import com.coraltele.service.telemetry.main.areaCoordinate.service.RouteService;
import com.coraltele.service.telemetry.main.routeCoordinate.service.RouteCoordinateService;
import com.coraltele.service.telemetry.main.userZone.service.UserZoneService;
import com.coraltele.service.user.service.UserService;
import com.coraltele.service.user.userRouteShift.shiftTime.model.ShiftTimeModel;
import com.coraltele.service.user.userRouteShift.shiftTime.service.ShiftTimeService;
import com.coraltele.service.user.userRouteShift.userShift.model.CoordinateModel;
import com.coraltele.service.user.userRouteShift.userShift.model.RouteModel;
import com.coraltele.service.user.userRouteShift.userShift.model.RouteServiceModel;
import com.coraltele.service.user.userRouteShift.userShift.model.RouteServiceModel2;
import com.coraltele.service.user.userRouteShift.userShift.model.RouteServiceModel3;
import com.coraltele.service.user.userRouteShift.userShift.model.ShiftDetailModel;
import com.coraltele.service.user.userRouteShift.userShift.model.UserShiftModel;
import com.coraltele.service.user.userRouteShift.userShift.model.ZoneUserData;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.locationtech.jts.geom.Coordinate;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class UserShiftService {
    private static final Logger logger = LogManager.getLogger(UserShiftService.class);
    @Autowired
    UserRepository userRepository;
    @Autowired
    UserGroupMasterRepository userGroupMasterRepository;
    @Autowired
    ShiftTimeRepository shiftTimeRepository;
    @Autowired
    RouteRepository routeRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;
    @Autowired
    UserShiftRepository userShiftRepository;
    @Autowired
    ShiftTimeService shiftTimeService;
    @Autowired
    RouteService routeService;
    @Autowired
    IMSIService iMSIService;
    @Autowired
    RouteCoordinateService routeCoordinateService;
    @Autowired
    UserCoordinateRepository userCoordinateRepository;
    @Autowired
    UserZoneRepository userZoneRepository;
    @Autowired
    UserZoneService userZoneService;

    public RequestResponse createUserShift(UserShiftModel data, Principal principal) {
        logger.debug("Creating new task type: {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional userShiftOptional = this.userShiftRepository.findByShiftIdAndUserId(data.getShiftId(), data.getUserId());
            if (userShiftOptional.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("User with this shift already exists");
                returnValue.setMessageDetail("User with this shift already exists");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            UserShift userShift = new UserShift();
            userShift.setRouteId(data.getRouteId());
            userShift.setShiftId(data.getShiftId());
            userShift.setZoneId(data.getZoneId());
            userShift.setUserId(data.getUserId());
            UserShift savedShift = (UserShift)this.userShiftRepository.save((Object)userShift);
            try {
                if (data.getRouteId() != null) {
                    EventNotifyModel eventData = new EventNotifyModel();
                    long epoch = System.currentTimeMillis() / 1000L;
                    eventData.setReadByUser(Boolean.valueOf(false));
                    eventData.setEventId(Constants.EventStatus.USER_SHIFT_UPDATE_EVENT);
                    eventData.setEventSeverity(Integer.valueOf(1));
                    eventData.setEventUUID(UUID.randomUUID().toString());
                    eventData.setEventMessage("New Shift assigned:" + this.shiftTimeService.getShiftName(userShift.getShiftId()));
                    eventData.setEventEpoch(Long.valueOf(epoch));
                    eventData.setEventSource(principal.getName());
                    eventData.setEventDestination(userShift.getUserId());
                    if (this.routeCoordinateService.getRouteData(data.getRouteId()) != null) {
                        Route route = this.routeCoordinateService.getRouteData(data.getRouteId());
                        ShiftTime shift = this.shiftTimeService.getShiftData(data.getShiftId());
                        eventData.setEventData((Object)("route:" + route.getName() + "and shift:" + shift.getName()));
                    } else {
                        eventData.setEventData((Object)("Shift Associated:" + this.shiftTimeService.getShiftName(userShift.getShiftId()) + "and user is:" + data.getUserId()));
                    }
                    this.userService.sendNotifyToSubscriber(eventData);
                } else if (data.getZoneId() != null) {
                    EventNotifyModel eventData = new EventNotifyModel();
                    long epoch = System.currentTimeMillis() / 1000L;
                    eventData.setReadByUser(Boolean.valueOf(false));
                    eventData.setEventId(Constants.EventStatus.USER_SHIFT_UPDATE_EVENT);
                    eventData.setEventSeverity(Integer.valueOf(1));
                    eventData.setEventUUID(UUID.randomUUID().toString());
                    eventData.setEventMessage("New Shift assigned:" + this.shiftTimeService.getShiftName(userShift.getShiftId()));
                    eventData.setEventEpoch(Long.valueOf(epoch));
                    eventData.setEventSource(principal.getName());
                    eventData.setEventDestination(userShift.getUserId());
                    if (this.userZoneService.getZoneData(data.getZoneId()) != null) {
                        UserZone userZone = this.userZoneService.getZoneData(data.getZoneId());
                        ShiftTime shift = this.shiftTimeService.getShiftData(data.getShiftId());
                        eventData.setEventData((Object)("Zone: " + userZone.getName() + " and shift: " + shift.getName()));
                    } else {
                        eventData.setEventData((Object)("Shift Associated:" + this.shiftTimeService.getShiftName(userShift.getShiftId()) + "and user is:" + data.getUserId()));
                    }
                    this.userService.sendNotifyToSubscriber(eventData);
                } else {
                    EventNotifyModel eventData = new EventNotifyModel();
                    long epoch = System.currentTimeMillis() / 1000L;
                    eventData.setReadByUser(Boolean.valueOf(false));
                    eventData.setEventData((Object)("New shift assigned:" + userShift.getShiftId()));
                    eventData.setEventId(Constants.EventStatus.USER_SHIFT_UPDATE_EVENT);
                    eventData.setEventSeverity(Integer.valueOf(1));
                    eventData.setEventUUID(UUID.randomUUID().toString());
                    eventData.setEventMessage("New Shift assigned:" + this.shiftTimeService.getShiftName(userShift.getShiftId()));
                    eventData.setEventEpoch(Long.valueOf(epoch));
                    eventData.setEventSource(principal.getName());
                    eventData.setEventDestination(userShift.getUserId());
                    eventData.setEventData((Object)("Shift Associated:" + this.shiftTimeService.getShiftName(userShift.getShiftId()) + "and user is:" + data.getUserId()));
                    this.userService.sendNotifyToSubscriber(eventData);
                }
            }
            catch (Exception e) {
                logger.error("Unable to send event on user assigned with shift");
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Registered successfully");
            returnValue.setMessageDetail("User Shift registered successfully with ID " + savedShift.getId());
            logger.info("User Shift saved: {}", (Object)returnValue.getMessage());
        }
        catch (Exception ex) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Internal Server Error");
            returnValue.setMessageDetail("An error occurred while registering the user shift");
            logger.error("Error occurred while saving User Shift for user ID {}: {}", (Object)data.getUserId(), (Object)ex.getMessage(), (Object)ex);
        }
        return returnValue;
    }

    public RequestResponse deleteUserShift(InputIdModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional userShift = this.userShiftRepository.findById((Object)ids);
            if (userShift.isPresent()) {
                UserShift userShift2 = (UserShift)userShift.get();
                addValue.add(userShift.get());
                this.userShiftRepository.deleteAll(addValue);
                EventNotifyModel eventData = new EventNotifyModel();
                long epoch = System.currentTimeMillis() / 1000L;
                eventData.setReadByUser(Boolean.valueOf(false));
                eventData.setEventData((Object)("User " + userShift2.getUserId() + "delete from the shift :" + userShift2.getShiftId()));
                eventData.setEventId(Constants.EventStatus.USER_ROUTE_DELETE_EVENT);
                eventData.setEventSeverity(Integer.valueOf(1));
                eventData.setEventUUID(UUID.randomUUID().toString());
                eventData.setEventMessage("User deleted from shift");
                eventData.setEventEpoch(Long.valueOf(epoch));
                eventData.setEventSource(principal.getName());
                eventData.setEventDestination(userShift2.getUserId());
                this.userService.sendNotifyToSubscriber(eventData);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("Records Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateUserShift(UserShiftModel data, Principal principal) {
        logger.debug("Updating UserShift: {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional userShiftOptional = this.userShiftRepository.findByShiftIdAndUserId(data.getShiftId(), data.getUserId());
            if (!userShiftOptional.isPresent()) {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("UserShift not found");
                returnValue.setMessageDetail("UserShift not found");
                logger.info(returnValue.getMessage());
                return returnValue;
            }
            UserShift existingShift = (UserShift)userShiftOptional.get();
            if (data.getRouteId() != null) {
                existingShift.setRouteId(data.getRouteId());
            } else if (data.getRouteId() == null && existingShift.getRouteId() == null) {
                existingShift.setRouteId(null);
            } else if (existingShift.getRouteId() != null && data.getRouteId() == null) {
                existingShift.setRouteId(existingShift.getRouteId());
            }
            if (data.getZoneId() != null) {
                existingShift.setZoneId(data.getZoneId());
            } else if (data.getZoneId() == null && existingShift.getZoneId() == null) {
                existingShift.setZoneId(null);
            } else if (existingShift.getZoneId() != null) {
                existingShift.setZoneId(existingShift.getZoneId());
            }
            UserShift userShift = (UserShift)this.userShiftRepository.save((Object)existingShift);
            try {
                if (data.getRouteId() != null) {
                    EventNotifyModel eventData = new EventNotifyModel();
                    long epoch = System.currentTimeMillis() / 1000L;
                    eventData.setReadByUser(Boolean.valueOf(false));
                    eventData.setEventId(Constants.EventStatus.USER_SHIFT_UPDATE_EVENT);
                    eventData.setEventSeverity(Integer.valueOf(1));
                    eventData.setEventUUID(UUID.randomUUID().toString());
                    eventData.setEventMessage("New Shift assigned:" + this.shiftTimeService.getShiftName(userShift.getShiftId()));
                    eventData.setEventEpoch(Long.valueOf(epoch));
                    eventData.setEventSource(principal.getName());
                    eventData.setEventDestination(userShift.getUserId());
                    if (this.routeCoordinateService.getRouteData(data.getRouteId()) != null) {
                        Route route = this.routeCoordinateService.getRouteData(data.getRouteId());
                        ShiftTime shift = this.shiftTimeService.getShiftData(data.getShiftId());
                        eventData.setEventData((Object)("route:" + route.getName() + "and shift:" + shift.getName()));
                    } else {
                        eventData.setEventData((Object)("Shift Associated:" + this.shiftTimeService.getShiftName(userShift.getShiftId()) + "and user is:" + data.getUserId()));
                    }
                    this.userService.sendNotifyToSubscriber(eventData);
                } else if (data.getZoneId() != null) {
                    EventNotifyModel eventData = new EventNotifyModel();
                    long epoch = System.currentTimeMillis() / 1000L;
                    eventData.setReadByUser(Boolean.valueOf(false));
                    eventData.setEventId(Constants.EventStatus.USER_SHIFT_UPDATE_EVENT);
                    eventData.setEventSeverity(Integer.valueOf(1));
                    eventData.setEventUUID(UUID.randomUUID().toString());
                    eventData.setEventMessage("New Shift assigned:" + this.shiftTimeService.getShiftName(userShift.getShiftId()));
                    eventData.setEventEpoch(Long.valueOf(epoch));
                    eventData.setEventSource(principal.getName());
                    eventData.setEventDestination(userShift.getUserId());
                    if (this.userZoneService.getZoneData(data.getZoneId()) != null) {
                        UserZone userZone = this.userZoneService.getZoneData(data.getZoneId());
                        ShiftTime shift = this.shiftTimeService.getShiftData(data.getShiftId());
                        eventData.setEventData((Object)("Zone: " + userZone.getName() + " and shift: " + shift.getName()));
                    } else {
                        eventData.setEventData((Object)("Shift Associated:" + this.shiftTimeService.getShiftName(userShift.getShiftId()) + "and user is:" + data.getUserId()));
                    }
                    this.userService.sendNotifyToSubscriber(eventData);
                }
            }
            catch (Exception e) {
                logger.error("Unable to send event on userShift modification:{}", (Object)e.getMessage());
            }
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Updated successfully");
            returnValue.setMessageDetail("UserShift updated successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to update UserShift");
            returnValue.setMessageDetail("Please contact the administrator");
            logger.error("Error while updating the UserShift.", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getAllUserShift() {
        List list = (List)this.userShiftRepository.findAll();
        ArrayList<UserShiftModel> userShiftModel = new ArrayList<UserShiftModel>();
        RequestResponse returnValue = new RequestResponse();
        for (UserShift userShift : list) {
            UserShiftModel model = new UserShiftModel();
            model.setId(userShift.getId());
            model.setRouteId(userShift.getRouteId());
            model.setUserId(userShift.getUserId());
            model.setShiftId(userShift.getShiftId());
            model.setUuid(userShift.getUuid());
            userShiftModel.add(model);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(userShiftModel);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getLoggedUserShift(String username, Principal principal, boolean loggedUser) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList<ShiftDetailModel> userShiftModel = new ArrayList<ShiftDetailModel>();
        List list = new ArrayList();
        String userData = username;
        String userLat = "";
        String userLong = "";
        list = loggedUser ? this.userShiftRepository.findByUserId(username) : this.userShiftRepository.findByUserId(principal.getName());
        try {
            if (!list.isEmpty()) {
                Optional userCoordinate = this.userCoordinateRepository.findByUsername(userData);
                if (userCoordinate.isPresent()) {
                    userLat = ((UserCoordinate)userCoordinate.get()).getGeoX();
                    userLong = ((UserCoordinate)userCoordinate.get()).getGeoY();
                }
                for (UserShift userShift : list) {
                    Optional userZone;
                    if (userShift.getShiftId() == null || !this.shiftTimeService.isShiftTimeValid(userShift.getShiftId())) continue;
                    ShiftDetailModel model = new ShiftDetailModel();
                    model.setId(userShift.getId());
                    model.setUserLat(userLat);
                    model.setUserLong(userLong);
                    if (userShift.getRouteId() != null) {
                        Route routeData = this.routeService.getRouteData(userShift.getRouteId());
                        ShiftTime shiftTime = this.shiftTimeService.getShiftData(userShift.getShiftId());
                        if (shiftTime != null) {
                            LocalDateTime fromDateTime = DateFormatUtility.epochToLocalDateTime((Long)shiftTime.getFromDateTime());
                            LocalDateTime toDateTime = DateFormatUtility.epochToLocalDateTime((Long)shiftTime.getToDateTime());
                            ShiftTimeModel data = new ShiftTimeModel();
                            data.setId(shiftTime.getId());
                            data.setName(shiftTime.getName());
                            data.setUuid(shiftTime.getUuid());
                            data.setFromDateTime(fromDateTime.toString());
                            data.setToDateTime(toDateTime.toString());
                            model.setShiftData(data);
                            data.setFromDate(fromDateTime.toLocalDate().toString());
                            data.setFromTime(fromDateTime.toLocalTime().toString());
                            data.setToDate(toDateTime.toLocalDate().toString());
                            data.setToTime(toDateTime.toLocalTime().toString());
                        }
                        if (routeData != null) {
                            RouteModel routeModel = new RouteModel();
                            routeModel.setId(routeData.getId());
                            routeModel.setName(routeData.getName());
                            routeModel.setDescription(routeData.getType());
                            if (routeData.getCoordinate() != null) {
                                ArrayList<CoordinateModel> coordinateModels = new ArrayList<CoordinateModel>();
                                Coordinate[] coordinateArray = routeData.getCoordinate().getCoordinates();
                                int n = coordinateArray.length;
                                for (int i = 0; i < n; ++i) {
                                    Coordinate coordinate = coordinateArray[i];
                                    CoordinateModel coordModel = new CoordinateModel();
                                    coordModel.setLongitude(String.valueOf(coordinate.x));
                                    coordModel.setLatitude(String.valueOf(coordinate.y));
                                    coordinateModels.add(coordModel);
                                }
                                routeModel.setCoordinates(coordinateModels);
                            }
                            model.setRouteData(routeModel);
                        }
                    }
                    if (userShift.getZoneId() != null && (userZone = this.userZoneRepository.findById((Object)userShift.getZoneId())).isPresent()) {
                        ZoneUserData userZoneModel = new ZoneUserData();
                        userZoneModel.setId(((UserZone)userZone.get()).getId());
                        userZoneModel.setCode(((UserZone)userZone.get()).getCode());
                        userZoneModel.setName(((UserZone)userZone.get()).getName());
                        if (((UserZone)userZone.get()).getCoordinate() != null) {
                            ArrayList<CoordinateModel> coordinateModels = new ArrayList<CoordinateModel>();
                            for (Coordinate coordinate : ((UserZone)userZone.get()).getCoordinate().getCoordinates()) {
                                CoordinateModel coordModel = new CoordinateModel();
                                coordModel.setLongitude(String.valueOf(coordinate.x));
                                coordModel.setLatitude(String.valueOf(coordinate.y));
                                coordinateModels.add(coordModel);
                            }
                            userZoneModel.setCoordinates(coordinateModels);
                        }
                        userZoneModel.setCreatedOn(DateFormatUtility.epochToLocalDateTime((Long)((UserZone)userZone.get()).getCreatedOn()));
                        userZoneModel.setDescription(((UserZone)userZone.get()).getDescription());
                        userZoneModel.setShapeId(((UserZone)userZone.get()).getType());
                        model.setZoneData(userZoneModel);
                    }
                    model.setUserId(userShift.getUserId());
                    model.setUuid(userShift.getUuid());
                    userShiftModel.add(model);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setMessageDetail("Data fetched successfully");
                returnValue.setData(userShiftModel);
            } else {
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("Selected user have no route");
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("An error occurred while retrieving user shift data.");
            logger.error("Error in getLoggedUserShift: ", (Throwable)e);
        }
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = UserShiftSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "id" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.userShiftRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.userShiftRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<UserShiftModel> entityToModelConversion(List<UserShift> lastAgent) {
        ArrayList<UserShiftModel> addValue = new ArrayList<UserShiftModel>();
        for (UserShift row : lastAgent) {
            UserShiftModel data = new UserShiftModel();
            data.setId(row.getId());
            data.setUuid(row.getUuid());
            if (row.getRouteId() != null) {
                Optional routeOptional = this.routeRepository.findById((Object)row.getRouteId());
                if (routeOptional.isPresent()) {
                    data.setRouteName(((Route)routeOptional.get()).getName());
                } else {
                    data.setRouteName(null);
                }
            }
            if (row.getShiftId() != null) {
                Optional shiftTimeOptional = this.shiftTimeRepository.findById((Object)row.getShiftId());
                if (shiftTimeOptional.isPresent()) {
                    data.setShiftName(((ShiftTime)shiftTimeOptional.get()).getName());
                } else {
                    data.setShiftName("");
                }
            }
            if (row.getZoneId() != null) {
                Optional userZone = this.userZoneRepository.findById((Object)row.getZoneId());
                if (userZone.isPresent()) {
                    data.setZoneName(((UserZone)userZone.get()).getName());
                } else {
                    data.setZoneName("");
                }
            }
            if (row.getUserId() != null) {
                data.setUserId(row.getUserId());
            }
            data.setRouteId(row.getRouteId());
            data.setShiftId(row.getShiftId());
            data.setZoneId(row.getZoneId());
            addValue.add(data);
        }
        return addValue;
    }

    public String getContactNumber(String username) {
        Optional userOptional = this.userRepository.findByUsername(username);
        if (userOptional.isPresent() && StringUtils.hasText((String)((User)userOptional.get()).getContactNo())) {
            return ((User)userOptional.get()).getContactNo();
        }
        return "";
    }

    public RequestResponse getFilterList(RouteServiceModel3 routeServiceModel) {
        RequestResponse response = new RequestResponse();
        Long fromTime = routeServiceModel.getFromDateTime() != null ? DateFormatUtility.toEpochSeconds((String)routeServiceModel.getFromDateTime()) : null;
        Long toTime = routeServiceModel.getToDateTime() != null ? DateFormatUtility.toEpochSeconds((String)routeServiceModel.getToDateTime()) : null;
        Integer routeId = routeServiceModel.getRouteId();
        String userId = routeServiceModel.getUserId();
        try {
            List shiftTimes;
            List list = shiftTimes = fromTime != null && toTime != null ? this.shiftTimeRepository.findByDateRange(fromTime, toTime) : (List)this.shiftTimeRepository.findAll();
            if (shiftTimes.isEmpty()) {
                response.setData((Object)"No records found for the given date range.");
                response.setMessage("Success");
                return response;
            }
            List shiftIds = shiftTimes.stream().map(ShiftTime::getId).collect(Collectors.toList());
            List userShifts = this.userShiftRepository.findByShiftIdIn(shiftIds);
            if (routeId != null) {
                userShifts = userShifts.stream().filter(userShift -> userShift.getRouteId().equals(routeId)).collect(Collectors.toList());
            }
            if (userId != null) {
                userShifts = userShifts.stream().filter(userShift -> userShift.getUserId().equals(userId)).collect(Collectors.toList());
            }
            Map shiftIdToModelsMap = userShifts.stream().collect(Collectors.groupingBy(UserShift::getShiftId, Collectors.mapping(userShift -> {
                RouteServiceModel2 dto = new RouteServiceModel2();
                dto.setRouteId(userShift.getRouteId());
                dto.setUserId(userShift.getUserId());
                return dto;
            }, Collectors.toList())));
            List routeServiceModels = shiftTimes.stream().filter(shiftTime -> routeId != null || userId != null ? shiftIdToModelsMap.containsKey(shiftTime.getId()) : true).map(shiftTime -> {
                RouteServiceModel model = new RouteServiceModel();
                model.setShiftId(shiftTime.getId());
                model.setFromDateTime(DateFormatUtility.fromEpochSeconds((Long)shiftTime.getFromDateTime()));
                model.setToDateTime(DateFormatUtility.fromEpochSeconds((Long)shiftTime.getToDateTime()));
                List relevantModels = shiftIdToModelsMap.getOrDefault(shiftTime.getId(), new ArrayList());
                relevantModels.forEach(dto -> dto.setShiftName(shiftTime.getName()));
                model.setRouteServiceModel2(relevantModels);
                return model;
            }).collect(Collectors.toList());
            response.setData(routeServiceModels);
            response.setMessage("Shift times retrieved successfully.");
        }
        catch (Exception e) {
            e.printStackTrace();
            response.setData((Object)"Error occurred while retrieving data.");
            response.setMessage("Failure");
        }
        return response;
    }

    public boolean getUserRouteAssociation(String username) {
        return this.userShiftRepository.existsByUserId(username);
    }

    public Object getUserShiftForRoute(String username) {
        RequestResponse response = new RequestResponse();
        List listUserShift = this.userShiftRepository.findByUserId(username);
        ArrayList<Integer> routeIds = new ArrayList<Integer>();
        for (UserShift userShift : listUserShift) {
            if (userShift.getRouteId() != null) continue;
            routeIds.add(userShift.getShiftId());
        }
        ArrayList listOfShiftTime = new ArrayList();
        for (Integer shiftId : routeIds) {
            Optional shiftTime = this.shiftTimeRepository.findById((Object)shiftId);
            shiftTime.ifPresent(listOfShiftTime::add);
        }
        response.setData(listOfShiftTime);
        return response;
    }

    public RequestResponse getUserShiftForZone(String username) {
        RequestResponse response = new RequestResponse();
        List listUserShift = this.userShiftRepository.findByUserId(username);
        ArrayList<Integer> routeIds = new ArrayList<Integer>();
        for (UserShift userShift : listUserShift) {
            if (userShift.getZoneId() != null) continue;
            routeIds.add(userShift.getShiftId());
        }
        ArrayList listOfShiftTime = new ArrayList();
        for (Integer shiftId : routeIds) {
            Optional shiftTime = this.shiftTimeRepository.findById((Object)shiftId);
            shiftTime.ifPresent(listOfShiftTime::add);
        }
        response.setData(listOfShiftTime);
        return response;
    }

    public RequestResponse unAssignZone(UserShiftModel userShiftModel) {
        RequestResponse returnValue = new RequestResponse();
        Optional userShiftOptional = this.userShiftRepository.findByShiftIdAndUserId(userShiftModel.getId(), userShiftModel.getUserId());
        if (!userShiftOptional.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("UserShift not found");
            returnValue.setMessageDetail("UserShift not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        UserShift existingShift = (UserShift)userShiftOptional.get();
        if (existingShift.getZoneId() != null) {
            existingShift.setZoneId(null);
        }
        UserShift savedUserShift = (UserShift)this.userShiftRepository.save((Object)existingShift);
        returnValue.setData((Object)savedUserShift);
        return returnValue;
    }

    public RequestResponse unAssignRoute(UserShiftModel userShiftModel) {
        RequestResponse returnValue = new RequestResponse();
        Optional userShiftOptional = this.userShiftRepository.findByShiftIdAndUserId(userShiftModel.getId(), userShiftModel.getUserId());
        if (!userShiftOptional.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("UserShift not found");
            returnValue.setMessageDetail("UserShift not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        UserShift existingShift = (UserShift)userShiftOptional.get();
        if (existingShift.getRouteId() != null) {
            existingShift.setRouteId(null);
        }
        UserShift savedUserShift = (UserShift)this.userShiftRepository.save((Object)existingShift);
        returnValue.setData((Object)savedUserShift);
        return returnValue;
    }
}

