/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.user.service;

import com.coraltele.db.users.main.entity.Role;
import com.coraltele.db.users.main.entity.User;
import com.coraltele.db.users.main.entity.UserRole;
import com.coraltele.db.users.main.repository.RoleRepository;
import com.coraltele.db.users.main.repository.UserRepository;
import com.coraltele.db.users.main.repository.UserRoleRepository;
import com.coraltele.db.users.main.specification.UserRoleSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.user.model.MultiUserRoleModel;
import com.coraltele.service.user.model.UserListNewModel;
import com.coraltele.service.user.model.UserRoleModel;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.security.Principal;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Component;

@Component
public class UserRoleService {
    private static final Logger logger = LogManager.getLogger(UserRoleService.class);
    @Autowired
    private UserRepository userRepository;
    @Autowired
    private RoleRepository roleRepository;
    @Autowired
    private UserRoleRepository userRoleRepository;

    public RequestResponse rolesAgainstUser(int userId) {
        Optional user = this.userRepository.findById(userId);
        ArrayList<UserRoleModel> returnData = new ArrayList<UserRoleModel>();
        RequestResponse returnValue = new RequestResponse();
        if (user.isPresent()) {
            List list = this.userRoleRepository.findByUser((User)user.get());
            for (UserRole userRole : list) {
                UserRoleModel data = new UserRoleModel();
                data.setId(userRole.getId().intValue());
                data.setUserId(userRole.getUser().getId().intValue());
                data.setUser(userRole.getUser().getUsername());
                data.setRoleId(userRole.getRole().getId().intValue());
                data.setRole(userRole.getRole().getDescription());
                returnData.add(data);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setData(returnData);
                logger.info(returnValue.getMessage());
            }
        } else {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Data not found ");
            returnValue.setData(returnData);
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse usersAgainstRole(int roleId) {
        Optional role = this.roleRepository.findById(roleId);
        ArrayList<UserRoleModel> returnData = new ArrayList<UserRoleModel>();
        RequestResponse returnValue = new RequestResponse();
        if (role.isPresent()) {
            List list = this.userRoleRepository.findByRole((Role)role.get());
            for (UserRole userRole : list) {
                UserRoleModel data = new UserRoleModel();
                data.setId(userRole.getId().intValue());
                data.setRoleId(userRole.getRole().getId().intValue());
                data.setRole(userRole.getRole().getDescription());
                data.setUserId(userRole.getUser().getId().intValue());
                data.setUser(userRole.getUser().getUsername());
                returnData.add(data);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("OK");
                returnValue.setData(returnData);
                logger.info(returnValue.getMessage());
            }
        } else {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Not Found");
            returnValue.setMessageDetail("Data not found ");
            returnValue.setData(returnData);
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public List<String> getRolesOfParticularUser(String username) {
        ArrayList<String> returnData = new ArrayList<String>();
        Optional user = this.userRepository.findByUsername(username);
        if (user.isPresent()) {
            List list = this.userRoleRepository.findByUser((User)user.get());
            for (UserRole userRole : list) {
                returnData.add(userRole.getRole().getDescription());
            }
        }
        return returnData;
    }

    public RequestResponse createUserRole(UserRoleModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional user = this.userRepository.findById(data.getUserId());
            Optional role = this.roleRepository.findById(data.getRoleId());
            UserRole userRole = new UserRole();
            if (user.isPresent() && role.isPresent()) {
                userRole.setUser((User)user.get());
                userRole.setRole((Role)role.get());
                userRole.setCreatedOn(LocalDateTime.now());
                userRole.setCreatedBy(principal.getName());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Unable to find user or role");
                logger.info(returnValue.getMessage());
            }
            if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
                this.userRoleRepository.save((Object)userRole);
                returnValue.setMessage("userRole registered");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setMessage("Unable to register userRole");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception ex) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Unable to register this userRole");
            returnValue.setMessageDetail("Contact to administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse createUserRoleAgent(Integer i) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional user = this.userRepository.findByUsername(String.valueOf(i));
            Optional role = this.roleRepository.findByShortCode("ROLE_AGENT");
            UserRole userRole = new UserRole();
            if (user.isPresent() && role.isPresent()) {
                userRole.setUser((User)user.get());
                userRole.setRole((Role)role.get());
                userRole.setCreatedOn(LocalDateTime.now());
                this.userRoleRepository.save((Object)userRole);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("userRole registered");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Unable to find user or role");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception ex) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Unable to register this userRole");
            returnValue.setMessageDetail("Contact to administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse deleteUserAgent(String name) {
        RequestResponse returnValue = new RequestResponse();
        try {
            Optional optionalUser = this.userRepository.findByUsername(name);
            User user = optionalUser.orElse(null);
            if (user != null) {
                List userRoles = this.userRoleRepository.findByUser(user);
                if (userRoles != null && !userRoles.isEmpty()) {
                    this.userRoleRepository.deleteAll((Iterable)userRoles);
                }
                this.userRepository.delete((Object)user);
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("deleted");
                returnValue.setMessageDetail("Record deleted successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("User not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception ex) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Something went wrong");
            returnValue.setMessageDetail("Contact with administrator");
            logger.error("An error occurred: {}", (Object)ex.getMessage(), (Object)ex);
        }
        return returnValue;
    }

    public List<Integer> roleIdOfParticularUser(String username) {
        ArrayList<Integer> returnValue = new ArrayList<Integer>();
        Optional user = this.userRepository.findByUsername(username);
        if (user.isPresent()) {
            List userRole = this.userRoleRepository.findByUser((User)user.get());
            for (UserRole userRoleTraverse : userRole) {
                returnValue.add(userRoleTraverse.getRole().getId());
            }
        }
        return returnValue;
    }

    public RequestResponse createMultipleUserRole(MultiUserRoleModel data, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        try {
            boolean roleStatus = this.validRoleList(data.getRoleId());
            boolean userStatus = this.validUserList(data.getUserId());
            if (roleStatus && userStatus) {
                for (Integer idUser : data.getUserId()) {
                    Optional userData = this.userRepository.findById((Object)idUser);
                    List deletePreviousUserRole = this.userRoleRepository.findByUser((User)userData.get());
                    this.userRoleRepository.deleteAll((Iterable)deletePreviousUserRole);
                }
                for (Integer userId : data.getUserId()) {
                    for (Integer roleId : data.getRoleId()) {
                        UserRole userRole = new UserRole();
                        userRole.setUser((User)this.getUser(userId).get());
                        userRole.setRole((Role)this.getRole(roleId).get());
                        userRole.setCreatedBy(principal.getName());
                        userRole.setCreatedOn(LocalDateTime.now());
                        this.userRoleRepository.save((Object)userRole);
                    }
                    Optional user = this.userRepository.findById((Object)userId);
                    if (!user.isPresent()) continue;
                    User userInfo = (User)user.get();
                    ObjectMapper obj = new ObjectMapper();
                    ArrayList<String> roleData = new ArrayList<String>();
                    for (Integer roleID : data.getRoleId()) {
                        Optional roleMaster = this.roleRepository.findById((Object)roleID);
                        if (!roleMaster.isPresent()) continue;
                        roleData.add(((Role)roleMaster.get()).getDescription());
                    }
                    userInfo.setRole(obj.writeValueAsString(roleData));
                    this.userRepository.save((Object)userInfo);
                }
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("userRole created successfully");
                logger.info(returnValue.getMessage());
            } else {
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("Invalid data fetched to create userRole");
                logger.error(returnValue.getMessage());
            }
            return returnValue;
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error(e.getMessage());
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Contact to administrator");
            return returnValue;
        }
    }

    public boolean validUserList(List<Integer> userIds) {
        try {
            for (Integer userId : userIds) {
                Optional user = this.userRepository.findById((Object)userId);
                if (user.isPresent()) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean validRoleList(List<Integer> roleIds) {
        try {
            for (Integer roleId : roleIds) {
                Optional role = this.roleRepository.findById((Object)roleId);
                if (role.isPresent()) continue;
                return false;
            }
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    public Optional<User> getUser(Integer id) {
        return this.userRepository.findById((Object)id);
    }

    public Optional<Role> getRole(Integer id) {
        return this.roleRepository.findById((Object)id);
    }

    public RequestResponse getAllUserRoleByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = UserRoleSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.sortDirection.equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).ascending();
        } else if (searchRequestData.sortDirection.equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.sortBy}).descending();
        }
        Page page = null;
        page = sort == null ? this.userRoleRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.userRoleRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityTRoleModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<UserRoleModel> entityTRoleModelConversion(List<UserRole> userRole) {
        ArrayList<UserRoleModel> addValue = new ArrayList<UserRoleModel>();
        for (UserRole row : userRole) {
            UserRoleModel data = new UserRoleModel();
            data.setId(row.getId().intValue());
            data.setRoleId(row.getRole().getId().intValue());
            data.setUserId(row.getUser().getId().intValue());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse deleteUserRole(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            for (Integer ids : data.getIntId()) {
                Optional userRole = this.userRoleRepository.findById((Object)ids);
                if (userRole.isPresent()) {
                    this.userRoleRepository.deleteById((Object)ids);
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("deleted");
                    returnValue.setMessageDetail("Record deleted successfully");
                    logger.info(returnValue.getMessage());
                    continue;
                }
                returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
                returnValue.setMessage("not found");
                returnValue.setMessageDetail("Records not found");
                logger.info(returnValue.getMessage());
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.UNKNOWN_ERROR);
            returnValue.setMessage("Unable to delete userRole");
            returnValue.setMessageDetail("please Contact to administrator");
            logger.info(returnValue.getMessage());
        }
        return returnValue;
    }

    public RequestResponse getAllTaskManager() {
        List list = (List)this.userRoleRepository.findAll();
        ArrayList<UserRoleModel> addValue = new ArrayList<UserRoleModel>();
        RequestResponse returnValue = new RequestResponse();
        Optional optionalRole = this.roleRepository.findByShortCode("ROLE_TASKMANAGER");
        if (!optionalRole.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Role 'ROLE_TASKMANAGER' not found.");
            logger.error("Role 'ROLE_TASKMANAGER' not found.");
            return returnValue;
        }
        Role taskManagerRole = (Role)optionalRole.get();
        for (UserRole row : list) {
            if (!taskManagerRole.getId().equals(row.getRole().getId())) continue;
            UserRoleModel data = new UserRoleModel();
            data.setUser(row.getUser().getUsername());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK, found " + addValue.size() + " Task Managers.");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllUserRole() {
        List list = (List)this.userRoleRepository.findAll();
        ArrayList<UserRoleModel> addValue = new ArrayList<UserRoleModel>();
        RequestResponse returnValue = new RequestResponse();
        Optional optionalTaskUserRole = this.roleRepository.findByShortCode("ROLE_TASKUSER");
        Optional optionalAdminRole = this.roleRepository.findByShortCode("ROLE_ENGINEER");
        if (!optionalTaskUserRole.isPresent() && !optionalAdminRole.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Roles 'ROLE_TASKUSER' and 'ROLE_ENGINEER' not found.");
            logger.error("Roles 'ROLE_TASKUSER' and 'ROLE_ADMIN' not found.");
            return returnValue;
        }
        Role taskUserRole = optionalTaskUserRole.orElse(null);
        Role adminRole = optionalAdminRole.orElse(null);
        for (UserRole row : list) {
            if ((taskUserRole == null || !taskUserRole.getId().equals(row.getRole().getId())) && (adminRole == null || !adminRole.getId().equals(row.getRole().getId()))) continue;
            UserRoleModel data = new UserRoleModel();
            data.setUser(row.getUser().getUsername());
            addValue.add(data);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK, found " + addValue.size() + " Users");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllUsersExcludingRoleAdmin() {
        RequestResponse response = new RequestResponse();
        Optional roleOptional = this.roleRepository.findByShortCode("ROLE_ADMIN");
        if (!roleOptional.isPresent()) {
            throw new RuntimeException("ROLE_ADMIN not found");
        }
        Role adminRole = (Role)roleOptional.get();
        List userRolesWithAdmin = this.userRoleRepository.findByRole(adminRole);
        List userIdsWithAdminRole = userRolesWithAdmin.stream().map(userRole -> userRole.getUser().getId()).collect(Collectors.toList());
        List allUsers = (List)this.userRepository.findAll();
        List filteredUsers = allUsers.stream().filter(user -> !userIdsWithAdminRole.contains(user.getId())).collect(Collectors.toList());
        List wrappedUsernames = filteredUsers.stream().map(user -> new UserListNewModel(user.getUsername())).collect(Collectors.toList());
        response.setStatus(Constants.Error.OK);
        response.setMessage("Retrieved users");
        response.setMessageDetail("User Retrieved");
        response.setData(wrappedUsernames);
        return response;
    }
}

