/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.queuePerformance.service;

import com.coraltele.db.telemetry.main.entity.AgentCDR;
import com.coraltele.db.telemetry.main.entity.QueuePerformance;
import com.coraltele.db.telemetry.main.repository.AgentCDRRepository;
import com.coraltele.db.telemetry.main.repository.QueuePerformanceRepository;
import com.coraltele.db.telemetry.main.specification.QueuePerformanceSpecification;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.coralApps.callcenter.queueTL.service.QueueTLService;
import com.coraltele.service.telemetry.main.queuePerformance.model.QueuePerformanceSummaryModel;
import com.coraltele.service.user.service.UserService;
import java.security.Principal;
import java.time.Instant;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class QueuePerformanceSummaryService {
    private static final Logger logger = LogManager.getLogger(QueuePerformanceSummaryService.class);
    @Autowired
    QueuePerformanceRepository queuePerformanceRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    UserService userService;
    @Autowired
    QueueTLService queueTLService;
    @Autowired
    AgentCDRRepository agentCDRRepository;

    public RequestResponse getAllByFilterForSummation(SearchRequest searchRequestData, Principal principal) {
        RequestResponse returnValue = new RequestResponse();
        List queueId = null;
        if (this.userService.checkRoleTL(principal.getName())) {
            queueId = this.queueTLService.getQueueListByTeamLeader(principal.getName());
        }
        Specification filters = QueuePerformanceSpecification.generateFilters((SearchRequest)searchRequestData, queueId);
        Sort sort = "asc".equalsIgnoreCase(searchRequestData.getSortDirection()) ? Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "queueName" : searchRequestData.getSortBy()}).ascending() : ("desc".equalsIgnoreCase(searchRequestData.getSortDirection()) ? Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "queueName" : searchRequestData.getSortBy()}).descending() : Sort.by((String[])new String[]{searchRequestData.getSortBy() == null || searchRequestData.getSortBy().isEmpty() ? "queueName" : searchRequestData.getSortBy()}).ascending());
        List allFilteredData = this.queuePerformanceRepository.findAll(filters, sort);
        List allUniqueRecords = this.entityToModelConversion(allFilteredData, searchRequestData.getSortDirection(), searchRequestData.getSortBy());
        int totalUniqueRecords = allUniqueRecords.size();
        int pageSize = searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize();
        int currentPage = searchRequestData.getCurrentPage();
        int startItem = currentPage * pageSize;
        int toIndex = Math.min(startItem + pageSize, totalUniqueRecords);
        List paginatedList = startItem < totalUniqueRecords ? allUniqueRecords.subList(startItem, toIndex) : new ArrayList();
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(currentPage > totalUniqueRecords / pageSize ? 0L : (long)currentPage);
        responseData.setPageSize((long)pageSize);
        responseData.setTotalPages((long)((int)Math.ceil((double)totalUniqueRecords / (double)pageSize)));
        responseData.setTotalRecords((long)totalUniqueRecords);
        responseData.setCurrentPageData(paginatedList);
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<QueuePerformanceSummaryModel> entityToModelConversion(List<QueuePerformance> queuePerformance, String direction, String sortBy) {
        Map agentCountByDateMap = this.getAgentCountMapByDate();
        HashMap<String, QueuePerformanceSummaryModel> summaryMap = new HashMap<String, QueuePerformanceSummaryModel>();
        for (QueuePerformance row : queuePerformance) {
            String queue = row.getQueue();
            String callDirection = row.getCallDirection();
            String compositeKey = queue + "|" + callDirection;
            String dateKey = row.getRecordEpoch() != null ? Instant.ofEpochSecond(row.getRecordEpoch()).atZone(ZoneId.systemDefault()).toLocalDate().toString() + "|" + queue + "|" + callDirection : "";
            QueuePerformanceSummaryModel data = summaryMap.getOrDefault(compositeKey, new QueuePerformanceSummaryModel());
            int prevAgentSum = data.getAverageNumberAgent() != null ? data.getAverageNumberAgent() : 0;
            int currentAgent = agentCountByDateMap.getOrDefault(dateKey, 0);
            data.setAverageNumberAgent(Integer.valueOf(prevAgentSum + currentAgent));
            data.setQueue(queue);
            data.setCallDirection(callDirection);
            data.setQueueName(row.getQueueName());
            data.setRecordEpoch(this.dateFormatUtility.epochToLocalDateForLocalTimeZone(row.getRecordEpoch()));
            int totalAbdAtAgent = (data.getTotalAbandonedAtAgent() != null ? data.getTotalAbandonedAtAgent() : 0) + (row.getTotalAbandonedAtAgent() != null ? row.getTotalAbandonedAtAgent() : 0);
            int totalAbdAtQueue = (data.getTotalAbandonedAtQueue() != null ? data.getTotalAbandonedAtQueue() : 0) + (row.getTotalAbandonedAtQueue() != null ? row.getTotalAbandonedAtQueue() : 0);
            int totalConnectedWithAgent = (data.getTotalConnectedWithAgent() != null ? data.getTotalConnectedWithAgent() : 0) + (row.getTotalConnectedWithAgent() != null ? row.getTotalConnectedWithAgent() : 0);
            int totalJoined = (data.getTotalJoined() != null ? data.getTotalJoined() : 0) + (row.getTotalJoined() != null ? row.getTotalJoined() : 0);
            long totalCustomerAgentTalkTimeSeconds = this.getDurationInSeconds(data.getTotalCustomerAgentTalkTime()) + this.getDurationInSeconds(DateFormatUtility.findLocalTime((Long)this.getDurationOrZero(row.getTotalCustomerAgentTalkTime())));
            long totalCustomerTimeSeconds = this.getDurationInSeconds(data.getTotalCustomerTime()) + this.getDurationInSeconds(DateFormatUtility.findLocalTime((Long)this.getDurationOrZero(row.getTotalCustomerTime())));
            long waitTime1 = this.toLong(data.getTotalWaitTime());
            long waitTime2 = this.toLong((Object)row.getTotalWaitTime());
            long totalWaitTime = waitTime1 + waitTime2;
            Long abdWaitTime1 = this.toLong(data.getTotalAbandonedWaitTime());
            Long abdWaitTime2 = this.toLong((Object)row.getTotalAbandonedWaitTime());
            long totalAbdWaitTime = abdWaitTime1 + abdWaitTime2;
            long avgTalkTime = totalConnectedWithAgent != 0 ? totalCustomerAgentTalkTimeSeconds / (long)totalConnectedWithAgent : 0L;
            long avgAnsWaitTime = totalConnectedWithAgent != 0 ? totalWaitTime / (long)totalConnectedWithAgent : 0L;
            double svcPercentage = totalJoined != 0 ? (double)Math.round((double)totalConnectedWithAgent * 100.0 / (double)totalJoined * 100.0) / 100.0 : 0.0;
            double abdPercentage = totalJoined != 0 ? (double)Math.round((double)(totalAbdAtAgent + totalAbdAtQueue) * 100.0 / (double)totalJoined * 100.0) / 100.0 : 0.0;
            long avgAbdWaitTime = totalAbdAtAgent + totalAbdAtQueue != 0 ? totalAbdWaitTime / (long)(totalAbdAtAgent + totalAbdAtQueue) : 0L;
            data.setTotalAbandonedAtAgent(Integer.valueOf(totalAbdAtAgent));
            data.setTotalAbandonedAtQueue(Integer.valueOf(totalAbdAtQueue));
            data.setTotalConnectedWithAgent(Integer.valueOf(totalConnectedWithAgent));
            data.setAnswerWaitSecond10(Integer.valueOf((data.getAnswerWaitSecond10() != null ? data.getAnswerWaitSecond10() : 0) + (row.getAnswerWaitSecond10() != null ? row.getAnswerWaitSecond10() : 0)));
            data.setAnswerWaitSecond20(Integer.valueOf((data.getAnswerWaitSecond20() != null ? data.getAnswerWaitSecond20() : 0) + (row.getAnswerWaitSecond20() != null ? row.getAnswerWaitSecond20() : 0)));
            data.setAnswerWaitSecond30(Integer.valueOf((data.getAnswerWaitSecond30() != null ? data.getAnswerWaitSecond30() : 0) + (row.getAnswerWaitSecond30() != null ? row.getAnswerWaitSecond30() : 0)));
            data.setAnswerWaitSecond40(Integer.valueOf((data.getAnswerWaitSecond40() != null ? data.getAnswerWaitSecond40() : 0) + (row.getAnswerWaitSecond40() != null ? row.getAnswerWaitSecond40() : 0)));
            data.setAnswerWaitSecond50(Integer.valueOf((data.getAnswerWaitSecond50() != null ? data.getAnswerWaitSecond50() : 0) + (row.getAnswerWaitSecond50() != null ? row.getAnswerWaitSecond50() : 0)));
            data.setAnswerWaitSecond60(Integer.valueOf((data.getAnswerWaitSecond60() != null ? data.getAnswerWaitSecond60() : 0) + (row.getAnswerWaitSecond60() != null ? row.getAnswerWaitSecond60() : 0)));
            data.setGreaterAnswerWaitSecond60(Integer.valueOf((data.getGreaterAnswerWaitSecond60() != null ? data.getGreaterAnswerWaitSecond60() : 0) + (row.getGreaterAnswerWaitSecond60() != null ? row.getGreaterAnswerWaitSecond60() : 0)));
            data.setAbandonedWaitSecond10(Integer.valueOf((data.getAbandonedWaitSecond10() != null ? data.getAbandonedWaitSecond10() : 0) + (row.getAbandonedWaitSecond10() != null ? row.getAbandonedWaitSecond10() : 0)));
            data.setAbandonedWaitSecond20(Integer.valueOf((data.getAbandonedWaitSecond20() != null ? data.getAbandonedWaitSecond20() : 0) + (row.getAbandonedWaitSecond20() != null ? row.getAbandonedWaitSecond20() : 0)));
            data.setAbandonedWaitSecond30(Integer.valueOf((data.getAbandonedWaitSecond30() != null ? data.getAbandonedWaitSecond30() : 0) + (row.getAbandonedWaitSecond30() != null ? row.getAbandonedWaitSecond30() : 0)));
            data.setAbandonedWaitSecond40(Integer.valueOf((data.getAbandonedWaitSecond40() != null ? data.getAbandonedWaitSecond40() : 0) + (row.getAbandonedWaitSecond40() != null ? row.getAbandonedWaitSecond40() : 0)));
            data.setAbandonedWaitSecond50(Integer.valueOf((data.getAbandonedWaitSecond50() != null ? data.getAbandonedWaitSecond50() : 0) + (row.getAbandonedWaitSecond50() != null ? row.getAbandonedWaitSecond50() : 0)));
            data.setAbandonedWaitSecond60(Integer.valueOf((data.getAbandonedWaitSecond60() != null ? data.getAbandonedWaitSecond60() : 0) + (row.getAbandonedWaitSecond60() != null ? row.getAbandonedWaitSecond60() : 0)));
            data.setGreaterAbandonedWaitSecond60(Integer.valueOf((data.getGreaterAbandonedWaitSecond60() != null ? data.getGreaterAbandonedWaitSecond60() : 0) + (row.getGreaterAbandonedWaitSecond60() != null ? row.getGreaterAbandonedWaitSecond60() : 0)));
            data.setTotalAbandonedWaitTime((Object)DateFormatUtility.findLocalTime((Long)totalAbdWaitTime));
            Long answerWaitTime1 = this.toLong(data.getTotalAnswerWaitTime());
            Long answerWaitTime2 = this.toLong((Object)row.getTotalAnswerWaitTime());
            long totalAnsWaitTime = answerWaitTime1 + answerWaitTime2;
            data.setTotalAnswerWaitTime((Object)DateFormatUtility.findLocalTime((Long)totalAnsWaitTime));
            data.setServicePercentage(Double.valueOf((data.getServicePercentage() != null ? data.getServicePercentage() : 0.0) + (row.getServicePercentage() != null ? row.getServicePercentage() : 0.0)));
            data.setAbandonedPercentage(Double.valueOf((data.getAbandonedPercentage() != null ? data.getAbandonedPercentage() : 0.0) + (row.getAbandonedPercentage() != null ? row.getAbandonedPercentage() : 0.0)));
            data.setTotalCustomerAgentTalkTime(DateFormatUtility.findLocalTime((Long)totalCustomerAgentTalkTimeSeconds));
            data.setTotalCustomerTime(DateFormatUtility.findLocalTime((Long)totalCustomerTimeSeconds));
            data.setTotalJoined(Integer.valueOf(totalJoined));
            data.setTotalNoContact(Integer.valueOf((data.getTotalNoContact() != null ? data.getTotalNoContact() : 0) + (row.getTotalNoContact() != null ? row.getTotalNoContact() : 0)));
            data.setTotalWaitTime((Object)DateFormatUtility.findLocalTime((Long)totalWaitTime));
            data.setAverageAbandonedWaitTime(DateFormatUtility.findLocalTime((Long)avgAbdWaitTime));
            data.setAverageTalkTime(DateFormatUtility.findLocalTime((Long)avgTalkTime));
            data.setAverageAnswerWaitTime(DateFormatUtility.findLocalTime((Long)avgAnsWaitTime));
            data.setServicePercentage(Double.valueOf(svcPercentage));
            data.setAbandonedPercentage(Double.valueOf(abdPercentage));
            summaryMap.put(compositeKey, data);
        }
        ArrayList<QueuePerformanceSummaryModel> resultList = new ArrayList<QueuePerformanceSummaryModel>(summaryMap.values());
        if (sortBy != null && !sortBy.isEmpty()) {
            Comparator<QueuePerformanceSummaryModel> comparator;
            switch (sortBy) {
                case "callDirection": {
                    comparator = Comparator.comparing(QueuePerformanceSummaryModel::getCallDirection, Comparator.nullsLast(String::compareToIgnoreCase));
                    break;
                }
                case "queueName": {
                    comparator = Comparator.comparing(QueuePerformanceSummaryModel::getQueueName, Comparator.nullsLast(String::compareToIgnoreCase));
                    break;
                }
                default: {
                    comparator = Comparator.comparing(QueuePerformanceSummaryModel::getQueue, Comparator.nullsLast(String::compareToIgnoreCase));
                }
            }
            if ("desc".equalsIgnoreCase(direction)) {
                comparator = comparator.reversed();
            }
            resultList.sort(comparator);
        } else {
            resultList.sort(Comparator.comparing(QueuePerformanceSummaryModel::getQueue, Comparator.nullsLast(String::compareToIgnoreCase)));
        }
        return resultList;
    }

    private long getDurationOrZero(Long duration) {
        return duration != null ? duration : 0L;
    }

    private long getDurationInSeconds(String duration) {
        if (duration == null || duration.isEmpty()) {
            return 0L;
        }
        String[] parts = duration.split(":");
        long hours = Long.parseLong(parts[0]);
        long minutes = Long.parseLong(parts[1]);
        long seconds = Long.parseLong(parts[2]);
        return hours * 3600L + minutes * 60L + seconds;
    }

    private long toLong(Object obj) {
        if (obj instanceof Number) {
            return ((Number)obj).longValue();
        }
        if (obj instanceof String) {
            try {
                return Long.parseLong((String)obj);
            }
            catch (NumberFormatException e) {
                return 0L;
            }
        }
        return 0L;
    }

    private Map<String, Integer> getAgentCountMapByDate() {
        List allAgentCDRs = (List)this.agentCDRRepository.findAll();
        HashMap<String, Set> groupedAgents = new HashMap<String, Set>();
        for (AgentCDR cdr : allAgentCDRs) {
            if (cdr.getStartTime() == null || cdr.getQueue() == null || cdr.getCallDirection() == null || cdr.getAgentName() == null) continue;
            LocalDate date = Instant.ofEpochSecond(cdr.getStartTime()).atZone(ZoneId.systemDefault()).toLocalDate();
            String key = date.toString() + "|" + cdr.getQueue() + "|" + cdr.getCallDirection();
            groupedAgents.computeIfAbsent(key, k -> new HashSet()).add(cdr.getAgentName());
        }
        HashMap<String, Integer> result = new HashMap<String, Integer>();
        for (Map.Entry entry : groupedAgents.entrySet()) {
            result.put((String)entry.getKey(), ((Set)entry.getValue()).size());
        }
        return result;
    }
}

