/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.alertHistory.service;

import com.coraltele.db.telemetry.main.entity.view.AlertHistoryView;
import com.coraltele.db.telemetry.main.repository.AlertHistoryViewRepository;
import com.coraltele.db.telemetry.main.specification.AlertHistoryViewSpecification;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.alertHistory.model.AlertHistoryViewModel;
import java.util.ArrayList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class AlertHistoryViewService {
    private static final Logger logger = LogManager.getLogger(AlertHistoryViewService.class);
    @Autowired
    AlertHistoryViewRepository alertHistoryViewRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;

    public RequestResponse getAllAlertHistory(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = AlertHistoryViewSpecification.generateFilters((SearchRequest)searchRequestData, (Boolean)false);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "alertGeneratedOn" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "alertGeneratedOn" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.alertHistoryViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.alertHistoryViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<AlertHistoryViewModel> entityToModelConversion(List<AlertHistoryView> alertHistoryViews) {
        ArrayList<AlertHistoryViewModel> addValue = new ArrayList<AlertHistoryViewModel>();
        for (AlertHistoryView row : alertHistoryViews) {
            AlertHistoryViewModel data = new AlertHistoryViewModel();
            data.setId(row.getId());
            if (row.getAlertClosedOn() != null) {
                data.setAlertClosedOn(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getAlertClosedOn()));
            }
            if (row.getAlertGeneratedOn() != null) {
                data.setAlertGeneratedOn(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getAlertGeneratedOn()));
            }
            data.setAssetId(row.getAssetId());
            data.setAssetName(row.getAssetName());
            data.setCategory(row.getCategory());
            data.setCategoryCode(row.getCategoryCode());
            data.setIpAddress(row.getIpAddress());
            data.setName(row.getName());
            data.setServiceCode(row.getServiceCode());
            data.setSeverity(row.getSeverity());
            data.setSeverityName(row.getSeverityName());
            data.setStatus(row.getStatus());
            data.setAlias(row.getAlias());
            addValue.add(data);
        }
        return addValue;
    }

    public RequestResponse getCriticalAlert(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = AlertHistoryViewSpecification.generateFilters((SearchRequest)searchRequestData, (Boolean)true);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "alertGeneratedOn" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "alertGeneratedOn" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.alertHistoryViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.alertHistoryViewRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

