/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.acdSummary.service;

import com.coraltele.db.telemetry.main.entity.ACDSummary;
import com.coraltele.db.telemetry.main.entity.OperatorDailyBreakTime;
import com.coraltele.db.telemetry.main.repository.ACDSummaryRepository;
import com.coraltele.db.telemetry.main.repository.OperatorDailyBreakTimeRepository;
import com.coraltele.db.telemetry.main.specification.ACDSummarySpecification;
import com.coraltele.helper.DateFormatUtility;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.telemetry.main.acdSummary.model.ACDSummaryModel;
import java.time.Duration;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class ACDSummaryService {
    private static final Logger logger = LogManager.getLogger(ACDSummaryService.class);
    @Autowired
    ACDSummaryRepository acdSummaryRepository;
    @Autowired
    DateFormatUtility dateFormatUtility;
    @Autowired
    OperatorDailyBreakTimeRepository operatorDailyBreakTimeRepository;

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ACDSummarySpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "recordEpoch" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "recordEpoch" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.acdSummaryRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.acdSummaryRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<ACDSummaryModel> entityToModelConversion(List<ACDSummary> acd) {
        ArrayList<ACDSummaryModel> addValue = new ArrayList<ACDSummaryModel>();
        for (ACDSummary row : acd) {
            ACDSummaryModel data = new ACDSummaryModel();
            data.setAgentFullName(row.getAgentFullName());
            data.setRecordEpoch(DateFormatUtility.epochToLocalDateTimeAsStringForSecond((Long)row.getRecordEpoch()));
            data.setTotalCalls(row.getTotalCalls());
            data.setTotalConnectedWithAgentIncoming(row.getTotalConnectedWithAgentIncoming());
            data.setTotalConnectedWithAgentOutgoing(row.getTotalConnectedWithAgentOutgoing());
            data.setTotalCustomerAgentTalkTime(DateFormatUtility.findLocalTime((Long)row.getTotalCustomerAgentTalkTime()));
            data.setTotalDialed(row.getTotalDialed());
            data.setTotalNoContact(row.getTotalNoContact());
            Optional statusOptional = this.operatorDailyBreakTimeRepository.findByAgentNameAndQueueAndRecordEpoch(row.getAgentName(), row.getQueue(), row.getRecordEpoch());
            Duration totalBreakDuration = Duration.ofSeconds(this.getDurationOrZero(row.getTotalBreakDuration()));
            if (statusOptional.isPresent() && ((OperatorDailyBreakTime)statusOptional.get()).getStatus().equalsIgnoreCase("On Break")) {
                Duration time = Duration.between(DateFormatUtility.epochToLocalDateTime((Long)row.getBreakTimeEpoch()), LocalDateTime.now());
                totalBreakDuration = totalBreakDuration.plus(time);
            }
            data.setBreakDuration(DateFormatUtility.findLocalTime((Long)totalBreakDuration.getSeconds()));
            addValue.add(data);
        }
        return addValue;
    }

    private long getDurationOrZero(Long duration) {
        return duration != null ? duration : 0L;
    }
}

