/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.main.ExtensionSummary.service;

import com.coraltele.db.billing.main.entity.PdfReportFilters;
import com.coraltele.db.billing.main.repository.PdfReportRepository;
import com.coraltele.db.telemetry.main.repository.BillingCDRRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.PdfPageNumberEvent;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.AdvanceFilter;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.background.PdfGeneratorService;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.itextpdf.text.BaseColor;
import com.itextpdf.text.Document;
import com.itextpdf.text.DocumentException;
import com.itextpdf.text.Element;
import com.itextpdf.text.Font;
import com.itextpdf.text.Image;
import com.itextpdf.text.PageSize;
import com.itextpdf.text.Paragraph;
import com.itextpdf.text.Phrase;
import com.itextpdf.text.pdf.PdfPCell;
import com.itextpdf.text.pdf.PdfPTable;
import com.itextpdf.text.pdf.PdfPageEvent;
import com.itextpdf.text.pdf.PdfWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.Principal;
import java.text.NumberFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="OutBoundExtensionSummaryPdf")
public class OutBoundExtensionSummaryPdf
implements PdfGeneratorService {
    private static final Logger logger = LogManager.getLogger(OutBoundExtensionSummaryPdf.class);
    private static Font COURIER = new Font(Font.FontFamily.COURIER, 20.0f, 1);
    private static Font COURIER_SMALL = new Font(Font.FontFamily.COURIER, 14.0f, 1);
    private static final String TITLE = "Outbound Extension Summary";
    private static final String LOGO = "/var/www/html/apple-icon.png";
    private static final String DTF = "dd-MM-yyyy hh:mm:ss a";
    @Autowired
    BillingCDRRepository repo;
    @Autowired
    PdfReportRepository pdfRepo;
    @Autowired
    PdfPageNumberEvent footer;
    private LocalDateTime now;
    private static final NumberFormat INR = NumberFormat.getCurrencyInstance(new Locale("en", "IN"));

    private String formatINR(Double amount) {
        if (amount == null) {
            return "\u20b90.00";
        }
        amount = amount / 100.0;
        return INR.format(amount);
    }

    public RequestResponse generatePdfReport(SearchRequest req, String filePath, Principal p) {
        RequestResponse res = new RequestResponse();
        this.now = LocalDateTime.now();
        this.initFooter();
        try {
            List cols = this.resolveColumns(req);
            List rows = this.fetchDB(req);
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            Document doc = cols.size() > 5 ? new Document(PageSize.A3.rotate()) : new Document(PageSize.A4);
            PdfWriter writer = PdfWriter.getInstance((Document)doc, (OutputStream)baos);
            writer.setPageEvent((PdfPageEvent)this.footer);
            doc.open();
            this.addLogoAndDocTitle(doc, req, Integer.valueOf(cols.size()));
            doc.newPage();
            this.addStyledTable(doc, cols, rows);
            doc.close();
            this.writeFile(filePath, baos.toByteArray());
            res.setStatus(Constants.Error.OK);
            res.setMessage("PDF generated");
            res.setData((Object)filePath);
        }
        catch (Exception e) {
            e.printStackTrace();
            res.setStatus(Constants.Error.ERROR);
            res.setMessage("PDF generation failed");
        }
        return res;
    }

    private void addLogoAndDocTitle(Document document, SearchRequest filterRequest, Integer columns) {
        try {
            logger.info("finding logo from location");
            PdfPTable table = new PdfPTable(1);
            table.setWidthPercentage(100.0f);
            PdfPCell logoCell = new PdfPCell();
            logoCell.setHorizontalAlignment(1);
            logoCell.setBorder(0);
            Image img = Image.getInstance((String)LOGO);
            if (columns > 5) {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.5f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            } else {
                img.scaleAbsolute(document.getPageSize().getWidth() * 0.7f, document.getPageSize().getHeight() * 0.4f);
                img.setAlignment(1);
                logoCell.addElement((Element)img);
            }
            PdfPCell reportNameCell = new PdfPCell();
            reportNameCell.setHorizontalAlignment(1);
            reportNameCell.setBorder(0);
            Paragraph p1 = new Paragraph(TITLE, COURIER);
            reportNameCell.addElement((Element)p1);
            PdfPCell dateTimeCell = new PdfPCell();
            dateTimeCell.setHorizontalAlignment(1);
            dateTimeCell.setBorder(0);
            String localDateString = this.now.format(DateTimeFormatter.ofPattern(DTF));
            Paragraph p2 = new Paragraph("Report generated on " + localDateString, COURIER_SMALL);
            dateTimeCell.addElement((Element)p2);
            table.addCell(logoCell);
            table.addCell(reportNameCell);
            table.addCell(dateTimeCell);
            document.add((Element)table);
            logger.info("successfully found logo for pdf");
        }
        catch (DocumentException | IOException e) {
            e.printStackTrace();
            logger.error(e.getMessage());
        }
    }

    private void addStyledTable(Document doc, List<String> cols, List<Object[]> rows) throws Exception {
        PdfPTable t = new PdfPTable(cols.size());
        t.setWidthPercentage(100.0f);
        BaseColor headerBlue = new BaseColor(2, 111, 194);
        BaseColor altGrey = new BaseColor(230, 230, 230);
        for (String c : cols) {
            PdfPCell h = new PdfPCell(new Phrase(this.mapCol(c), new Font(Font.FontFamily.HELVETICA, 12.0f, 1, BaseColor.WHITE)));
            h.setHorizontalAlignment(1);
            h.setVerticalAlignment(5);
            h.setBackgroundColor(headerBlue);
            h.setBorder(0);
            h.setPadding(8.0f);
            t.addCell(h);
        }
        t.setHeaderRows(1);
        if (rows == null || rows.isEmpty()) {
            PdfPCell cell = new PdfPCell(new Phrase("No Records Found"));
            cell.setColspan(cols.size());
            cell.setHorizontalAlignment(1);
            cell.setBorder(0);
            t.addCell(cell);
        } else {
            int rowIndex = 0;
            for (Object[] r : rows) {
                HashMap<String, String> m = new HashMap<String, String>();
                m.put("callerId", this.safe(r[0]));
                m.put("intercomCall", this.safe(r[1]));
                m.put("intercomCost", this.formatINR(Double.valueOf(this.toD(r[2]))));
                m.put("localCall", this.safe(r[3]));
                m.put("localCost", this.formatINR(Double.valueOf(this.toD(r[4]))));
                m.put("stdCall", this.safe(r[5]));
                m.put("stdCost", this.formatINR(Double.valueOf(this.toD(r[6]))));
                m.put("isdCall", this.safe(r[7]));
                m.put("isdCost", this.formatINR(Double.valueOf(this.toD(r[8]))));
                m.put("totalCall", this.safe(r[9]));
                m.put("totalCost", this.formatINR(Double.valueOf(this.toD(r[10]))));
                BaseColor bg = rowIndex % 2 == 0 ? BaseColor.WHITE : altGrey;
                for (String c : cols) {
                    PdfPCell cell = new PdfPCell(new Phrase((String)m.get(c)));
                    cell.setHorizontalAlignment(1);
                    cell.setVerticalAlignment(5);
                    cell.setBackgroundColor(bg);
                    cell.setBorder(0);
                    cell.setPadding(6.0f);
                    t.addCell(cell);
                }
                ++rowIndex;
            }
        }
        doc.add((Element)t);
    }

    private String safe(Object v) {
        return v == null ? "" : v.toString();
    }

    private double toD(Object o) {
        return o == null ? 0.0 : ((Number)o).doubleValue();
    }

    private List<String> resolveColumns(SearchRequest r) {
        if (r.getColumnNames() == null || r.getColumnNames().isEmpty()) {
            return Arrays.asList("callerId", "intercomCall", "intercomCost", "localCall", "localCost", "stdCall", "stdCost", "isdCall", "isdCost", "totalCall", "totalCost");
        }
        return r.getColumnNames();
    }

    private String mapCol(String k) {
        switch (k) {
            case "callerId": {
                return "Extension No";
            }
            case "intercomCall": {
                return "Intercom Calls";
            }
            case "intercomCost": {
                return "Intercom Cost";
            }
            case "localCall": {
                return "Local Calls";
            }
            case "localCost": {
                return "Local Cost";
            }
            case "stdCall": {
                return "STD Calls";
            }
            case "stdCost": {
                return "STD Cost";
            }
            case "isdCall": {
                return "ISD Calls";
            }
            case "isdCost": {
                return "ISD Cost";
            }
            case "totalCall": {
                return "Total Calls";
            }
            case "totalCost": {
                return "Total Cost";
            }
        }
        return k;
    }

    private void initFooter() {
        try {
            this.footer.initialize(LOGO, TITLE, DTF, this.now);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void writeFile(String path, byte[] data) throws Exception {
        try (FileOutputStream fos = new FileOutputStream(path);){
            fos.write(data);
        }
    }

    private List<Object[]> fetchDB(SearchRequest req) {
        LocalDate from = null;
        LocalDate to = null;
        String search = req.getSearch();
        String callerId = null;
        if (search != null && search.trim().isEmpty()) {
            search = null;
        }
        if (req.getAdvancedFilters() != null) {
            for (AdvanceFilter f : req.getAdvancedFilters()) {
                if ("callerId".equalsIgnoreCase(f.getFieldName())) {
                    callerId = f.getValue();
                }
                if (!"date".equalsIgnoreCase(f.getDataType()) || !"callDate".equalsIgnoreCase(f.getFieldName())) continue;
                if ("from".equalsIgnoreCase(f.getDirection())) {
                    from = this.parseDate(f.getValue());
                }
                if (!"to".equalsIgnoreCase(f.getDirection())) continue;
                to = this.parseDate(f.getValue());
            }
        }
        return "desc".equalsIgnoreCase(req.getSortDirection()) ? this.repo.getCallerSummary(from, to, callerId, search) : this.repo.getCallerSummary(from, to, callerId, search);
    }

    private LocalDate parseDate(String v) {
        try {
            return v == null || v.trim().isEmpty() ? null : LocalDate.parse(v);
        }
        catch (Exception e) {
            return null;
        }
    }

    public void createPdfReportRecord(String id, SearchRequest d, String fp) {
        try {
            PdfReportFilters f = new PdfReportFilters();
            f.setId(id);
            f.setReportName(TITLE);
            f.setPdfLocation(fp);
            f.setCreatedOnDate(this.now);
            f.setStatus("InProgress");
            f.setFilterParameters(new ObjectMapper().writeValueAsString((Object)d));
            this.pdfRepo.save((Object)f);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

