/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.telemetry.coralnms.locationType.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.telemetry.coralnms.locationType.model.LocationTypeModel;
import com.coraltele.service.telemetry.coralnms.locationType.service.LocationTypeService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/locationType"})
@RestController
public class LocationTypeController {
    @Autowired
    LocationTypeService locationTypeService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> create(@RequestBody LocationTypeModel data) {
        RequestResponse returnValue = this.locationTypeService.createData(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateById(@RequestBody LocationTypeModel data) {
        RequestResponse returnValue = this.locationTypeService.updateById(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete"})
    public ResponseEntity<RequestResponse> deleteById(@RequestBody InputIdModel id) {
        RequestResponse returnValue = this.locationTypeService.deleteLocationTypeById(id);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getAllLocationTypeByFilter(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.locationTypeService.getAllLocationTypeByFilter(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

