/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.systemInfo.controller;

import com.coraltele.helper.BashCmd;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.billing.main.fax.controller.FaxController;
import com.coraltele.service.systemInfo.model.PortValidatorModel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/telemetry/systemInfo", "/app/v2/telemetry/systemInfo"})
public class SystemInformationController {
    private static final Logger logger = LogManager.getLogger(FaxController.class);
    @Autowired
    BashCmd command;

    @PostMapping(value={"/uptime"})
    public ResponseEntity<RequestResponse> getUpTime() {
        RequestResponse returnValue = this.command.getUptime();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            logger.info("SystemInformationController:" + returnValue.getMessage());
            return ResponseEntity.ok((Object)returnValue);
        }
        logger.error("SystemInformationController:" + returnValue.getMessage());
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/loadAverage"})
    public ResponseEntity<RequestResponse> getLoadAverage() {
        RequestResponse returnValue = this.command.getLoadAverages();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/cpuInfo"})
    public ResponseEntity<RequestResponse> getCpuUsed() {
        RequestResponse returnValue = this.command.getCPUPercentage();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/realMemory"})
    public ResponseEntity<RequestResponse> getRealMemory() {
        RequestResponse returnValue = this.command.getRealMemory();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/virtualMemory"})
    public ResponseEntity<RequestResponse> getVirtualMemory() {
        RequestResponse returnValue = this.command.getVirtualMemory();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/runningProcess"})
    public ResponseEntity<RequestResponse> getRunningProcess() {
        RequestResponse returnValue = this.command.getTotalRunningProcess();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/diskStorage"})
    public ResponseEntity<RequestResponse> getDiskSize() {
        RequestResponse returnValue = this.command.getDiskSpace();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/additionalInfo"})
    public ResponseEntity<RequestResponse> getRestInfo() {
        RequestResponse returnValue = this.command.getAdditionalInformation();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/ioMonitor"})
    public ResponseEntity<RequestResponse> getIPDetailAsMonitorIO() {
        RequestResponse returnValue = this.command.ioMonitor();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/portValidation"})
    public ResponseEntity<RequestResponse> availabilityOfPort(@RequestBody PortValidatorModel data) throws IllegalArgumentException {
        RequestResponse returnValue = this.command.portAvailabilityChecker(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

