/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.syncData.service;

import com.coraltele.db.telephony.main.repository.SyncLogRepository;
import com.coraltele.db.telephony.pbx.entity.NodeConfiguration;
import com.coraltele.db.telephony.pbx.repository.NodeConfigurationRepository;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.syncData.model.RestoreConfig;
import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PostgresRestoreService {
    private static final Logger logger = LogManager.getLogger(PostgresRestoreService.class);
    @Autowired
    NodeConfigurationRepository nodeConfigurationRepository;
    @Autowired
    SyncLogRepository syncLogRepository;
    private final String BACKUP_BASE_PATH = "/tmp/db/backups";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse restoreToAllServers(long backupVersion) {
        RequestResponse returnValue = new RequestResponse();
        logger.info("Starting restore to all servers...");
        List<RestoreConfig> restoreConfigs = Arrays.asList(new RestoreConfig("users", false, null), new RestoreConfig("switch", false, null), new RestoreConfig("coralapps", true, Arrays.asList("agents", "members", "tiers")));
        logger.info("List of Target Servers to Sync:{}", (Object)this.getBackupServers());
        for (String serverIp : this.getBackupServers()) {
            logger.info("Restoring to server: {}", (Object)serverIp);
            for (RestoreConfig config : restoreConfigs) {
                String dbName = config.getDbName();
                Optional syncLog = this.syncLogRepository.findByVersionAndDbName(Long.valueOf(backupVersion), dbName);
                if (!syncLog.isPresent()) {
                    logger.error("No SyncLog found for DB {} and version {}", (Object)dbName, (Object)backupVersion);
                    continue;
                }
                try {
                    logger.info("Starting restore for DB: {} (Partial: {})", (Object)config.getDbName(), (Object)config.isPartial());
                    this.blockNewConnections(serverIp, config.getDbName(), "postgres", "Pgadmin@123");
                    String backupPath = this.getLatestBackupPath(config.getDbName());
                    logger.info("Latest backup path for {}: {}", (Object)config.getDbName(), (Object)backupPath);
                    this.restoreDatabaseToRemote(config.getDbName(), backupPath, config.isPartial(), config.getTables(), serverIp, "postgres", "Pgadmin@123");
                    logger.info("Restore completed successfully for DB: {} on {}", (Object)config.getDbName(), (Object)serverIp);
                    returnValue.setStatus(Constants.Error.OK);
                    returnValue.setMessage("Restore completed successfully");
                }
                catch (Exception ex) {
                    logger.error("Restore failed for DB: {} on {}", (Object)config.getDbName(), (Object)serverIp, (Object)ex);
                    returnValue.setStatus(Constants.Error.ERROR);
                    returnValue.setMessage("Restore failed");
                }
                finally {
                    try {
                        this.unblockNewConnections(serverIp, config.getDbName(), "postgres", "Pgadmin@123");
                    }
                    catch (Exception e) {
                        logger.error("Failed to unblock connections for DB: {} on {}", (Object)config.getDbName(), (Object)serverIp, (Object)e);
                    }
                }
            }
        }
        logger.info("Restore process finished for all servers.");
        return returnValue;
    }

    private void restoreDatabaseToRemote(String dbName, String localBackupPath, boolean isPartial, List<String> tables, String remoteHost, String username, String password) throws Exception {
        String remoteBackupPath = "/tmp/" + Paths.get(localBackupPath, new String[0]).getFileName();
        logger.info("Transferring backup to {}: {}", (Object)remoteHost, (Object)remoteBackupPath);
        ProcessBuilder scpBuilder = new ProcessBuilder("scp", localBackupPath, "coral@" + remoteHost + ":" + remoteBackupPath);
        scpBuilder.redirectErrorStream(true);
        Process scpProcess = scpBuilder.start();
        this.printProcessOutput(scpProcess);
        int scpExitCode = scpProcess.waitFor();
        if (scpExitCode != 0) {
            throw new RuntimeException("SCP failed for host " + remoteHost + ", exit code: " + scpExitCode);
        }
        String dropCommand = this.buildDropCommand(dbName, isPartial, tables, username, password);
        logger.info("Executing drop command on {}: {}", (Object)remoteHost, (Object)dropCommand);
        try {
            this.executeSSH(remoteHost, username, dropCommand);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        String restoreCommand = this.buildRestoreCommand(dbName, remoteBackupPath, isPartial, tables, username, password);
        logger.info("Executing restore command on {}: {}", (Object)remoteHost, (Object)restoreCommand);
        try {
            this.executeSSH(remoteHost, username, restoreCommand);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private String buildDropCommand(String dbName, boolean isPartial, List<String> tables, String username, String password) {
        if (isPartial && tables != null) {
            StringBuilder sb = new StringBuilder("bash -c '");
            for (int i = 0; i < tables.size(); ++i) {
                sb.append(String.format("PGPASSWORD=%s psql -U %s -d %s -c \"DROP TABLE IF EXISTS %s CASCADE;\"", password, username, dbName, tables.get(i)));
                if (i >= tables.size() - 1) continue;
                sb.append(" && ");
            }
            sb.append("'");
            return sb.toString();
        }
        return String.format("bash -c 'if PGPASSWORD=%s psql -U %s -tAc \"SELECT 1 FROM pg_database WHERE datname = '\\''%s'\\''\" | grep -q 1; then PGPASSWORD=%s psql -U %s -d postgres -c \"SELECT pg_terminate_backend(pid) FROM pg_stat_activity WHERE datname = '\\''%s'\\'' AND pid <> pg_backend_pid();\" && PGPASSWORD=%s dropdb -U %s %s && PGPASSWORD=%s createdb -U %s %s; else PGPASSWORD=%s createdb -U %s %s; fi'", password, username, dbName, password, username, dbName, password, username, dbName, password, username, dbName, password, username, dbName);
    }

    private String buildRestoreCommand(String dbName, String backupPath, boolean isPartial, List<String> tables, String username, String password) {
        String tableOptions = "";
        if (isPartial && tables != null && !tables.isEmpty()) {
            tableOptions = tables.stream().map(t -> "-t " + t).reduce("", (a, b) -> a + " " + b);
        }
        return String.format("PGPASSWORD=%s pg_restore -U %s -d %s -h localhost %s %s", password, username, dbName, tableOptions.trim(), backupPath);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void executeSSH(String host, String user, String command) throws Exception {
        List<String> sshCommand = Arrays.asList("ssh", "coral@" + host, command);
        logger.info("SSH command: {}", (Object)String.join((CharSequence)" ", sshCommand));
        ProcessBuilder builder = new ProcessBuilder(sshCommand);
        builder.redirectErrorStream(true);
        Process process = builder.start();
        ArrayList<String> outputLines = new ArrayList<String>();
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            String line2;
            while ((line2 = reader.readLine()) != null) {
                outputLines.add(line2);
                logger.debug("[ProcessOutput] {}", (Object)line2);
            }
        }
        int code = process.waitFor();
        if (code == 0) {
            logger.info("Command executed successfully on host {}", (Object)host);
            return;
        }
        boolean onlyWarnings = outputLines.stream().anyMatch(line -> line.contains("warning:") || line.contains("could not execute query"));
        if (onlyWarnings) {
            logger.warn("Restore completed with warnings on host {}: {}", (Object)host, (Object)command);
            return;
        }
        logger.error("Restore failed with exit code {} on host {}: {}", (Object)code, (Object)host, (Object)command);
        throw new RuntimeException("SSH command failed with errors on " + host + ": " + command);
    }

    private String getLatestBackupPath(String dbName) {
        try {
            return Files.list(Paths.get("/tmp/db/backups", dbName)).filter(f -> f.toString().endsWith(".backup")).sorted((f1, f2) -> Long.compare(f2.toFile().lastModified(), f1.toFile().lastModified())).map(f -> f.toAbsolutePath().toString()).findFirst().orElseThrow(() -> new RuntimeException("No backup found for " + dbName));
        }
        catch (Exception e) {
            logger.error("Error fetching latest backup for DB: {}", (Object)dbName, (Object)e);
            throw new RuntimeException("Error fetching backup for " + dbName, e);
        }
    }

    private void printProcessOutput(Process process) {
        try (BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));){
            reader.lines().forEach(line -> logger.debug("[ProcessOutput] {}", line));
        }
        catch (IOException e) {
            logger.error("Error reading process output", (Throwable)e);
        }
    }

    private void blockNewConnections(String remoteHost, String dbName, String username, String password) throws Exception {
        String blockCmd = String.format("bash -c 'PGPASSWORD=%s psql -U %s -d %s -c \"ALTER DATABASE %s CONNECTION LIMIT 0;\"'", password, username, dbName, dbName);
        this.executeSSH(remoteHost, username, blockCmd);
        logger.info("Blocked new connections to DB {} on {}", (Object)dbName, (Object)remoteHost);
    }

    private void unblockNewConnections(String remoteHost, String dbName, String username, String password) throws Exception {
        String unblockCmd = String.format("bash -c 'PGPASSWORD=%s psql -U %s -d %s -c \"ALTER DATABASE %s CONNECTION LIMIT -1;\"'", password, username, dbName, dbName);
        this.executeSSH(remoteHost, username, unblockCmd);
        logger.info("Allowed new connections to DB {} on {}", (Object)dbName, (Object)remoteHost);
    }

    public List<String> getBackupServers() {
        ArrayList<String> list = new ArrayList<String>();
        try {
            List ipList = this.nodeConfigurationRepository.findAll();
            if (ipList != null && !ipList.isEmpty()) {
                for (NodeConfiguration data : ipList) {
                    if (data.getServerCode().equals(this.getServerCode())) continue;
                    list.add(data.getVirtualIp());
                    logger.info("Target server for restore: {}", (Object)data.getVirtualIp());
                }
            } else {
                logger.warn("No node configurations found.");
            }
        }
        catch (Exception e) {
            logger.error("Error fetching node configurations", (Throwable)e);
        }
        return list;
    }

    public String getSourceServer() {
        Optional ipList = this.nodeConfigurationRepository.findByServerCode(this.getServerCode());
        if (ipList.isPresent()) {
            return ((NodeConfiguration)ipList.get()).getVirtualIp();
        }
        return "";
    }

    public String getServerIp() {
        try {
            Optional ipAddress = this.nodeConfigurationRepository.findByServerCode(this.getServerCode());
            if (ipAddress.isPresent()) {
                logger.info("Current server IP: {}", (Object)((NodeConfiguration)ipAddress.get()).getIpAddress());
                return ((NodeConfiguration)ipAddress.get()).getIpAddress().trim();
            }
            logger.error("Server IP not found for code: {}", (Object)this.getServerCode());
        }
        catch (Exception e) {
            logger.error("Error fetching current server IP", (Throwable)e);
        }
        return "";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String getServerCode() {
        Properties prop = new Properties();
        String fileName = "/etc/coraltelecom/callserver.manager.conf";
        try (FileInputStream input = new FileInputStream(fileName);){
            prop.load(input);
            String serverCode = prop.getProperty("servercode", "").trim();
            if (!serverCode.isEmpty()) {
                logger.info("Current ServerCode: {}", (Object)serverCode);
                String string = serverCode;
                return string;
            }
            logger.warn("ServerCode not found in config");
            return "";
        }
        catch (Exception e) {
            logger.error("Unable to load ServerCode from config", (Throwable)e);
        }
        return "";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse restoreToSelectedServer(long backupVersion, String serverIp) {
        RequestResponse returnValue = new RequestResponse();
        logger.info("Starting restore to selected server: {}", (Object)serverIp);
        List<RestoreConfig> restoreConfigs = Arrays.asList(new RestoreConfig("users", false, null), new RestoreConfig("switch", false, null), new RestoreConfig("coralapps", true, Arrays.asList("agents", "members", "tiers")));
        if (this.getBackupServers().isEmpty()) {
            logger.warn("No target servers found for sync.");
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("No target servers found to perform restore.");
            return returnValue;
        }
        logger.info("List of Target Servers to Sync: {}", (Object)this.getBackupServers());
        for (RestoreConfig config : restoreConfigs) {
            String dbName = config.getDbName();
            Optional syncLog = this.syncLogRepository.findByVersionAndDbName(Long.valueOf(backupVersion), dbName);
            if (syncLog == null) {
                logger.error("No SyncLog found for DB '{}' and version '{}'. Skipping restore for this DB.", (Object)dbName, (Object)backupVersion);
                continue;
            }
            try {
                logger.info("Starting restore for DB: '{}' (Partial: {})", (Object)dbName, (Object)config.isPartial());
                this.blockNewConnections(serverIp, dbName, "postgres", "Pgadmin@123");
                logger.info("Restore completed successfully for DB: '{}' on '{}'", (Object)dbName, (Object)serverIp);
            }
            catch (Exception ex) {
                logger.error("Restore failed for DB: '{}' on '{}'", (Object)dbName, (Object)serverIp, (Object)ex);
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Restore failed for one or more databases. Check logs for details.");
            }
            finally {
                try {
                    this.unblockNewConnections(serverIp, dbName, "postgres", "Pgadmin@123");
                }
                catch (Exception e) {
                    logger.error("Failed to unblock connections for DB: '{}' on '{}'", (Object)dbName, (Object)serverIp, (Object)e);
                }
            }
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Restore process finished. Check individual DB logs for details.");
        logger.info("Restore process completed for selected server: {}", (Object)serverIp);
        return returnValue;
    }
}

