/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.fileConfiguration.sipPhoneConfiguration.service;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.fileConfiguration.sipPhoneConfiguration.model.SipPhoneButtonModel;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class SipPhoneButtonService {
    private static final Logger logger = LogManager.getLogger(SipPhoneButtonService.class);
    private static String storePathConfiguration = "/etc/coraltele/conf/sipphone.config";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RequestResponse getSipPhoneButtonConfiguration() {
        RequestResponse returnValue = new RequestResponse();
        Properties prop = new Properties();
        FileInputStream input = null;
        FileOutputStream output = null;
        try {
            input = new FileInputStream(storePathConfiguration);
            prop.load(input);
        }
        catch (FileNotFoundException e) {
            try {
                output = new FileOutputStream(storePathConfiguration);
                prop.setProperty("mute", "true");
                prop.setProperty("hold", "true");
                prop.setProperty("blindTransfer", "true");
                prop.setProperty("thirdPartyConference", "true");
                prop.setProperty("manualCall", "true");
                prop.setProperty("startCall", "true");
                prop.setProperty("consultTransfer", "true");
                prop.setProperty("crm", "true");
                prop.store(output, "Default values for SIP phone configuration");
            }
            catch (Exception ex) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Failed ");
                returnValue.setMessageDetail("Unable to create file with default values");
                logger.error("Error creating file with default values", (Throwable)ex);
                RequestResponse requestResponse = returnValue;
                return requestResponse;
            }
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed ");
            returnValue.setMessageDetail("Unable to retrieve data from file");
            logger.error("Error while getting data from file", (Throwable)e);
            RequestResponse ex = returnValue;
            return ex;
        }
        finally {
            try {
                if (input != null) {
                    ((InputStream)input).close();
                }
                if (output != null) {
                    ((OutputStream)output).close();
                }
            }
            catch (Exception e) {
                logger.error("Error closing streams", (Throwable)e);
            }
        }
        RequestResponse response = new RequestResponse();
        response.setStatus(Constants.Error.OK);
        response.setMessage("Retrieved");
        response.setMessageDetail("Data Retrieved Successfully");
        SipPhoneButtonModel sipPhoneButton = new SipPhoneButtonModel();
        sipPhoneButton.setMute(Boolean.valueOf(prop.getProperty("mute")).booleanValue());
        sipPhoneButton.setHold(Boolean.valueOf(prop.getProperty("hold")).booleanValue());
        sipPhoneButton.setBlindTransfer(Boolean.valueOf(prop.getProperty("blindTransfer")).booleanValue());
        sipPhoneButton.setThirdPartyConference(Boolean.valueOf(prop.getProperty("thirdPartyConference")).booleanValue());
        sipPhoneButton.setManualCall(Boolean.valueOf(prop.getProperty("manualCall")).booleanValue());
        sipPhoneButton.setStartCall(Boolean.valueOf(prop.getProperty("startCall")).booleanValue());
        sipPhoneButton.setConsultTransfer(Boolean.valueOf(prop.getProperty("consultTransfer")).booleanValue());
        sipPhoneButton.setCrm(Boolean.valueOf(prop.getProperty("crm")).booleanValue());
        response.setData((Object)sipPhoneButton);
        logger.info("Data stored successfully");
        return response;
    }
}

