/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.fileConfiguration.priConfiguration.service;

import com.coraltele.helper.Constants;
import com.coraltele.helper.PublishPRI;
import com.coraltele.helper.RequestResponse;
import com.coraltele.service.pbx.fileConfiguration.priConfiguration.model.PRIConfigurationModel;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.stereotype.Service;

@Service
public class PRIConfigurationService {
    private static final Logger logger = LogManager.getLogger(PRIConfigurationService.class);
    private static String priStorePath = "/etc/coraltele/conf/pri.config";

    public RequestResponse storePRIFile(PRIConfigurationModel data) {
        RequestResponse returnValue = new RequestResponse();
        try {
            File file = new File(priStorePath);
            if (!file.exists()) {
                file.createNewFile();
                logger.info("New File Created Successfully");
            } else {
                logger.info("File Already Exists");
            }
            Properties prop = new Properties();
            FileOutputStream output = new FileOutputStream(priStorePath);
            prop.setProperty("card", data.getCard());
            prop.setProperty("incomingCallRouting", data.getIncomingCallRouting());
            prop.setProperty("outgoingCallRouting", data.getOutgoingCallRouting());
            prop.setProperty("trunkGatewayIp", data.getTrunkGatewayIp());
            prop.setProperty("mode", data.getMode());
            prop.store(output, null);
            output.close();
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Stored ");
            returnValue.setMessageDetail("Data Stored Successfully");
            logger.info("Data Have Been Stored Successfully ");
        }
        catch (FileNotFoundException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("File Not Found");
            returnValue.setMessageDetail("File Not Present At The Server.");
            logger.error("Error while saving data logs ", (Throwable)e);
        }
        catch (IOException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error while Storing Data Into File. ");
            returnValue.setMessageDetail("Unable To Store Data Into File");
            logger.error("Error while saving data logs::", (Throwable)e);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed ");
            returnValue.setMessageDetail("Unable To Store Data Into File");
            logger.error("Error while saving data logs", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse getPRIFile() {
        ArrayList<PRIConfigurationModel> addValue = new ArrayList<PRIConfigurationModel>();
        PRIConfigurationModel returnData = new PRIConfigurationModel();
        RequestResponse returnValue = new RequestResponse();
        FileInputStream input = null;
        Properties prop = new Properties();
        try {
            input = new FileInputStream(priStorePath);
            prop.load(input);
            returnData.setId(1);
            returnData.setCard(prop.getProperty("card"));
            returnData.setIncomingCallRouting(prop.getProperty("incomingCallRouting"));
            returnData.setOutgoingCallRouting(prop.getProperty("outgoingCallRouting"));
            returnData.setTrunkGatewayIp(prop.getProperty("trunkGatewayIp"));
            returnData.setMode(prop.getProperty("mode"));
            addValue.add(returnData);
            ((InputStream)input).close();
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Retrieved ");
            returnValue.setMessageDetail("Data Retrieved Successfully");
            returnValue.setData(addValue);
            logger.info("Data stored successfully");
        }
        catch (FileNotFoundException e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed ");
            returnValue.setMessageDetail("File Not Found");
            logger.error("Error while saving data logs", (Throwable)e);
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Failed ");
            returnValue.setMessageDetail("Unable To Retrieve Data From File");
            logger.error("Error while saving data logs", (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse publishPRI() throws IOException {
        RequestResponse returnValue = new RequestResponse();
        String trunkGatewayIp = "";
        String card = "";
        String mode = "";
        try {
            String line;
            File configFile = new File(priStorePath);
            if (!configFile.exists()) {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("PRI file not found");
                logger.error(returnValue.getMessage());
                return returnValue;
            }
            BufferedReader reader = new BufferedReader(new FileReader(configFile));
            while ((line = reader.readLine()) != null) {
                if (line.startsWith("trunkGatewayIp=")) {
                    trunkGatewayIp = line.substring("trunkGatewayIp=".length());
                    continue;
                }
                if (line.startsWith("card=")) {
                    card = line.substring("card=".length());
                    continue;
                }
                if (!line.startsWith("mode=")) continue;
                mode = line.substring("mode=".length());
            }
            reader.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String logMessage = "Publishing AKOM PRI: card=" + card + ", trunkGatewayIp=" + trunkGatewayIp + ", mode=" + mode;
        logger.info(logMessage);
        PublishPRI.publishAkomPri((String)card, (String)trunkGatewayIp, (String)mode);
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("PRI file successfully published");
        logger.info(returnValue.getMessage());
        return returnValue;
    }
}

