/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.extension.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.pbx.extension.model.CodeBlueModelCreate;
import com.coraltele.service.pbx.extension.model.SwitchAcdExtensionCreate;
import com.coraltele.service.pbx.extension.service.ExtensionRegistrationService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RequestMapping(value={"/api/v2/extensionsSecondary"})
@RestController
public class ExtensionsSecondaryController {
    @Autowired
    ExtensionRegistrationService extRegistrationService;

    @PostMapping(value={"/codeBlue/list"})
    public ResponseEntity<RequestResponse> getCodeBlue(@RequestBody SearchRequest data) {
        RequestResponse returnValue = this.extRegistrationService.getCodeBlue(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/codeBlue/create"})
    public ResponseEntity<RequestResponse> createDataForCodeBlueManager(@RequestBody CodeBlueModelCreate data) {
        RequestResponse returnValue = this.extRegistrationService.createDataForCodeBlueManager(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/codeBlue/update"})
    public ResponseEntity<RequestResponse> updateDataForCodeBlueManager(@RequestBody CodeBlueModelCreate data) {
        RequestResponse returnValue = this.extRegistrationService.updateDataForCodeBlueManager(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/switchAcd/list"})
    public ResponseEntity<RequestResponse> getAllByFilterForSwitchACD(@RequestBody SearchRequest data) {
        RequestResponse returnValue = this.extRegistrationService.getAllByFilterForSwitchACD(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/switchAcd/create"})
    public ResponseEntity<RequestResponse> createDataForSwitchACD(@RequestBody SwitchAcdExtensionCreate data) {
        RequestResponse returnValue = this.extRegistrationService.createDataForSwitchACD(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/switchAcd/update"})
    public ResponseEntity<RequestResponse> updateDataForSwitchACD(@RequestBody SwitchAcdExtensionCreate data) {
        RequestResponse returnValue = this.extRegistrationService.updateDataForSwitchACD(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/associatedQueueAgent/list/{queue}"})
    public ResponseEntity<RequestResponse> associatedQueueWithAgent(@PathVariable String queue) {
        RequestResponse returnValue = this.extRegistrationService.associatedQueueWithAgent(queue);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/nonAssociatedQueueAgent/list/{queue}"})
    public ResponseEntity<RequestResponse> nonAssociatedQueueWithoutAgent(@PathVariable String queue) {
        RequestResponse returnValue = this.extRegistrationService.nonAssociatedQueueWithoutAgent(queue);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/codeBlue/directoryList"})
    public ResponseEntity<RequestResponse> getLDAP() {
        RequestResponse returnValue = this.extRegistrationService.getLDAP();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

