/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.controlRluServer.service;

import com.coraltele.db.telephony.pbx.entity.ControlRluServer;
import com.coraltele.db.telephony.pbx.entity.Extension;
import com.coraltele.db.telephony.pbx.repository.ControlRluServerRepository;
import com.coraltele.db.telephony.pbx.repository.ExtensionsRepository;
import com.coraltele.db.telephony.pbx.specification.ControlRluServerSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.pbx.controlRluServer.model.ControlRluServerCreateModel;
import com.coraltele.service.pbx.controlRluServer.model.ControlRluServerModel;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.time.LocalDateTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.PostConstruct;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;
import org.springframework.util.StringUtils;

@Service
public class ControlRluServerService {
    private static final Logger logger = LogManager.getLogger(ControlRluServerService.class);
    @Autowired
    ControlRluServerRepository controlRluServerRepository;
    @Autowired
    ExtensionsRepository extensionsRepository;

    public String getVirtualIp(String rluCode) {
        String returnValue = "";
        if (rluCode != null && StringUtils.hasText((String)rluCode)) {
            logger.debug("Finding getVirtualIp from rlucode :{}", (Object)rluCode);
            Optional rluCodeData = this.controlRluServerRepository.findByRluCode(rluCode);
            if (rluCodeData.isPresent()) {
                returnValue = ((ControlRluServer)rluCodeData.get()).getVirtualIp();
            }
        } else {
            List allRluCode = this.controlRluServerRepository.findAll();
            if (!allRluCode.isEmpty()) {
                returnValue = ((ControlRluServer)allRluCode.get(0)).getVirtualIp();
            } else {
                returnValue = "";
                logger.info("virtual Ip not exist in table");
            }
        }
        return returnValue;
    }

    public String getFeatureServerIp(String rluCode) {
        String returnValue = "";
        if (!rluCode.isEmpty()) {
            logger.debug(rluCode);
            Optional rluCodeData = this.controlRluServerRepository.findByRluCode(rluCode);
            if (rluCodeData.isPresent()) {
                returnValue = ((ControlRluServer)rluCodeData.get()).getSgwIp();
            }
        } else {
            List allRluCode = this.controlRluServerRepository.findAll();
            if (!allRluCode.isEmpty()) {
                returnValue = ((ControlRluServer)allRluCode.get(0)).getSgwIp();
            } else {
                returnValue = "";
                logger.info("SGWIP Ip not exist in table");
            }
        }
        return returnValue;
    }

    public Integer getRLUCount() {
        return this.controlRluServerRepository.findAll().size();
    }

    public String getRLUCodeForSingle() {
        List list = this.controlRluServerRepository.findAll();
        if (!list.isEmpty()) {
            ControlRluServer data = (ControlRluServer)list.get(0);
            return data.getRluCode();
        }
        return "";
    }

    public List<ControlRluServerModel> virtualIp() {
        List list = this.controlRluServerRepository.findAll();
        ArrayList<ControlRluServerModel> addValue = new ArrayList<ControlRluServerModel>();
        if (list.isEmpty() || list.size() <= 1) {
            addValue.add(new ControlRluServerModel());
            logger.info("Data Not Found");
        } else {
            list.forEach(element -> {
                ControlRluServerModel crs = ControlRluServerModel.builder().virtualIp(element.getVirtualIp()).rluCode(element.getRluCode()).build();
                addValue.add(crs);
            });
            logger.info("Data Found");
        }
        return addValue;
    }

    public RequestResponse createData(ControlRluServerCreateModel data) {
        logger.debug("create new ControlRluServer : {} ", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        try {
            ControlRluServer controlRluServer = new ControlRluServer();
            if (data.getCtrlWithCurrentServer() != null) {
                controlRluServer.setCtrlWithCurrentServer(data.getCtrlWithCurrentServer());
            } else {
                controlRluServer.setCtrlWithCurrentServer(Boolean.valueOf(false));
            }
            controlRluServer.setCurrentStatus(data.getCurrentStatus());
            controlRluServer.setExtraIp(data.getExtraIp());
            controlRluServer.setFromIp(data.getFromIp());
            controlRluServer.setIpAddress(data.getIpAddress());
            if (data.getLastRecoveryEpoch() != null) {
                controlRluServer.setLastRecoveryEpoch(data.getLastRecoveryEpoch());
            } else {
                controlRluServer.setLastRecoveryEpoch(Integer.valueOf(0));
            }
            if (data.getLastRegisTarIonEpoch() != null) {
                controlRluServer.setLastRegisTarIonEpoch(data.getLastRegisTarIonEpoch());
            } else {
                controlRluServer.setLastRegisTarIonEpoch(Integer.valueOf(0));
            }
            if (data.getLastSubscriptionEpoch() != null) {
                controlRluServer.setLastSubscriptionEpoch(data.getLastSubscriptionEpoch());
            } else {
                controlRluServer.setLastSubscriptionEpoch(Integer.valueOf(0));
            }
            controlRluServer.setLocation(data.getLocation());
            controlRluServer.setMacId(data.getMacId());
            controlRluServer.setMsfIp(data.getMsfIp());
            if (data.getMsfIpPort() != null) {
                controlRluServer.setMsfIpPort(data.getMsfIpPort());
            } else {
                controlRluServer.setMsfIpPort(Integer.valueOf(5060));
            }
            controlRluServer.setMsfSgwIp(data.getMsfSgwIp());
            if (data.getMsfSgwIpPort() != null) {
                controlRluServer.setMsfSgwIpPort(data.getMsfSgwIpPort());
            } else {
                controlRluServer.setMsfSgwIpPort(Integer.valueOf(5060));
            }
            if (data.getPreEmpt() != null) {
                controlRluServer.setPreEmpt(data.getPreEmpt());
            } else {
                controlRluServer.setPreEmpt(Boolean.valueOf(false));
            }
            controlRluServer.setRluCode(data.getRluCode());
            if (data.getRluStatus() != null) {
                controlRluServer.setRluStatus(data.getRluStatus());
            } else {
                controlRluServer.setRluStatus(Boolean.valueOf(false));
            }
            controlRluServer.setRluStatusIp(data.getRluStatusIp());
            controlRluServer.setRluType(data.getRluType());
            if (data.getRouterId() != null) {
                controlRluServer.setRouterId(data.getRouterId());
            } else {
                controlRluServer.setRouterId(Integer.valueOf(1));
            }
            controlRluServer.setSgwIp(data.getSgwIp());
            controlRluServer.setSubnet(data.getSubnet());
            controlRluServer.setToIp(data.getToIp());
            if (data.getTrunkGatewayInService() != null) {
                controlRluServer.setTrunkGatewayInService(data.getTrunkGatewayInService());
            } else {
                controlRluServer.setTrunkGatewayInService(Integer.valueOf(1));
            }
            if (data.getUpdateFlag() != null) {
                controlRluServer.setUpdateFlag(data.getUpdateFlag());
            } else {
                controlRluServer.setUpdateFlag(Boolean.valueOf(false));
            }
            controlRluServer.setVirtualIp(data.getVirtualIp());
            controlRluServer.setVirtualIpv6(data.getVirtualIpv6());
            controlRluServer.setVolteIp(data.getVolteIp());
            this.controlRluServerRepository.save((Object)controlRluServer);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("OK");
            returnValue.setMessageDetail("ControlRluServer Created Successfully");
            logger.info(returnValue.getMessage());
        }
        catch (Exception e) {
            returnValue.setStatus(Constants.Error.BAD_CREDENTIAL);
            returnValue.setMessage("Unable to Create ControlRluServer");
            returnValue.setMessageDetail("Contact with Administrator");
            logger.error(returnValue.getMessageDetail(), (Throwable)e);
        }
        return returnValue;
    }

    public RequestResponse deleteById(InputIdModel data) {
        RequestResponse returnValue = new RequestResponse();
        ArrayList addValue = new ArrayList();
        for (Integer ids : data.getIntId()) {
            Optional controlRluServer = this.controlRluServerRepository.findById((Object)ids);
            if (controlRluServer.isPresent()) {
                addValue.add(controlRluServer.get());
                this.controlRluServerRepository.deleteAll(addValue);
                continue;
            }
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Records not found ");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setMessageDetail("ControlRluServer Deleted Successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse updateById(ControlRluServerCreateModel data) {
        logger.debug("Update ControlRluServer {}", (Object)data);
        RequestResponse returnValue = new RequestResponse();
        Optional controlRluServer = this.controlRluServerRepository.findById((Object)data.getId());
        if (!controlRluServer.isPresent()) {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("not found");
            returnValue.setMessageDetail("ControlRluServer not found");
            logger.info(returnValue.getMessage());
            return returnValue;
        }
        if (data.getCtrlWithCurrentServer() != null) {
            ((ControlRluServer)controlRluServer.get()).setCtrlWithCurrentServer(data.getCtrlWithCurrentServer());
        }
        if (data.getCurrentStatus() != null) {
            ((ControlRluServer)controlRluServer.get()).setCurrentStatus(data.getCurrentStatus());
        }
        if (data.getExtraIp() != null) {
            ((ControlRluServer)controlRluServer.get()).setExtraIp(data.getExtraIp());
        }
        if (data.getFromIp() != null) {
            ((ControlRluServer)controlRluServer.get()).setFromIp(data.getFromIp());
        }
        if (data.getIpAddress() != null) {
            ((ControlRluServer)controlRluServer.get()).setIpAddress(data.getIpAddress());
        }
        if (data.getLastRecoveryEpoch() != null) {
            ((ControlRluServer)controlRluServer.get()).setLastRecoveryEpoch(data.getLastRecoveryEpoch());
        }
        if (data.getLastRegisTarIonEpoch() != null) {
            ((ControlRluServer)controlRluServer.get()).setLastRegisTarIonEpoch(data.getLastRegisTarIonEpoch());
        }
        if (data.getLastSubscriptionEpoch() != null) {
            ((ControlRluServer)controlRluServer.get()).setLastSubscriptionEpoch(data.getLastSubscriptionEpoch());
        }
        if (data.getLocation() != null) {
            ((ControlRluServer)controlRluServer.get()).setLocation(data.getLocation());
        }
        if (data.getMacId() != null) {
            ((ControlRluServer)controlRluServer.get()).setMacId(data.getMacId());
        }
        if (data.getMsfIp() != null) {
            ((ControlRluServer)controlRluServer.get()).setMsfIp(data.getMsfIp());
        }
        if (data.getMsfIpPort() != null) {
            ((ControlRluServer)controlRluServer.get()).setMsfIpPort(data.getMsfIpPort());
        }
        if (data.getMsfSgwIp() != null) {
            ((ControlRluServer)controlRluServer.get()).setMsfSgwIp(data.getMsfSgwIp());
        }
        if (data.getMsfSgwIpPort() != null) {
            ((ControlRluServer)controlRluServer.get()).setMsfSgwIpPort(data.getMsfSgwIpPort());
        }
        if (data.getPreEmpt() != null) {
            ((ControlRluServer)controlRluServer.get()).setPreEmpt(data.getPreEmpt());
        }
        if (data.getRluCode() != null) {
            ((ControlRluServer)controlRluServer.get()).setRluCode(data.getRluCode());
        }
        if (data.getRluStatus() != null) {
            ((ControlRluServer)controlRluServer.get()).setRluStatus(data.getRluStatus());
        }
        if (data.getRluStatusIp() != null) {
            ((ControlRluServer)controlRluServer.get()).setRluStatusIp(data.getRluStatusIp());
        }
        if (data.getRluType() != null) {
            ((ControlRluServer)controlRluServer.get()).setRluType(data.getRluType());
        }
        if (data.getRouterId() != null) {
            ((ControlRluServer)controlRluServer.get()).setRouterId(data.getRouterId());
        }
        if (data.getSgwIp() != null) {
            ((ControlRluServer)controlRluServer.get()).setSgwIp(data.getSgwIp());
        }
        if (data.getSubnet() != null) {
            ((ControlRluServer)controlRluServer.get()).setSubnet(data.getSubnet());
        }
        if (data.getToIp() != null) {
            ((ControlRluServer)controlRluServer.get()).setToIp(data.getToIp());
        }
        if (data.getTrunkGatewayInService() != null) {
            ((ControlRluServer)controlRluServer.get()).setTrunkGatewayInService(data.getTrunkGatewayInService());
        }
        if (data.getUpdateFlag() != null) {
            ((ControlRluServer)controlRluServer.get()).setUpdateFlag(data.getUpdateFlag());
        }
        if (data.getVirtualIp() != null) {
            ((ControlRluServer)controlRluServer.get()).setVirtualIp(data.getVirtualIp());
        }
        if (data.getVirtualIpv6() != null) {
            ((ControlRluServer)controlRluServer.get()).setVirtualIp(data.getVirtualIpv6());
        }
        if (data.getVolteIp() != null) {
            ((ControlRluServer)controlRluServer.get()).setVolteIp(data.getVolteIp());
        }
        ((ControlRluServer)controlRluServer.get()).setRecordUpdatedOn(LocalDateTime.now());
        this.controlRluServerRepository.save(controlRluServer.get());
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("Updated");
        returnValue.setMessageDetail("ControlRluServer Updated successfully");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getAllByFilter(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = ControlRluServerSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "ipAddress" : searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy().equals("") || searchRequestData.getSortBy() == null ? "ipAddress" : searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.controlRluServerRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.controlRluServerRepository.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)this.entityToModelConversion(page.getContent()));
        returnValue.setData((Object)responseData);
        returnValue.setMessage("List of Filtered Data");
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public List<ControlRluServerCreateModel> entityToModelConversion(List<ControlRluServer> controlRlu) {
        ArrayList<ControlRluServerCreateModel> addValue = new ArrayList<ControlRluServerCreateModel>();
        for (ControlRluServer data : controlRlu) {
            ControlRluServerCreateModel controlRluServer = new ControlRluServerCreateModel();
            controlRluServer.setId(data.getId());
            controlRluServer.setCtrlWithCurrentServer(data.getCtrlWithCurrentServer());
            controlRluServer.setCurrentStatus(data.getCurrentStatus());
            controlRluServer.setExtraIp(data.getExtraIp());
            controlRluServer.setFromIp(data.getFromIp());
            controlRluServer.setIpAddress(data.getIpAddress());
            controlRluServer.setLastRecoveryEpoch(data.getLastRecoveryEpoch());
            controlRluServer.setLastRegisTarIonEpoch(data.getLastRegisTarIonEpoch());
            controlRluServer.setLastSubscriptionEpoch(data.getLastSubscriptionEpoch());
            controlRluServer.setLocation(data.getLocation());
            controlRluServer.setMacId(data.getMacId());
            controlRluServer.setMsfIp(data.getMsfIp());
            controlRluServer.setMsfIpPort(data.getMsfIpPort());
            controlRluServer.setMsfSgwIp(data.getMsfSgwIp());
            controlRluServer.setMsfSgwIpPort(data.getMsfSgwIpPort());
            controlRluServer.setPreEmpt(data.getPreEmpt());
            controlRluServer.setRluCode(data.getRluCode());
            controlRluServer.setRluStatus(data.getRluStatus());
            controlRluServer.setRluStatusIp(data.getRluStatusIp());
            controlRluServer.setRluType(data.getRluType());
            controlRluServer.setRouterId(data.getRouterId());
            controlRluServer.setSgwIp(data.getSgwIp());
            controlRluServer.setSubnet(data.getSubnet());
            controlRluServer.setToIp(data.getToIp());
            controlRluServer.setTrunkGatewayInService(data.getTrunkGatewayInService());
            controlRluServer.setUpdateFlag(data.getUpdateFlag());
            controlRluServer.setVirtualIp(data.getVirtualIp());
            controlRluServer.setVirtualIpv6(data.getVirtualIpv6());
            controlRluServer.setVolteIp(data.getVolteIp());
            addValue.add(controlRluServer);
        }
        return addValue;
    }

    public RequestResponse getAllControlRluServer() {
        List list = this.controlRluServerRepository.findAll();
        ArrayList<ControlRluServerCreateModel> addValue = new ArrayList<ControlRluServerCreateModel>();
        RequestResponse returnValue = new RequestResponse();
        for (ControlRluServer data : list) {
            ControlRluServerCreateModel controlRluServer = new ControlRluServerCreateModel();
            controlRluServer.setId(data.getId());
            controlRluServer.setCtrlWithCurrentServer(Boolean.valueOf(data.getCtrlWithCurrentServer() != false ? data.getCtrlWithCurrentServer() : false));
            controlRluServer.setCurrentStatus(data.getCurrentStatus());
            controlRluServer.setExtraIp(data.getExtraIp());
            controlRluServer.setFromIp(data.getFromIp());
            controlRluServer.setIpAddress(data.getIpAddress());
            controlRluServer.setLastRecoveryEpoch(data.getLastRecoveryEpoch());
            controlRluServer.setLastRegisTarIonEpoch(data.getLastRegisTarIonEpoch());
            controlRluServer.setLastSubscriptionEpoch(data.getLastSubscriptionEpoch());
            controlRluServer.setLocation(data.getLocation());
            controlRluServer.setMacId(data.getMacId());
            controlRluServer.setMsfIp(data.getMsfIp());
            controlRluServer.setMsfIpPort(data.getMsfIpPort());
            controlRluServer.setMsfSgwIp(data.getMsfSgwIp());
            controlRluServer.setMsfSgwIpPort(data.getMsfSgwIpPort());
            controlRluServer.setPreEmpt(data.getPreEmpt());
            controlRluServer.setRluCode(data.getRluCode());
            controlRluServer.setRluStatus(data.getRluStatus());
            controlRluServer.setRluStatusIp(data.getRluStatusIp());
            controlRluServer.setRluType(data.getRluType());
            controlRluServer.setRouterId(data.getRouterId());
            controlRluServer.setSgwIp(data.getSgwIp());
            controlRluServer.setSubnet(data.getSubnet());
            controlRluServer.setToIp(data.getToIp());
            controlRluServer.setTrunkGatewayInService(data.getTrunkGatewayInService());
            controlRluServer.setUpdateFlag(data.getUpdateFlag());
            controlRluServer.setVirtualIp(data.getVirtualIp());
            controlRluServer.setVirtualIpv6(data.getVirtualIpv6());
            controlRluServer.setVolteIp(data.getVolteIp());
            addValue.add(controlRluServer);
        }
        returnValue.setStatus(Constants.Error.OK);
        returnValue.setMessage("OK");
        returnValue.setData(addValue);
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse getIP() {
        RequestResponse returnValue = new RequestResponse();
        String command = "";
        String domain = Constants.DOMAIN_NAME;
        logger.info("domain:{}", (Object)domain);
        command = String.format("ping -c 1 %s", domain);
        logger.info("command to execute domain:{}", (Object)command);
        try {
            String line;
            Process process = Runtime.getRuntime().exec(command);
            BufferedReader reader = new BufferedReader(new InputStreamReader(process.getInputStream()));
            String ipAddress = null;
            Pattern pattern = Pattern.compile("\\b(?:\\d{1,3}\\.){3}\\d{1,3}\\b");
            while ((line = reader.readLine()) != null) {
                logger.info("Ping Output: {}", (Object)line);
                Matcher matcher = pattern.matcher(line);
                if (!matcher.find()) continue;
                ipAddress = matcher.group();
                break;
            }
            reader.close();
            if (ipAddress != null) {
                returnValue.setStatus(Constants.Error.OK);
                returnValue.setMessage("IP Retrieved Successfully");
                if (ipAddress.equals(Constants.MAIN_SERVER_IP)) {
                    returnValue.setMessageDetail("Main");
                }
                if (ipAddress.equals(Constants.LOCAL_SERVER_IP)) {
                    returnValue.setMessageDetail("Local");
                }
                returnValue.setData((Object)ipAddress);
            } else {
                returnValue.setStatus(Constants.Error.ERROR);
                returnValue.setMessage("Failed to retrieve IP address");
            }
        }
        catch (Exception e) {
            logger.error("Error executing ping command", (Throwable)e);
            returnValue.setStatus(Constants.Error.ERROR);
            returnValue.setMessage("Error executing command: " + e.getMessage());
        }
        return returnValue;
    }

    @PostConstruct
    public List<String> getAllRluVirtualIp() {
        List list = this.controlRluServerRepository.findAll();
        ArrayList<String> virtualIpList = new ArrayList<String>();
        for (ControlRluServer data : list) {
            String virtualIp = data.getVirtualIp();
            if (virtualIp == null || virtualIp.isEmpty()) continue;
            virtualIpList.add(virtualIp);
        }
        logger.info("List of Virtual IP: {}", virtualIpList);
        return virtualIpList;
    }

    public String getRluCodeFinal(String extension) {
        try {
            List rluList = this.controlRluServerRepository.findAllByOrderByIdAsc();
            if (rluList.size() == 1) {
                logger.info("Single RLU present");
                return "";
            }
            Optional extensionData = this.extensionsRepository.findByExtension(extension);
            if (!extensionData.isPresent()) {
                logger.error("Extension not found: {}, Invalid extension", (Object)extension);
                return "";
            }
            String rluCode = ((Extension)extensionData.get()).getRluCode();
            if (StringUtils.hasText((String)rluCode)) {
                for (ControlRluServer rlu : rluList) {
                    if (!rluCode.equalsIgnoreCase(rlu.getRluCode())) continue;
                    logger.info("RLU Code present with {}", (Object)rlu.getRluCode());
                    return rlu.getRluCode();
                }
                logger.info("RLU Code not found in RLU list for extension: {}", (Object)extension);
            }
            for (ControlRluServer rlu : rluList) {
                if (!"main".equalsIgnoreCase(rlu.getRluCode())) continue;
                logger.info("RLU Code present with main: {}", (Object)rlu.getRluCode());
                return rlu.getRluCode();
            }
            String firstRlu = !rluList.isEmpty() ? ((ControlRluServer)rluList.get(0)).getRluCode() : "";
            logger.info("RLU Code according to Ascending Id: {}", (Object)firstRlu);
            return firstRlu;
        }
        catch (Exception e) {
            logger.error("Error retrieving RLU Code for extension {}: {}", (Object)extension, (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    public String getRluIP(String rluCode) {
        try {
            List rluList = this.controlRluServerRepository.findAllByOrderByIdAsc();
            if (StringUtils.hasText((String)rluCode)) {
                for (ControlRluServer rlu : rluList) {
                    if (!rluCode.equalsIgnoreCase(rlu.getRluCode())) continue;
                    logger.info("RLU Code present with {}:{}", (Object)rlu.getRluCode(), (Object)rlu.getVirtualIp());
                    return rlu.getVirtualIp();
                }
            }
            for (ControlRluServer rlu : rluList) {
                if (!"main".equalsIgnoreCase(rlu.getRluCode())) continue;
                logger.info("RLU Code present with {}: {}", (Object)rlu.getRluCode(), (Object)rlu.getVirtualIp());
                return rlu.getVirtualIp();
            }
            String firstRluIP = !rluList.isEmpty() ? ((ControlRluServer)rluList.get(0)).getVirtualIp() : "";
            logger.info("RLU Code according to Ascending Id: {}", (Object)firstRluIP);
            return firstRluIP;
        }
        catch (Exception e) {
            logger.error("Error retrieving RLU Code for {}: {}", (Object)rluCode, (Object)e.getMessage(), (Object)e);
            return "";
        }
    }

    public String getProfileName(String extension) {
        try {
            String rluCode = this.getRluCodeFinal(extension);
            if (rluCode != null && StringUtils.hasText((String)rluCode)) {
                logger.info("RLU Code for profile is: {}", (Object)rluCode);
                return "internal_" + rluCode;
            }
            logger.info("Blank rluCode find");
            return "internal";
        }
        catch (Exception e) {
            logger.error("Error retrieving Profile Name for extension {}: {}", (Object)extension, (Object)e.getMessage(), (Object)e);
            return "internal";
        }
    }
}

