/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.pbx.acdGroup.controller;

import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.SearchRequest;
import com.coraltele.service.pbx.acdGroup.service.AcdService;
import com.coraltele.service.pbx.extension.model.ExtensionsModel;
import com.coraltele.service.pbx.extension_service.model.ServiceCodeAttribute;
import com.coraltele.service.pbx.operator.service.OperatorService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/v2/acd"})
public class AcdGroupController {
    @Autowired
    private AcdService acdService;
    @Autowired
    private OperatorService operatorService;

    @PostMapping(value={"/create"})
    public ResponseEntity<RequestResponse> createExtensionByRange(@RequestBody ServiceCodeAttribute data) {
        RequestResponse returnValue = this.acdService.createExtensionByGivenRange(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/update"})
    public ResponseEntity<RequestResponse> updateExtension(@RequestBody ExtensionsModel data) {
        RequestResponse returnValue = this.acdService.updateAcd(data);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/delete/{extension}"})
    public ResponseEntity<RequestResponse> deleteByExtension(@PathVariable(value="extension") String extension) {
        RequestResponse returnValue = this.acdService.deleteBySingleExtensionValue(extension);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/extensions/ocgroup"})
    public ResponseEntity<RequestResponse> getAllExtension() {
        RequestResponse response = this.operatorService.getAllExtension();
        return response.getStatus().equals((Object)Constants.Error.OK) ? ResponseEntity.ok((Object)response) : new ResponseEntity((Object)response, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/list"})
    public ResponseEntity<RequestResponse> getFilteredExtensions(@RequestBody SearchRequest searchRequest) {
        RequestResponse returnValue = this.acdService.getFilteredExtensionByType(searchRequest);
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }

    @PostMapping(value={"/userWithNoExtension"})
    public ResponseEntity<RequestResponse> getUserWithNoExtension() {
        RequestResponse returnValue = this.acdService.getUserWithNoExtension();
        if (returnValue.getStatus().equals((Object)Constants.Error.OK)) {
            return ResponseEntity.ok((Object)returnValue);
        }
        return new ResponseEntity((Object)returnValue, HttpStatus.BAD_REQUEST);
    }
}

