/*
 * Decompiled with CFR 0.152.
 */
package com.coraltele.service.configuration.nodeConfiguration.service;

import com.coraltele.db.telephony.main.entity.WAns;
import com.coraltele.db.telephony.main.repository.WAnsRepository;
import com.coraltele.db.telephony.main.specification.WAnsSpecification;
import com.coraltele.helper.Constants;
import com.coraltele.helper.RequestResponse;
import com.coraltele.model.InputIdModel;
import com.coraltele.model.SearchRequest;
import com.coraltele.model.SearchResponse;
import com.coraltele.service.configuration.nodeConfiguration.model.WAnsModel;
import java.util.List;
import java.util.Optional;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageRequest;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.data.jpa.domain.Specification;
import org.springframework.stereotype.Service;

@Service
public class WAnsService {
    private static final Logger logger = LogManager.getLogger(WAnsService.class);
    @Autowired
    private WAnsRepository wAnsRepo;

    public List<WAns> getList() {
        return this.wAnsRepo.findAll();
    }

    public RequestResponse getList(SearchRequest searchRequestData) {
        RequestResponse returnValue = new RequestResponse();
        Specification filters = WAnsSpecification.generateFilters((SearchRequest)searchRequestData);
        Sort sort = null;
        if (searchRequestData.getSortDirection().equals("asc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).ascending();
        } else if (searchRequestData.getSortDirection().equals("desc")) {
            sort = Sort.by((String[])new String[]{searchRequestData.getSortBy()}).descending();
        }
        Page page = null;
        page = sort == null ? this.wAnsRepo.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()))) : this.wAnsRepo.findAll(filters, (Pageable)PageRequest.of((int)searchRequestData.getCurrentPage(), (int)(searchRequestData.getPageSize() == 0 ? 10 : searchRequestData.getPageSize()), (Sort)sort));
        SearchResponse responseData = new SearchResponse();
        responseData.setCurrentPage(searchRequestData.getCurrentPage() > page.getTotalPages() ? 0L : (long)searchRequestData.getCurrentPage().intValue());
        responseData.setPageSize((long)page.getSize());
        responseData.setTotalPages((long)page.getTotalPages());
        responseData.setTotalRecords(page.getTotalElements());
        responseData.setCurrentPageData((Object)page.getContent());
        returnValue.setData((Object)responseData);
        return returnValue;
    }

    public RequestResponse register(WAnsModel data) {
        RequestResponse returnValue = new RequestResponse();
        WAns dataToSave = new WAns();
        dataToSave.setName(data.getName());
        dataToSave.setIpLocal(data.getIpLocal());
        dataToSave.setIpPublic(data.getIpPublic());
        dataToSave.setIpRemote(data.getIpRemote());
        dataToSave.setWanType(data.getWanType());
        this.wAnsRepo.save((Object)dataToSave);
        return returnValue;
    }

    public RequestResponse update(WAnsModel data) {
        RequestResponse returnValue = new RequestResponse();
        Optional currentRecord = this.wAnsRepo.findById((Object)data.getId());
        if (currentRecord.isPresent()) {
            WAns dataToSave = (WAns)currentRecord.get();
            dataToSave.setName(data.getName());
            dataToSave.setIpLocal(data.getIpLocal());
            dataToSave.setIpPublic(data.getIpPublic());
            dataToSave.setIpRemote(data.getIpRemote());
            dataToSave.setWanType(data.getWanType());
            this.wAnsRepo.save((Object)dataToSave);
            returnValue.setStatus(Constants.Error.OK);
            returnValue.setMessage("Data updated successfully");
        } else {
            returnValue.setStatus(Constants.Error.RECORDS_NOT_FOUND);
            returnValue.setMessage("Unable to find the record");
        }
        logger.info(returnValue.getMessage());
        return returnValue;
    }

    public RequestResponse delete(InputIdModel dataToDelete) {
        RequestResponse returnValue = new RequestResponse();
        for (Long row : dataToDelete.getId()) {
            this.wAnsRepo.deleteById((Object)row);
        }
        return returnValue;
    }
}

